<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>宗地查询列表</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.1"></script>
    <link rel="stylesheet" href="../lib/bdcui/css/table.css">
    <link rel="stylesheet" href="../lib/bdcui/css/search.css">
</head>
<body>
<div class="bdc-table-box">
    <!--表单模块-->
    <form class="layui-form">
        <div class="layui-form-item pf-form-item">
            <div class="layui-inline">
                <label class="layui-form-label">坐落</label>
                <div class="layui-input-inline">
                    <input type="text" name="tdzl" class="layui-input" placeholder="请输入坐落">
                </div>
            </div>
            <div class="layui-inline">
                <label class="layui-form-label">不动产单元号</label>
                <div class="layui-input-inline">
                    <input type="text" name="bdcdyh" class="layui-input" placeholder="请输入不动产单元号">
                </div>
            </div>
            <div class="layui-inline">
                <label class="layui-form-label">权利人</label>
                <div class="layui-input-inline">
                    <input type="text" name="qlr" class="layui-input" placeholder="请输入权利人">
                </div>
            </div>
            <div class="layui-inline bdc-button-box">
                <button class="layui-btn layui-btn-normal bdc-major-btn" lay-submit="" id="query" lay-filter="query"
                        type="button">
                    查询
                </button>
                <button type="reset" class="layui-btn layui-btn-normal bdc-secondary-btn" id="reset">重置</button>
            </div>
        </div>

    </form>
    <hr class="layui-bg-gray">
    <table id="zdList" lay-data="{id: 'zdList'}" lay-filter="dataTable"></table>
</div>
<script type="text/html" id="toolbarDemo">
    <div class="layui-btn-container">
        <button class="layui-btn layui-btn-sm bdc-table-second-btn" lay-event="addLjz">新增逻辑幢</button>
        <button class="layui-btn layui-btn-sm bdc-table-second-btn" lay-event="addXmxx">新增项目信息</button>

    </div>
</script>
<script src="../lib/bdcui/js/table.js?v=2.0"></script>
<script>
    //绑定回车键
    $(document).keydown(function (event) {
        if (event.keyCode == 13) {
            $("#query").click();
        }
    });
    layui.use(['jquery', 'layer', 'element', 'form', 'table', 'laytpl'], function () {
        var $ = layui.jquery;
        var element = layui.element;
        var form = layui.form;
        var table = layui.table;
        var laytpl = layui.laytpl;
        //提交表单
        form.on("submit(query)", function (data) {
            tableReload('zdList', data.field)
            return false;
        })

        var tableConfig = {
            toolbar: "#toolbarDemo"
            , url: '../zd/listbypage' //数据接口
            , cols: [[
                {type: 'radio', fixed: 'left', align: 'center'},
                {field: 'qlr', title: '权利人'},
                {field: 'djh', title: '地籍号'
                    ,templet: function (d) {
                        return splitDjh(d.djh);
                    }
                },
                {field: 'zl', title: '土地坐落'},
                {field: 'scmj', title: '实测面积'},
                {field: 'bdcdyh', title: '不动产单元号'
                    ,templet: function (d) {
                        return splitBdcdyh(d.bdcdyh);
                    }
                },
                {field: 'fzmj', title: '发证面积'}
            ]]
        }

        //加载表格
        loadDataTablbeByUrl("#zdList", tableConfig);

        //头工具栏事件
        table.on('toolbar(dataTable)', function (obj) {
            var checkStatus = table.checkStatus(obj.config.id);
            var data = checkStatus.data;
            if (data && data.length === 1) {
                if (obj.event === "addLjz") {
                    var index = layer.open({
                        type: 2,
                        title: "新增逻辑幢",
                        maxmin: true,
                        area: ['100%', '100%'],
                        fixed: false,
                        content: '../ljz/saveorupdateljz?djh=' + data[0].djh
                        , end: function (index, layero) {
                            $("#query").click();
                            return false;
                        }
                    });
                    //layer.full(index)
                    return false
                }
                if (obj.event === "addXmxx") {
                    var index = layer.open({
                        type: 2,
                        title: "新增项目信息",
                        maxmin: true,
                        area: ['100%', '100%'],
                        fixed: false,
                        content: '../xmxx/form?lszd=' + data[0].djh
                        , end: function (index, layero) {
                            $("#query").click();
                            return false;
                        }
                    });
                    //layer.full(index)
                    return false
                }
            } else if (obj.event.indexOf("LAYTABLE") < 0) {
                layer.alert("请选择一条数据进行操作")
            }
        });
    })
</script>
</body>

</html>
