<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>宗地查询列表</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.1"></script>
    <link rel="stylesheet" href="../lib/bdcui/css/table.css">
    <link rel="stylesheet" href="../lib/bdcui/css/search.css">
</head>
<body>
<div class="bdc-table-box">
    <!--表单模块-->
    <form class="layui-form">
        <div class="layui-form-item pf-form-item">
            <table class="layui-table" lay-skin="nob">
                <colgroup>
                    <col width="12%">
                    <col width="26%">
                    <col width="12%">
                    <col width="26%">
                    <col>
                </colgroup>
                <tbody>
                <tr>
                    <td class="form-tb-lable">坐落:</td>
                    <td>
                        <input type="text" name="tdzl" class="layui-input" placeholder="请输入坐落">
                    </td>
                    <td class="form-tb-lable">不动产单元号:</td>
                    <td>
                        <input type="text" name="bdcdyh" class="layui-input" placeholder="请输入不动产单元号">
                    </td>
                    <td>
                        <button class="layui-btn layui-btn-normal bdc-major-btn" lay-submit="" id="query"
                                lay-filter="query"
                                type="button">
                            查询
                        </button>
                        <button type="reset" class="layui-btn layui-btn-normal bdc-secondary-btn" id="reset">重置</button>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    </form>
    <hr class="layui-bg-gray">
    <table id="zdList" lay-data="{id: 'zdList'}" lay-filter="dataTable"></table>
</div>
<script src="../lib/bdcui/js/table.js"></script>
<script>
    var fwDcbIndex = "${fwDcbIndex!}"
    //绑定回车键
    $(document).keydown(function (event) {
        if (event.keyCode == 13) {
            $("#query").click();
        }
    });
    layui.use(['jquery', 'element', 'form', 'table', 'laytpl'], function () {
        var $ = layui.jquery;
        var element = layui.element;
        var form = layui.form;
        var table = layui.table;
        var laytpl = layui.laytpl;
        //提交表单
        form.on("submit(query)", function (data) {
            tableReload('zdList', data.field)
            return false;
        })

        var tableConfig = {
            url: '../zd/listbypage' //数据接口
            , cols: [[
                {type: 'numbers', fixed: 'left'},
                {field: 'qlr', title: '权利人'},
                {
                    field: 'djh', title: '地籍号',
                    templet: function (d) {
                        var djh = splitDjh(d.djh);
                        return '<div><a href="javascript:void(0);" onclick="" ' +
                                'lay-event="pickZdxx" class="layui-table-link">'+djh+'</a></div>';
                    }

                },
                {field: 'tdzl', title: '土地坐落'},
                {field: 'scmj', title: '实测面积(单位:㎡)'},
                {field: 'bdcdyh', title: '不动产单元号'
                    ,templet: function (d) {
                        return splitBdcdyh(d.bdcdyh);
                    }
                },
                {field: 'fzmj', title: '发证面积(单位:㎡)'},
            ]]
        }

        //加载表格
        loadDataTablbeByUrl("#zdList", tableConfig);

        //父页面的该页面索引
        var index = parent.layer.getFrameIndex(window.name);
        table.on('tool(dataTable)', function (obj) {
            var data = obj.data;
            if (data) {
                if (obj.event === "pickZdxx") {
                    if (parent.pickZdlistCallback) {
                        parent.pickZdlistCallback(data.djh)
                        parent.layer.close(index);
                    }
                }
            } else {
                layer.alert("当前数据主键缺失，请检查数据");
                return false
            }
        });

    })
</script>
</body>

</html>
