<!DOCTYPE html>
<html lang="zh-cn">
<head>
    <meta charset="utf-8">
    <title>项目内多幢信息</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form.css?v=1.0.2">
    <link rel="stylesheet" href="../lib/bdcui/css/search.css"/>
    <link rel="stylesheet" href="../lib/bdcui/css/table.css"/>
    <link rel="stylesheet" href="../lib/bdcui/css/form-tab.css"/>
    <link rel="stylesheet" href="../css/upload.css?v=1.0.1">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.2"></script>
    <script src="../lib/bdcui/js/form.js?v=1.1"></script>
    <script src="../lib/bdcui/js/table.js"></script>
    <script src="../js/xmxxbg.js?v=1.1"></script>
</head>
<body>
<div class="bdc-form-div">
    <form class="layui-form setOverflow" lay-filter="form">
        <div class="content-title layui-clear">
            <div class="title-btn-area">
                <button class="layui-btn bdc-major-btn" lay-submit="" id="saveForm" lay-filter="saveForm">提交</button>
            </div>
        </div>
        <div class="layui-tab" lay-filter="tabFilter">
            <ul class="layui-tab-title">
                <li class="layui-this">项目信息</li>
                <li id="dcxxTab">调查信息</li>
                <li id="qlrTab">房产权利人</li>
                <li id="ljzTab">逻辑幢列表</li>
                <li id="pmtTab">平面图</li>
            </ul>
            <div class="layui-tab-content">
                <div class="layui-tab-item layui-show">
                    <div class="bdc-tab-btn">
                        <button class="layui-btn layui-btn-sm bdc-secondary-btn layui-hide" id="gjzd" type="button">
                            挂接宗地
                        </button>
                    </div>
                    <div class="basic-info">
                        <div class="title-sign"><a id="xmxx" href="javascript:;"></a></div>
                        <div class="layui-form-item layui-hide">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">fwXmxxIndex</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="fwXmxxIndex" id="fwXmxxIndex"
                                           value="${fwXmxxIndex!}">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">项目名称</label>
                            <div class="layui-input-inline">
                                <input type="text" class="layui-input" name="xmmc">
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">隶属宗地</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" readonly name="lszd" id="lszd"
                                           value="${lszd!}">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋类型</label>
                                <div class="layui-input-inline">
                                    <select name="fwlx" lay-search="" lay-filter="fwlx" class="SZdFwlxDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋性质</label>
                                <div class="layui-input-inline">
                                    <select name="fwxz" lay-search="" lay-filter="fwxz" class="SZdFwxzDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt bdc-two-column">
                                <label class="layui-form-label change-label-width">不动产单元号</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" readonly name="bdcdyh" id="bdcdyh">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">不动产单元状态</label>
                                <div class="layui-input-inline">
                                    <select name="bdczt" lay-search="" lay-filter="bdczt">
                                        <option value="">请选择</option>
                                        <option value="0">不可用</option>
                                        <option value="1">可用</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">交易价格</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="jyjg">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">独用土地面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="dytdmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">分摊土地面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="fttdmj">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">坐落</label>
                            <div class="layui-input-inline">
                                <input type="text" class="layui-input" name="zl">
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">产别</label>
                            <div class="layui-input-inline">
                                <input type="text" class="layui-input" name="cb">
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">备注</label>
                            <div class="layui-input-inline">
                                <textarea class="layui-textarea change-textarea-width" name="bz"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="layui-tab-item">
                    <div class="basic-info" id="dcxxForm">
                        <div class="title-sign"><a id="dcxx" href="javascript:;"></a></div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">调查者</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="dcz" id="dcz">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">调查时间</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="dcsj" id="dcsj">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">产权来源</label>
                            <div class="layui-input-inline">
                                <textarea class="layui-textarea change-textarea-width" name="cqly"></textarea>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">共有情况</label>
                            <div class="layui-input-inline">
                                <textarea class="layui-textarea change-textarea-width" name="gyqk"></textarea>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">附加说明</label>
                            <div class="layui-input-inline">
                                <textarea class="layui-textarea change-textarea-width" name="fjsm"></textarea>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">调查意见</label>
                            <div class="layui-input-inline">
                                <textarea class="layui-textarea change-textarea-width" name="dcyj"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="layui-tab-item">
                    <div class="bdc-tab-btn">
                        <button class="layui-btn layui-btn-sm bdc-secondary-btn" id="addQlr" type="button">新增权利人
                        </button>
                    </div>
                    <div class="basic-info" id="qlrForm">
                        <div class="title-sign"><a id="qlrxx" href="javascript:;"></a></div>
                        <div class="form-margin-area">
                            <div class="basic-info">
                                <!--表单块的标题-->
                                <input type="text" class="layui-input layui-hide" name="fwIndex" id="fwIndex"
                                       value="${fwIndex!}">

                                <div class="layui-collapse" lay-filter="test" id="qlrList">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="layui-tab-item">
                    <div class="bdc-tab-btn">
                    </div>
                    <div class="bdc-search-box">
                        <div class="layui-form">
                            <div class="layui-form-item pf-form-item">
                                <div class="layui-inline">
                                    <label class="layui-form-label">逻辑幢号</label>
                                    <div class="layui-input-inline">
                                        <input type="text" id="search-ljzh" class="layui-input" placeholder="请输入逻辑幢号">
                                    </div>
                                </div>
                                <div class="layui-inline">
                                    <button class="layui-btn layui-btn-normal bdc-major-btn" id="queryLjz"
                                            type="button">查询
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bdc-table-box">
                        <table id="ljzTable" lay-data="{id: 'ljzTable'}" lay-filter="dataTable"></table>
                    </div>
                </div>
                <div class="layui-tab-item">
                    <div class="bdc-tab-btn">
                        <button class="layui-btn layui-btn-sm  bdc-major-btn layui-hide" id="downHst" type="button">下载
                        </button>
                        <button class="layui-btn layui-btn-sm  bdc-delete-btn layui-hide" id="deletHst" type="button">
                            删除
                        </button>
                    </div>
                    <div class="bdc-upload-dragdiv">
                        <div class="layui-upload-drag img-drag" id="hst">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
</body>

<script type="text/html" id="qlrTpl">
    {{# layui.each(d.data, function(index, item){ }}
    {{# var length=d.start+index }}
    <div class="layui-colla-item">
        <div class="layui-colla-title">
            <span id="{{ item.fwFcqlrIndex || ''}}" class="layui-btn layui-btn-sm bdc-delete-btn colla-title-btn"
                  onclick="delQlr(this)">删除
            </span>
            <h3>{{ item.qlr || '权利人'}}</h3>
        </div>
        <div class="layui-colla-content layui-show">
            <div class="layui-form-item layui-hide">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人id</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].fwFcqlrIndex"
                               value="{{ item.fwFcqlrIndex || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].qlr"
                               value="{{ item.qlr || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人证件类型</label>
                    <div class="layui-input-inline">
                        <select name="qlrList[{{length}}].qlrzjlx" lay-search="" lay-filter="zjlx">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdZjllxDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==item.qlrzjlx){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人证件号</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].qlrzjh"
                               value="{{ item.qlrzjh || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人序号</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].qlrbh" value="{{length+1}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">发证机关</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].fzjg"
                               value="{{ item.fzjg || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">性别</label>
                    <div class="layui-input-inline">
                        <select name="qlrList[{{length}}].xb" lay-search="" lay-filter="xb">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdQlrxbDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==item.xb){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">电话</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].dh" value="{{ item.dh || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">邮编</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].yb" value="{{ item.yb || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">工作单位</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].gzdw"
                               value="{{ item.gzdw || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人性质</label>
                    <div class="layui-input-inline">
                        <select name="qlrList[{{length}}].qlrxz" lay-search="" lay-filter="qlrxz">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdQlrxzDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==item.qlrxz){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">共有方式</label>
                    <div class="layui-input-inline">
                        <select name="qlrList[{{length}}].gyfs" lay-search="" lay-filter="gyfs">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdGyfsDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==item.gyfs){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利比例</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].qlbl"
                               value="{{ item.qlbl || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利面积</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="qlrList[{{length}}].qlmj"
                               value="{{ item.qlmj || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">地址</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].dz" value="{{ item.dz || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item change-textarea-margin">
                <label class="layui-form-label change-label-width">备注</label>
                <div class="layui-input-inline">
                    <textarea class="layui-textarea" name="qlrList[{{length}}].bz"
                              value="{{ item.bz || ''}}"></textarea>
                </div>
            </div>
        </div>
    </div>
    {{# }); }}
</script>
<script type="text/html" id="DmMcTpl">
    {{# layui.each(d, function(index, zdItem){ }}
    <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
    {{# }); }}
</script>
<script type="text/html" id="ljzListToolBarTmpl">
    <div class="layui-btn-container">
        <span class="layui-btn layui-btn-xs  bdc-major-btn" lay-event="editLjz">修改</span>
        <span class="layui-btn layui-btn-xs bdc-delete-btn" lay-event="deleteLjz">删除</span>
    </div>
</script>
<script type="text/html" id="toolbar">
    <div class="layui-btn-container">
        <button class="layui-btn layui-btn-sm bdc-table-second-btn" type="button" lay-event="addLjz">新增逻辑幢</button>
        <button class="layui-btn layui-btn-sm bdc-table-second-btn layui-hide" type="button" lay-event="relevanceLjz">关联已有逻辑幢
        </button>
    </div>
</script>
<script type="text/html" id="uploadTpl">
    {{# if(d.srcUrl){ }}
    <img id="img" class="upload-img" src="{{d.srcUrl}}" alt="">
    {{# }else{ }}
    <div class="upload-icon">
        <i class="layui-icon">&#xe654;</i>
        <span>上传平面图</span>
    </div>
    <h4>点击/拖拽单个文件到这里上传</h4>
    <p>支持jpeg、jpg、png格式，大小在10M以下</p>
    <img id="img" class="upload-img" src="" alt="">
    <div class="video-icon"></div>
    {{# } }}
</script>
<script>
    // 文档中心地址
    var storageUrl = '${storageUrl!}';
    // 户室图主键
    var fwHstIndex = '';

    var zdList = {}
    $.ajax({
        url: "../zd/mul",
        dataType: "json",
        data: {zdDoNames: "SZdFwlxDO,SZdFwxzDO,SZdGyfsDO,SZdQlrxzDO,SZdQlrxbDO,SZdZjllxDO"},
        async: false,
        success: function (data) {
            zdList = $.extend({}, data)
        }
    });
    if ($("#lszd").val()) {
        $("#gjzd").addClass("layui-hide")
    }

    layui.use(['form', 'jquery', 'laytpl', 'element', 'laydate', 'table', 'upload'], function () {
        var form = layui.form;
        var $ = layui.jquery;
        var laydate = layui.laydate;
        var laytpl = layui.laytpl;
        var element = layui.element;
        var table = layui.table;
        var upload = layui.upload;

        //处理列表选择
        var tpl = $("#DmMcTpl").html();
        $.each(zdList, function (key, value) {
            laytpl(tpl).render(value, function (html) {
                $("." + key).append(html);
            });
        })

        //form初始化
        form.render();

        laydate.render({
            elem: '#dcsj'
            , type: 'datetime'
        });

        if ($("#fwXmxxIndex").val()) {
            loadFwXmxx();
        }
        //提交表单
        form.on("submit(saveForm)", function (data) {
            var postData = data.field;
            //删除不动产单元号中的空格
            postData.bdcdyh = postData.bdcdyh.replace(/\s*/g, "");
            var formLayer = layer;
            if (parent.layer) {
                formLayer = parent.layer
            }
            var loadIndex = formLayer.load(2, {shade: [0.1, '#fff']});
            $.ajax({
                url: "../xmxx/saveorupdate",
                dataType: "json",
                type: "post",
                data: {jsonData: JSON.stringify(formSubmitDealJson(postData))},
                success: function (data) {
                    formLayer.close(loadIndex);
                    layer.closeAll();
                    if (data && data.success) {
                        formLayer.msg("提交成功");
                        if (data.data) {
                            if (data.data.bdcdyh) {
                                data.data.bdcdyh = splitBdcdyh(data.data.bdcdyh);
                            }
                            form.val("form", data.data)
                        }
                        loadQlrList();
                    } else if (data && data.msg) {
                        formLayer.alert(data.msg)
                    } else {
                        formLayer.alert("提交失败")
                    }
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });

            return false;
        })


        element.on('tab(tabFilter)', function (data) {
            var tabid = $(".layui-tab-title .layui-this").attr("id");
            if (tabid == "qlrTab") {
                if ($("#fwXmxxIndex").val()) {
                    loadQlrList();
                } else {
                    generateQlrList();
                }
                $('#qlrTab').attr('id', 'newQlrTab');
            } else if (tabid == "ljzTab") {
                loadDataTablbeByUrl("#ljzTable", tableConfig);
                $('#ljzTab').attr('id', 'newLjzTab');
            } else if (tabid == "pmtTab") {
                loadPmt();
            }
        });

        upload.render({
            elem: '#hst'
            , url: '../hst/uploadfwljzpmt'
            , data: {
                fwDcbIndex: function () {
                    return $("#fwXmxxIndex").val()
                }
            }
            , accept: 'file'
            , auto: true
            , before: function () {
                var loadIndex = layer.load(1, {shade: [0.3, '#000']});
            }
            , done: function (res) {
                if (res.success && res.imgId && res.fwHstIndex) {
                    fwHstIndex = res.fwHstIndex;
                    var imgUrl = storageUrl + "/rest/files/download/" + res.imgId;
                    renderTpl({srcUrl: imgUrl});
                    layer.closeAll();
                    layer.msg("上传成功");
                } else {
                    layer.closeAll();
                    layer.msg("上传失败");
                }
            }
            , error: function () {
                layer.closeAll();
            }
        });

        function writeFwXmxx(data) {
            if (data.bdcdyh) {
                data.bdcdyh = splitBdcdyh(data.bdcdyh);
            }
            form.val("form", data)
            if (!$("#lszd").val()) {
                $("#gjzd").removeClass("layui-hide")
            }
        }

        //页面入口
        function loadFwXmxx() {
            //获取数据
            var index = layer.load(1, {shade: [0.1, '#fff']});
            $.ajax({
                url: "../xmxx/infofwxmxx",
                dataType: "json",
                data: {
                    fwXmxxIndex: $("#fwXmxxIndex").val()
                },
                success: function (data) {
                    layer.closeAll();
                    //处理查询出来的数据
                    writeFwXmxx(data)
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
        }

        //头工具栏事件
        table.on('toolbar(dataTable)', function (obj) {
            if ($("#fwXmxxIndex").val() && $("#lszd").val()) {
                if (obj.event == "addLjz") {
                    layer.open({
                        type: 2,
                        title: "新增逻辑幢",
                        maxmin: true,
                        area: ['100%', '100%'],
                        fixed: false, //不固定
                        content: '../ljz/saveorupdateljz?fwXmxxIndex=' + $("#fwXmxxIndex").val() + '&djh=' + $("#lszd").val()
                        , end: function (index, layero) {
                            refreshView();
                            return false;
                        }
                    });

                }
                if (obj.event == "relevanceLjz") {
                    var index = layer.open({
                        type: 2,
                        title: "选择逻辑幢",
                        area: ['1300px', '600px'],
                        fixed: false, //不固定
                        content: '../ljz/relevanceLjzlist?lszd='+ $("#lszd").val()
                    });
                }
            } else {
                layer.alert("请先保存项目信息后维护项目下逻辑幢")
            }

        });


        table.on('tool(dataTable)', function (obj) {
            var data = obj.data;
            if (data && data.fw_dcb_index) {
                if (obj.event === "editLjz") { //修改
                    layer.open({
                        type: 2,
                        title: "编辑逻辑幢",
                        maxmin: true,
                        area: ['100%', '100%'],
                        fixed: false, //不固定
                        content: '../ljz/saveorupdateljz?fwDcbIndex=' + data.fw_dcb_index + '&djh=' + data.lszd
                        , end: function (index, layero) {
                            refreshView();
                            return false;
                        }
                    });
                }
                if (obj.event === "deleteLjz") { //删除
                    layer.confirm('真的删除行么', function (index) {
                        deleteLjzFun(data.fw_dcb_index);
                    });
                }
            } else {
                layer.alert("当前数据主键缺失，请检查数据");
                return false
            }
        });
    });

    //添加权利人
    $("#addQlr").click(function () {
        $("html,body").animate({scrollTop: $('#qlrForm').offset().top - 119 + "px"}, 200);
        generateQlrList([{}], $(".layui-colla-item").length);
    })

    var tableConfig = {
        toolbar: "#toolbar"
        , url: '../ljz/listbypage' //数据接口
        , where: {fwXmxxIndex: $("#fwXmxxIndex").val() ? $("#fwXmxxIndex").val() : "rrrrrrr"}
        , cols: [[
            {type: 'radio', fixed: 'left', align: 'center', width: '3%'},
            {type: 'numbers', fixed: 'left', width: '3%'},
            {
                field: 'lszd', title: '隶属宗地', width: '15%'
                , templet: function (d) {
                    return splitDjh(d.lszd);
                }
            },
            {field: 'zrzh', title: '自然幢号', width: '10%'},
            {field: 'ljzh', title: '逻辑幢号', width: '15%'},
            {
                field: 'bdcdyh', title: '不动产单元号', width: '20%'
                , templet: function (d) {
                    return splitBdcdyh(d.bdcdyh);
                }
            },
            {
                field: 'bdcdyfwlx', title: '房屋类型', width: '10%',
                templet: function (d) {
                    return convertZdDmToMc("SZdBdcdyFwlxDO", d.bdcdyfwlx);
                }
            },
            {field: 'fwmc', title: '房屋名称', width: '10%'},
            {title: '操作', align: 'center', fixed: 'right', toolbar: '#ljzListToolBarTmpl', width: '14%'}
        ]]
    }

    function renderTpl(json) {
        $("#hst").removeClass("layui-hide");
        if (json.srcUrl) {
            $("#downHst").removeClass("layui-hide");
            $("#deletHst").removeClass("layui-hide");
        } else {
            $("#downHst").addClass("layui-hide");
            $("#deletHst").addClass("layui-hide");
        }
        layui.use('laytpl', function () {
            //获取模板
            var tpl = $("#uploadTpl").html();
            var laytpl = layui.laytpl;
            //渲染数据
            laytpl(tpl).render(json, function (html) {
                $("#hst").html(html);
            });
        })
    }

    //页面入口
    function loadQlrList() {
        //获取数据
        var index = layer.load(1, {shade: [0.1, '#fff']});
        $.ajax({
            url: "../fwqlr/listqlr",
            dataType: "json",
            data: {
                fwIndex: $("#fwXmxxIndex").val()
            },
            success: function (data) {
                layer.closeAll();
                //处理查询出来的数据
                if (data && data.success) {
                    if (data.data) {
                        generateQlrList(data.data, 0)
                    }
                } else if ($("#qlrList").find(".layui-colla-item").length < 1) {
                    generateQlrList();
                }

            },
            error: function (xhr, status, error) {
                delAjaxErrorMsg(xhr)
            }
        });
    }

    //生成权利人list表单 qlrList：权利人列表 listStartWhith：从第几个开始生成 isFg：是否需要覆盖
    function generateQlrList(qlrList, listStartWhith) {
        layui.use(['form', 'jquery', 'laytpl', 'element'], function () {
            var form = layui.form;
            var $ = layui.jquery;
            var laytpl = layui.laytpl;
            var element = layui.element;
            if (qlrList == null) {
                qlrList = [{}]
            }
            if (listStartWhith == null) listStartWhith = 0;
            var json = {
                start: listStartWhith,
                data: qlrList,
                zdList: zdList
            }
            //获取模板
            var tpl = $("#qlrTpl").html();
            //渲染数据
            laytpl(tpl).render(json, function (html) {
                if (listStartWhith === 0) {
                    //如果覆盖之前的
                    $("#qlrList").html(html);
                } else {
                    $("#qlrList").append(html);
                }
            });
            form.render();
            element.render();
            listStartWhith = listStartWhith + qlrList.length;
            if (qlrList.length == 0) {
                listStartWhith++;
            }
            return listStartWhith;
        })
    }

    function deleteLjzFun(fwDcbIndex) {
        var index = layer.load(2, {shade: [0.1, '#fff']});
        //获取数据
        $.ajax({
            url: "../ljz/delbyfwdcbindex",
            contentType: "application/json;charset=utf-8",
            type: "GET",
            data: {
                fwDcbIndex: fwDcbIndex
            },
            success: function (data) {
                layer.closeAll();
                if (!data || !data.success) {
                    layer.alert("删除失败");
                }
                refreshView();
            },
            error: function (xhr, status, error) {
                delAjaxErrorMsg(xhr)
            }
        });
    }

    function refreshView() {
        $("#queryLjz").click();
    }

    function loadPmt() {
        // 查询 户室图
        var imgElementSrc = $("#img").attr("src");
        if ($("#fwXmxxIndex").val()) {
            if (!imgElementSrc) {
                $.ajax({
                    url: "../hst/queryfwljzpmt",
                    dataType: "json",
                    data: {
                        fwDcbIndex: $("#fwXmxxIndex").val()
                    },
                    async: false,
                    success: function (data) {
                        if (data.fwHstIndex) {
                            fwHstIndex = data.fwHstIndex;
                        }
                        if (data.src) {
                            renderTpl({srcUrl: data.src});
                            $('#pmtTab').attr('id', 'newPmtTab');
                        } else {
                            renderTpl({});
                        }
                    },
                    error: function (xhr, status, error) {
                        delAjaxErrorMsg(xhr)
                    }
                });
            }
        } else {
            $("#hst").addClass("layui-hide");
            layer.alert("请先保存项目信息");
        }
    }

    //删除权利人
    function delQlr(delDom) {
        event.stopPropagation();
        layer.open({
            content: '删除操作后会重新加载数据，确定是否有未提交数据？'
            , btn: ['确定', '取消']
            , yes: function (index, layero) {
                if (delDom.id) {
                    layer.open({
                        content: '这条权利人已经入库，将直接从数据库删除，是否确定？'
                        , btn: ['确定', '取消']
                        , yes: function (index, layero) {
                            $.ajax({
                                url: "../fwqlr/deleteqlr",
                                dataType: "json",
                                data: {
                                    fwFcqlrIndex: delDom.id
                                },
                                success: function (data) {
                                    if (data && data.success) {
                                        layer.msg("成功")
                                        loadQlrList();
                                    } else {
                                        layer.alert("删除失败，请检查数据!")
                                    }
                                    layer.closeAll();
                                },
                                error: function (xhr, status, error) {
                                    delAjaxErrorMsg(xhr)
                                }
                            });
                        }

                    });
                } else {
                    $(delDom).parent().parent().remove();
                    layer.closeAll();
                }
            }
        });

    }

    $("#gjzd").click(function () {
        var index = layer.open({
            type: 2,
            title: "挂接宗地",
            area: ['1300px', '600px'],
            fixed: false, //不固定
            content: '../zd/picklist'
        });
    })

    $("#queryLjz").click(function () {
        if ($("#fwXmxxIndex").val()) {
            tableReload('ljzTable', {ljzh: $("#search-ljzh").val(), fwXmxxIndex: $("#fwXmxxIndex").val()})
        }
    })

    // 下载图片
    $("#downHst").click(function () {
        var srcURL = $("#img").attr("src");
        if (srcURL && srcURL.indexOf("storage") > 0) {
            window.open(srcURL + "?attachment=1");
        } else {
            layer.msg("当前图片不支持下载");
        }
    });

    // 删除按钮
    $("#deletHst").click(function () {
        // 删除户室图
        $.ajax({
            url: "../hst/delfwljzpmt",
            dataType: "json",
            data: {
                fwDcbIndex: $("#fwXmxxIndex").val()
            },
            async: false,
            success: function (data) {
                if (data.success) {
                    renderTpl({});
                    // 户室图主键清空
                    fwHstIndex = "";
                    layer.msg("删除成功");
                }
            },
            error: function (xhr, status, error) {
                delAjaxErrorMsg(xhr)
            }
        });

    });

    //修改逻辑幢对应的地籍号，主要是给挂接宗地用
    function pickZdlistCallback(changeDjh) {
        $("#lszd").val(changeDjh)
        $("#gjzd").addClass("layui-hide")
    }

    function relevanceLjz(data) {
        var fwDcbIndex=data.fw_dcb_index;
        $.ajax({
            url: "../xmxx/relevanceLjz",
            type: "post",
            traditional: true,
            data: {
                fwDcbIndex:fwDcbIndex,
                fwXmxxIndex: $("#fwXmxxIndex").val()
            },
            success: function (data) {
                if (data && data.success) {
                    layer.closeAll()
                    layer.msg(data.msg)
                    refreshView();
                }
            },
            error: function (xhr, status, error) {
                delAjaxErrorMsg(xhr)
            }
        });
    }
</script>
</html>