<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>项目信息查询列表</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js"></script>
    <script src="../js/xmxxbg.js?v=1.1"></script>
    <link rel="stylesheet" href="../lib/bdcui/css/table.css">
    <link rel="stylesheet" href="../lib/bdcui/css/search.css">
</head>
<body>
<div class="bdc-table-box">
    <!--表单模块-->
    <form class="layui-form">
        <div class="layui-form-item pf-form-item">
            <div class="layui-inline">
                <label class="layui-form-label">项目名称</label>
                <div class="layui-input-inline">
                    <input type="text" name="xmmc" class="layui-input" placeholder="请输入项目名称">
                </div>
            </div>
            <div class="layui-inline">
                <label class="layui-form-label">不动产单元号</label>
                <div class="layui-input-inline">
                    <input type="text" name="bdcdyh" class="layui-input" placeholder="请输入不动产单元号">
                </div>
            </div>
            <div class="layui-inline">
                <label class="layui-form-label">坐落</label>
                <div class="layui-input-inline">
                    <input type="text" name="zl" class="layui-input" placeholder="请输入坐落">
                </div>
            </div>
            <div class="layui-inline bdc-button-box">
                <button class="layui-btn layui-btn-normal bdc-major-btn" lay-submit="" id="query" lay-filter="query"
                        type="button">
                    查询
                </button>
                <button type="reset" class="layui-btn layui-btn-normal bdc-secondary-btn" id="reset">重置</button>
            </div>
        </div>
    </form>
    <hr class="layui-bg-gray">
    <table id="zdList" lay-data="{id: 'zdList'}" lay-filter="dataTable"></table>
</div>
<script type="text/html" id="toolbarDemo">
    <div class="layui-btn-container">
        <button class="layui-btn layui-btn-sm bdc-table-second-btn" lay-event="mergeXmxx">合并</button>
        <button class="layui-btn layui-btn-sm bdc-table-second-btn" lay-event="delete">删除</button>
    </div>
</script>
<script type="text/html" id="xmxxListToolBarTmpl">
    <div class="layui-btn-container">
        <span class="layui-btn layui-btn-xs bdc-major-btn" lay-event="editXmxx">修改</span>
        <a class="layui-btn layui-btn-xs bdc-secondary-btn bdc-more-btn">
            更多<i class="layui-icon layui-icon-down"></i>
        </a>
        <div class="bdc-table-btn-more">
            <a lay-event="xmxxMs">项目灭失</a>
            <a lay-event="xmxxBg">项目变更</a>
        </div>
    </div>
</script>
<script src="../lib/bdcui/js/table.js?v=1.0"></script>
<script>
    //绑定回车键
    $(document).keydown(function (event) {
        if (event.keyCode == 13) {
            $("#query").click();
        }
    });
    layui.use(['jquery', 'layer', 'element', 'form', 'table', 'laytpl'], function () {
        var $ = layui.jquery;
        var element = layui.element;
        var form = layui.form;
        var table = layui.table;
        var laytpl = layui.laytpl;
        //提交表单
        form.on("submit(query)", function (data) {
            tableReload('zdList', data.field);
            return false;
        });

        var tableConfig = {
            toolbar: "#toolbarDemo"
            , url: '../xmxx/listbypage' //数据接口
            , cols: [[
                {type: 'checkbox', fixed: 'left', align: 'center', width: '4%'},
                {field: 'xmmc', title: '项目名称', width: '15%'},
                {field: 'lszd', title: '隶属宗地', width: '15%'
                    ,templet: function (d) {
                        return splitDjh(d.lszd || '');
                    }
                },
                {field: 'bdcdyh', title: '不动产单元号', width: '20%'
                    ,templet: function (d) {
                        return splitBdcdyh(d.bdcdyh);
                    }
                },
                {field: 'zl', title: '坐落', width: '20%'},
                {
                    field: 'bdczt', title: '不动产单元状态', width: '13%',
                    templet: function (d) {
                        var returnVal = "";
                        if (d.bdczt == "0") {
                            returnVal = "不可用"
                        } else if (d.bdczt == "1") {
                            returnVal = "可用"
                        } else if (d.bdczt) {
                            returnVal = d.bdczt
                        }
                        return returnVal;
                    }
                },
                {title: '操作', align: 'center', fixed: 'right', toolbar: '#xmxxListToolBarTmpl', width: '13%'}
            ]]
        }

        //加载表格
        loadDataTablbeByUrl("#zdList", tableConfig);

        //头工具栏事件
        table.on('toolbar(dataTable)', function (obj) {
            //获取选中行状态
            var checkStatus = table.checkStatus(obj.config.id);
            var data = checkStatus.data;
            if (obj.event === "mergeXmxx") {
                if (data && data.length > 1) {
                    xmxxHb(data)
                } else {
                    layer.alert("请选择多条数据进行操作");
                }
            }
            if (obj.event === "delete") {
                if (data && data.length > 0) {
                    deleteXmxx(data)
                } else {
                    layer.alert("请选择至少一条数据进行操作");
                }
            }
        });
        table.on('tool(dataTable)', function (obj) {
            var data = obj.data;
            if (data && data.fwXmxxIndex) {
                if (obj.event === "editXmxx") { //修改
                    var index = layer.open({
                        type: 2,
                        title: "编辑项目信息",
                        maxmin: true,
                        area: ['100%', '100%'],
                        fixed: false, //不固定
                        content: '../xmxx/form?fwXmxxIndex=' + data.fwXmxxIndex
                        , end: function (index, layero) {
                            $("#query").click();
                            return false;
                        }
                    });
                    layer.full(index)
                }
                if (obj.event === "xmxxBg") { //变更
                    xmxxBg(data);
                }
                if (obj.event === "xmxxMs") { //灭失
                    xmxxMsView(data);
                }
                if (obj.event === "queryBgjl") { //变更记录查看
                    layer.alert("该功能正在开发哟");
                }
            } else {
                layer.alert("当前数据主键缺失，请检查数据");
                return false
            }
        });

        function deleteXmxx(data) {
            var fwXmxxIndexList = [];
            for (var i = 0; i < data.length; i++) {
                fwXmxxIndexList.push(data[i].fwXmxxIndex);
            }
            // loading加载
            var loadIndex = layer.load(2, {shade: [0.1, '#fff']});
            $.ajax({
                url: "../xmxx/delbyindex",
                type: "GET",
                data: "fwXmxxIndexList=" + encodeURI(fwXmxxIndexList),
                success: function (data) {
                    layer.closeAll();
                    if (!data || !data.success) {
                        layer.alert("删除失败");
                    }
                    $("#query").click();
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
        }
    })
</script>
</body>

</html>
