<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>项目基本信息变更</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form.css">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.0"></script>
    <script src="../js/xmxxbg.js?v=1.1"></script>
</head>
<body>
<div class="bdc-form-div">
    <form class="layui-form setOverflow" lay-filter="form">
        <div class="content-title layui-clear">
            <div class="title-btn-area">
                <button class="layui-btn bdc-major-btn" lay-submit="" id="saveInfo" lay-filter="saveInfo"
                        type="button">提交
                </button>
            </div>
        </div>
        <div class="form-margin-area">
            <div class="basic-info">
                <div class="layui-form-item layui-hide">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">fwXmxxIndex</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="fwXmxxIndex" id="fwXmxxIndex"
                                   value="${fwXmxxIndex!}">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item change-textarea-margin">
                    <label class="layui-form-label change-label-width">项目名称</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="xmmc">
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">隶属宗地</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" readonly name="lszd" id="lszd"
                                   value="${lszd!}">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋类型</label>
                        <div class="layui-input-inline">
                            <select name="fwlx" lay-search="" lay-filter="fwlx" class="SZdFwlxDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋性质</label>
                        <div class="layui-input-inline">
                            <select name="fwxz" lay-search="" lay-filter="fwxz" class="SZdFwxzDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width">不动产单元号</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" readonly name="bdcdyh" id="bdcdyh">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">不动产单元状态</label>
                        <div class="layui-input-inline">
                            <select name="bdczt" lay-search="" lay-filter="bdczt">
                                <option value="">请选择</option>
                                <option value="0">不可用</option>
                                <option value="1">可用</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">交易价格</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="jyjg">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">独用土地面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="dytdmj">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">分摊土地面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="fttdmj">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item change-textarea-margin">
                    <label class="layui-form-label change-label-width">坐落</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="zl">
                    </div>
                </div>
                <div class="layui-form-item change-textarea-margin">
                    <label class="layui-form-label change-label-width">产别</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="cb">
                    </div>
                </div>
                <div class="layui-form-item change-textarea-margin">
                    <label class="layui-form-label change-label-width">备注</label>
                    <div class="layui-input-inline">
                        <textarea class="layui-textarea change-textarea-width" name="bz"></textarea>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script type="text/html" id="DmMcTpl">
    {{# layui.each(d, function(index, zdItem){ }}
    <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
    {{# }); }}
</script>
<script src="../lib/bdcui/js/form.js"></script>
<script>
    var zdList = {};
    var bgbh = "${bgbh!}"
    $.ajax({
        url: "../zd/mul",
        dataType: "json",
        data: {zdDoNames: "SZdFwlxDO,SZdFwxzDO"},
        async: false,
        success: function (data) {
            zdList = $.extend({}, data)
        },
        error: function (xhr, status, error) {
            delAjaxErrorMsg(xhr)
        }
    });
    layui.use(['form', 'jquery', 'laytpl', 'element', 'laydate'], function () {
        var form = layui.form;
        var $ = layui.jquery;
        var laytpl = layui.laytpl;
        //处理列表选择
        var tpl = $("#DmMcTpl").html();
        $.each(zdList, function (key, value) {
            laytpl(tpl).render(value, function (html) {
                $("." + key).append(html);
            });
        })

        //form初始化
        form.render();

        if ($("#fwXmxxIndex").val()) {
            loadFwXmxx();
        }
        //提交表单
        form.on("submit(saveInfo)", function (data) {
            var postData = data.field;
            //删除不动产单元号中的空格
            postData.bdcdyh = postData.bdcdyh.replace(/\s*/g,"");
            if (bgbh) {
                xmxxJbxxBg(data, bgbh);
            }else{
                layer.alert("变更编号不能为空");
            }
            return false;
        })

        function writeFwXmxx(data) {
            if(data.bdcdyh){
                data.bdcdyh = splitBdcdyh(data.bdcdyh);
            }
            form.val("form", data)
        }

        //页面入口
        function loadFwXmxx() {
            //获取数据
            var index = layer.load(1, {shade: [0.1, '#fff']});
            $.ajax({
                url: "../xmxx/infofwxmxx",
                dataType: "json",
                data: {
                    fwXmxxIndex: $("#fwXmxxIndex").val()
                },
                success: function (data) {
                    layer.closeAll();
                    //处理查询出来的数据
                    writeFwXmxx(data)
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
        }
    });
</script>
</body>

</html>
