<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>项目信息选择列表</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.1"></script>
    <link rel="stylesheet" href="../lib/bdcui/css/table.css">
    <link rel="stylesheet" href="../lib/bdcui/css/search.css">
</head>
<body>
<div class="bdc-table-box" style="background-color:white">
    <!--表单模块-->
    <form class="layui-form">
        <div class="layui-form-item pf-form-item">
            <div class="layui-inline">
                <label class="layui-form-label">项目名称</label>
                <div class="layui-input-inline">
                    <input type="text" name="xmxx" class="layui-input" placeholder="请输入项目名称">
                </div>
            </div>
            <div class="layui-inline">
                <label class="layui-form-label">不动产单元号</label>
                <div class="layui-input-inline">
                    <input type="text" name="bdcdyh" class="layui-input" placeholder="请输入不动产单元号">
                </div>
            </div>
            <div class="layui-inline">
                <label class="layui-form-label">坐落</label>
                <div class="layui-input-inline">
                    <input type="text" name="zl" class="layui-input" placeholder="请输入坐落">
                </div>
            </div>
            <div class="layui-inline bdc-button-box">
                <button class="layui-btn layui-btn-normal bdc-major-btn" lay-submit="" id="query" lay-filter="query"
                        type="button">
                    查询
                </button>
                <button type="reset" class="layui-btn layui-btn-normal bdc-secondary-btn" id="reset">重置</button>
            </div>
        </div>
    </form>
    <hr class="layui-bg-gray">
    <table id="tableList" lay-data="{id: 'tableList'}" lay-filter="dataTable"></table>
</div>
<script type="text/html" id="toolbarDemo">
    <div class="layui-btn-container">
        <button class="layui-btn layui-btn-sm bdc-major-btn" lay-event="chooseXmxx">选择</button>
        <button class="layui-btn layui-btn-sm bdc-secondary-btn" lay-event="addXmxx">新增</button>
    </div>
</script>
<script src="../lib/bdcui/js/table.js?v=1.0"></script>
<script>
var lszd = '${lszd!}';
    //绑定回车键
    $(document).keydown(function (event) {
        if (event.keyCode == 13) {
            $("#query").click();
        }
    });
    layui.use(['jquery', 'layer', 'element', 'form', 'table', 'laytpl'], function () {
        var $ = layui.jquery;
        var element = layui.element;
        var form = layui.form;
        var table = layui.table;
        var laytpl = layui.laytpl;
        //提交表单
        form.on("submit(query)", function (data) {
            tableReload('tableList', data.field);
            return false;
        });
        var param = "";
        if(lszd){
            param = "?lszd=" + lszd;
        }
        var tableConfig = {
            toolbar: "#toolbarDemo"
            , url: '../xmxx/listbypage' + param  //数据接口
            , cols: [[
                {type: 'radio', fixed: 'left', align: 'center'},
                {field: 'xmmc', title: '项目名称'},
                {field: 'lszd', title: '隶属宗地'
                    ,templet: function (d) {
                        return splitDjh(d.lszd);
                    }
                },
                {field: 'bdcdyh', title: '不动产单元号'
                    ,templet: function (d) {
                        return splitBdcdyh(d.bdcdyh);
                    }
                },
                {field: 'zl', title: '坐落'},
                {
                    field: 'bdczt', title: '不动产状态',
                    templet: function (d) {
                        var returnVal = ""
                        if (d.bdczt == "0") {
                            returnVal = "不可用"
                        } else if (d.bdczt == "1") {
                            returnVal = "可用"
                        } else if (d.bdczt) {
                            returnVal = d.bdczt
                        }
                        return returnVal;
                    }
                }
            ]]
        }

        //加载表格
        loadDataTablbeByUrl("#tableList", tableConfig);

        //头工具栏事件
        table.on('toolbar(dataTable)', function (obj) {
            //获取选中行状态
            var checkStatus = table.checkStatus(obj.config.id);
            var data = checkStatus.data;
            if (obj.event === "chooseXmxx") {
                layer.confirm('确定变更不动产房屋类型并挂接到当前项目吗？', function (index) {
                    $.ajax({
                        url: "../xmxx/infofwxmxx?fwXmxxIndex=" + data[0].fwXmxxIndex,
                        dataType: "json",
                        success: function (fwXmxx) {
                            if(fwXmxx){
                                pickThisFwXmxx(fwXmxx);
                            }
                        },
                        error: function (xhr, status, error) {
                            delAjaxErrorMsg(xhr)
                        }
                    });
                });
            } else if (obj.event === "addXmxx") {
                var index = parent.layer.open({
                    type: 2,
                    title: "新增项目信息",
                    maxmin: true,
                    area: ['100%', '100%'],
                    fixed: false,
                    content: '../xmxx/form?lszd=' + lszd
                    , end: function (index, layero) {
                        $("#query").click();
                        return false;
                    }
                });
                parent.layer.full(index);
            }
        });
    });

    function pickThisFwXmxx(xmxxInfo) {
        var postData = $.extend({},${bginfo});
        if (xmxxInfo && postData.fwDcbIndex) {
            $.each(xmxxInfo, function (key, value) {
                if (key) {
                    postData["fwXmxxDO." + key] = value
                }
            });
            // loading加载
            var loadIndex = layer.load(2, {shade: [0.1, '#fff']});
            $.ajax({
                url: "../bdcdyfwlxbg/fwlxbg",
                dataType: "json",
                data: postData,
                success: function (data) {
                    layer.close(loadIndex);
                    if (parent.layer) {
                        parent.layer.closeAll()
                        parent.layer.alert("修改成功");
                        parent.$("#query").click();
                    }
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
        } else {
            layer.alert("无法确定项目信息，请检查是否新增或选择")
        }
    }
</script>
</body>

</html>


