<!--/**-->
<!--* author: 前端组-->
<!--* date: 2018-12-14-->
<!--* version 3.0.0-->
<!--* describe: 查询条件一栏放三个，默认最多两行，多的点击高级查询收缩，本示例包含输入框，单选，多选，其中EasyUI只有多选时才需要，没有多选不需要引入相应的css和js-->
<!--*/-->
<!DOCTYPE html>
<html lang="zh-cn">
<head>
    <meta charset="utf-8">
    <title>演示链接</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <!--需要复选框时引用-->
    <link rel="stylesheet" href="../lib/easyui/easyui.css">

    <link rel="stylesheet" href="../lib/bdcui/css/search.css" />
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form.css">
</head>
<body>
<div class="bdc-form-div">
    <form class="layui-form setOverflow" lay-filter="form">
        <div class="content-title layui-clear">
            <p>演示列表</p>
        </div>
        <div class="form-margin-area" style="min-height: 500px">
            <div class="basic-info">
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">宗地列表</label>
                        <div class="layui-input-inline">
                            <button type="button" class="layui-btn url bdc-secondary-btn">
                                /building-ui/zd/list
                            </button>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">项目列表</label>
                        <div class="layui-input-inline">
                            <button type="button" class="layui-btn url bdc-secondary-btn">
                                /building-ui/xmxx/list
                            </button>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">逻辑幢列表</label>
                        <div class="layui-input-inline">
                            <button type="button" class="layui-btn url bdc-secondary-btn">
                                /building-ui/ljz/list
                            </button>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">户室列表</label>
                        <div class="layui-input-inline">
                            <button type="button" class="layui-btn url bdc-secondary-btn">
                                /building-ui/fwhs/list
                            </button>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width">宗地测试数据</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" readonly value="230522100026GB00016" />
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width">楼盘表页面（有合并）</label>
                        <div class="layui-input-inline">
                            <button type="button" class="layui-btn url bdc-secondary-btn">
                                /building-ui/lpb/view?fwDcbIndex=05d0537e-b5dd-45f2-b3f2-7d65ac351871&code=default
                            </button>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width">楼盘表页面（有色块）</label>
                        <div class="layui-input-inline">
                            <button type="button" class="layui-btn url bdc-secondary-btn">
                                /building-ui/lpb/view?fwDcbIndex=cbc94601-a483-4f43-989a-ff1460e18935&code=default
                            </button>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width">楼盘表页面（有车库）</label>
                        <div class="layui-input-inline">
                            <button type="button" class="layui-btn url bdc-secondary-btn">
                                /building-ui/lpb/view?fwDcbIndex=f1685eac314040288ad4685eac310001&code=default
                            </button>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width">楼盘表页面（全车库）</label>
                        <div class="layui-input-inline">
                            <button type="button" class="layui-btn url bdc-secondary-btn">
                                /building-ui/lpb/view?fwDcbIndex=b270974e-46b9-4556-aae6-9452097f1797&code=default
                            </button>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">受理嵌套楼盘表</label>
                        <div class="layui-input-inline">
                            <button type="button" id="accept" class="layui-btn bdc-secondary-btn">
                                查看楼盘表
                            </button>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">坐落刷新</label>
                        <div class="layui-input-inline">
                            <button type="button" class="layui-btn url bdc-secondary-btn">
                                /building-ui/zlsx/view
                            </button>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">逻辑幢建筑面积计算</label>
                        <div class="layui-input-inline">
                            <button type="button" class="layui-btn url bdc-secondary-btn">
                                /building-ui/calculated/ljzzjmjview
                            </button>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">逻辑幢分摊土地面积计算</label>
                        <div class="layui-input-inline">
                            <button type="button" class="layui-btn url bdc-secondary-btn">
                                /building-ui/calculated/fttdview
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
</body>
<script src="../lib/layui/layui.js"></script>
<script src="../lib/easyui/jquery.min.js"></script>
<script src="../lib/easyui/jquery.easyui.min.js"></script>
<script>
$(function () {
    $(".url").click(function(){
       window.open($(this).html());
    });

    $("#accept").click(function(){
        var paramJson = {
            wiid:'testWiid',
            name:'中文名'
        };
        layui.use(['form', 'jquery', 'laytpl', 'element'], function () {
            var index = layer.open({
                type: 2,
                title: "选择楼盘表",
                area: ['1300px', '600px'],
                fixed: false, //不固定
                content: '../lpb/view?fwDcbIndex=f1685eac314040288ad4685eac310001'+
                '&code=accept&paramJson='+encodeURI(JSON.stringify(paramJson))
            });
            layer.full(index);
        })
    });
});

function addCartCallBack(param,data){
    console.log(param);
    console.log(data);
    var hsIndex = "";
    $.each(data,function(i,v){
        hsIndex += v.fwHsIndex.value +",";
    });
    if(hsIndex){
        hsIndex = hsIndex.substr(0,hsIndex.length-1);
    }
    layer.alert("工作流id："+ param.wiid + ",添加成功:" + hsIndex);
}
function showCartCallBack(param,data){
    layui.use(['form', 'jquery', 'laytpl', 'element'], function () {
        var index = layer.open({
            title: "购物车页面",
            area: ['1300px', '600px'],
            fixed: false, //不固定
            content: '可以嵌套购物车列表页'
        });
    })
}
</script>
</html>