<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>房屋权利人编辑</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css?v=1.0.2">
    <link rel="stylesheet" href="../lib/bdcui/css/form.css?v=1.0.1">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js"></script>
</head>
<body>
<div class="bdc-form-div">
    <form class="layui-form setOverflow" lay-filter="form">
        <div class="content-title layui-clear">
            <div class="content-title layui-clear">
                <div class="title-btn-area">
                    <button class="layui-btn bdc-major-btn" id="addQlr" type="button">新增</button>
                    <button class="layui-btn main-btn layui-hide" lay-submit="" id="saveQlrList"
                            lay-filter="saveQlrList"
                            type="button">提交
                    </button>
                </div>
            </div>
        </div>
        <!--表单块-->
        <div class="form-margin-area">
            <div class="basic-info">
                <!--表单块的标题-->
                <input type="text" class="layui-input layui-hide" name="fwIndex" id="fwIndex" value="${fwIndex!}">
                <div class="layui-collapse" lay-filter="test" id="qlrList">
                </div>
            </div>
        </div>
    </form>
</div>
<script type="text/html" id="qlrTpl">
    {{# layui.each(d.data, function(index, item){ }}
    {{# var length=d.start+index }}
    <div class="layui-colla-item">
        <div class="layui-colla-title">
            <span id="{{ item.fwFcqlrIndex || ''}}" class="layui-btn layui-btn-sm bdc-delete-btn colla-title-btn"
                  onclick="delQlr(this)">删除
            </span>
            <h3>{{ item.qlr || '权利人'}}</h3>
        </div>
        <div class="layui-colla-content layui-show">
            <div class="layui-form-item layui-hide">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人id</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].fwFcqlrIndex"
                               value="{{ item.fwFcqlrIndex || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].qlr"
                               value="{{ item.qlr || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人证件类型</label>
                    <div class="layui-input-inline">
                        <select name="qlrList[{{length}}].qlrzjlx" lay-search="" lay-filter="zjlx">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdZjllxDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==item.qlrzjlx){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人证件号</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].qlrzjh"
                               value="{{ item.qlrzjh || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人序号</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].qlrbh" value="{{length+1}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">发证机关</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].fzjg"
                               value="{{ item.fzjg || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">性别</label>
                    <div class="layui-input-inline">
                        <select name="qlrList[{{length}}].xb" lay-search="" lay-filter="xb">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdQlrxbDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==item.xb){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">电话</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].dh" value="{{ item.dh || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">邮编</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].yb" value="{{ item.yb || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">工作单位</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].gzdw"
                               value="{{ item.gzdw || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人性质</label>
                    <div class="layui-input-inline">
                        <select name="qlrList[{{length}}].qlrxz" lay-search="" lay-filter="qlrxz">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdQlrxzDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==item.qlrxz){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">共有方式</label>
                    <div class="layui-input-inline">
                        <select name="qlrList[{{length}}].gyfs" lay-search="" lay-filter="gyfs">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdGyfsDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==item.gyfs){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利比例</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].qlbl"
                               value="{{ item.qlbl || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利面积</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="qlrList[{{length}}].qlmj"
                               value="{{ item.qlmj || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">地址</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].dz" value="{{ item.dz || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item change-textarea-margin">
                <label class="layui-form-label change-label-width">备注</label>
                <div class="layui-input-inline">
                    <textarea class="layui-textarea" name="qlrList[{{length}}].bz"
                              value="{{ item.bz || ''}}"></textarea>
                </div>
            </div>
        </div>
    </div>
    {{# }); }}
</script>
<script src="../lib/bdcui/js/form.js?v=1.0.0"></script>
<script>
    var zdList = {}
    $.ajax({
        url: "../fwqlr/mapszd",
        dataType: "json",
        async: false,
        success: function (data) {
            zdList = $.extend({}, data)
        },
        error: function (xhr, status, error) {
            delAjaxErrorMsg(xhr)
        }
    });
    layui.use(['form', 'jquery', 'laytpl', 'element'], function () {
        var form = layui.form;
        var $ = layui.jquery;
        var laytpl = layui.laytpl;
        var element = layui.element;
        //form初始化
        form.render();
        if ($("#fwIndex").val()) {
            loadQlrList();
        } else {
            generateQlrList()
        }
        //提交表单
        form.on("submit(saveQlrList)", function (data) {
            var postData = data.field
            var formLayer = layer;
            if (parent.layer) {
                formLayer = parent.layer
            }
            $.ajax({
                url: "../fwqlr/insertorupdate",
                dataType: "json",
                data: postData,
                success: function (data) {
                    formLayer.msg("提交成功")
                    zdList = data;
                    loadQlrList();
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
            return false;
        })
    });

    //添加权利人
    $("#addQlr").click(function () {
        generateQlrList([{}], $(".layui-colla-item").length);
    })

    //页面入口
    function loadQlrList() {
        //获取数据
        var index = layer.load(1, {shade: [0.1, '#fff']});
        $.ajax({
            url: "../fwqlr/listqlr",
            dataType: "json",
            data: {
                fwIndex: $("#fwIndex").val()
            },
            success: function (data) {
                layer.closeAll();
                //处理查询出来的数据
                generateQlrList(data, 0)
            },
            error: function (xhr, status, error) {
                delAjaxErrorMsg(xhr)
            }
        });
    }

    //生成权利人list表单 qlrList：权利人列表 listStartWhith：从第几个开始生成 isFg：是否需要覆盖
    function generateQlrList(qlrList, listStartWhith) {
        layui.use(['form', 'jquery', 'laytpl', 'element'], function () {
            var form = layui.form;
            var $ = layui.jquery;
            var laytpl = layui.laytpl;
            var element = layui.element;
            if (qlrList == null) {
                qlrList = [{}]
            }
            if (listStartWhith == null) listStartWhith = 0;
            var json = {
                start: listStartWhith,
                data: qlrList,
                zdList: zdList
            }
            //获取模板
            var tpl = $("#qlrTpl").html();
            //渲染数据
            laytpl(tpl).render(json, function (html) {
                if (listStartWhith === 0) {
                    //如果覆盖之前的
                    $("#qlrList").html(html);
                } else {
                    $("#qlrList").append(html);
                }
            });
            form.render();
            element.render();
            listStartWhith = listStartWhith + qlrList.length;
            if (qlrList.length == 0) {
                listStartWhith++;
            }
            return listStartWhith;
        })
    }


    //删除权利人
    function delQlr(delDom) {
        event.stopPropagation();
        layer.open({
            content: '删除操作后会重新加载数据，确定是否有未提交数据？'
            , btn: ['确定', '取消']
            , yes: function (index, layero) {
                if (delDom.id) {
                    layer.open({
                        content: '这条权利人已经入库，将直接从数据库删除，是否确定？'
                        , btn: ['确定', '取消']
                        , yes: function (index, layero) {
                            $.ajax({
                                url: "../fwqlr/deleteqlr",
                                dataType: "json",
                                data: {
                                    fwFcqlrIndex: delDom.id
                                },
                                success: function (data) {
                                    if (data && data.success) {
                                        layer.msg("成功")
                                        loadQlrList();
                                    } else {
                                        layer.alert("删除失败，请检查数据!")
                                    }
                                    layer.closeAll();
                                },
                                error: function (xhr, status, error) {
                                    delAjaxErrorMsg(xhr)
                                }
                            });
                        }

                    });
                } else {
                    $(delDom).parent().parent().remove();
                    layer.closeAll();
                }
            }
        });
    }


</script>
</body>

</html>
