<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>坐落刷新</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form.css">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js"></script>
</head>
<body>
<div class="bdc-form-div">
    <form class="layui-form setOverflow" lay-filter="form">
        <div class="content-title layui-clear">
            <p>坐落刷新</p>
            <div class="title-btn-area">
                <button class="layui-btn bdc-secondary-btn" id="chooseZd" type="button">选择宗地</button>
                <button class="layui-btn bdc-secondary-btn" id="chooseLjz" type="button">选择逻辑幢</button>
                <button class="layui-btn bdc-major-btn" lay-submit="" lay-filter="subBtn"
                        id="subBtn" type="button">提交</button>
            </div>
        </div>
        <div class="form-margin-area" style="min-height: 500px">
            <div class="layui-form-item layui-hide">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">fwDcbIndex</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="fwDcbIndex" id="fwDcbIndex"
                               value="">
                    </div>
                </div>
            </div>
            <div class="basic-info">
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width">宗地号</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="djh" id="djh" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width">逻辑幢</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" id="fwmc" readonly>

                        </div>
                    </div>
                </div>
                <div class="layui-form-item change-textarea-margin">
                    <label class="layui-form-label change-label-width">拼接规则</label>
                    <div class="layui-input-inline change-textarea-width" id="pjgzBtns">
                    </div>
                </div>
                <div class="layui-form-item layui-show">
                    <div class="layui-inline bdc-two-column">
                        <label class="layui-form-label change-label-width">拼接元素类型</label>
                        <div class="layui-input-inline">
                            <input type="radio" name="pjtype" lay-filter="pjtype" value="zd" title="表字段" checked="" class="change-radio-top">
                            <input type="radio" name="pjtype" lay-filter="pjtype" value="xzq" title="行政区" class="change-radio-top">
                            <input type="radio" name="pjtype" lay-filter="pjtype" value="wz" title="文字" class="change-radio-top">
                        </div>
                    </div>
                </div>

                <!--表字段类型 -->
                <div id="zdDiv" class="layui-form-item layui-show pjtype">
                    <div class="layui-inline bdc-two-column">
                        <label class="layui-form-label change-label-width">表字段</label>
                        <div class="layui-input-inline change-input-width90">
                            <select id="chooseTable" lay-filter="chooseTable">
                                <option value="">请选择表</option>
                                <option value="FW_LJZ">FW_LJZ</option>
                                <option value="FW_HS">FW_HS</option>
                            </select>
                        </div>
                        <div class="layui-input-inline change-input-width90">
                            <select id="chooseColumn"  lay-filter="chooseColumn">
                                <option value="">请选择字段</option>
                            </select>
                        </div>
                        <div class="layui-input-inline change-input-width90">
                            <button class="layui-btn bdc-secondary-btn"  type="button" id="addZd">
                                <i class="layui-icon">&#xe654;</i>
                            </button>
                        </div>
                    </div>
                </div>

                <!--行政区类型 -->
                <div id="xzqDiv"  class="layui-form-item layui-show layui-hide pjtype">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">行政区代码位数</label>
                        <div class="layui-input-inline change-input-width90">
                            <select name="xzqdmLen" id="xzqdmLen">
                                <option value="2">2</option>
                                <option value="4">4</option>
                                <option value="6">6</option>
                                <option value="9">9</option>
                                <option value="12">12</option>
                            </select>
                        </div>
                        <div class="layui-input-inline change-input-width90">
                            <button class="layui-btn bdc-secondary-btn" type="button" id="addXzq">
                                <i class="layui-icon">&#xe654;</i>
                            </button>
                        </div>
                    </div>
                </div>

                <!-- 文字类型 -->
                <div id="wzDiv"  class="layui-form-item layui-show layui-hide pjtype">
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width">拼接文字</label>
                        <div class="layui-input-inline" style="width: 40%;">
                            <input type="text" class="layui-input" id="pjwz" />
                        </div>
                        <div class="layui-input-inline change-input-width90">
                            <button class="layui-btn bdc-secondary-btn" type="button" id="addWz">
                                <i class="layui-icon">&#xe654;</i>
                            </button>
                        </div>
                    </div>
                </div>

                <div class="layui-form-item ">
                    <label class="layui-form-label change-label-width">仅刷新空值</label>
                    <div class="layui-input-inline">
                        <input type="checkbox" lay-filter="nullOnlyF"  id="nullOnly" checked="" lay-skin="switch" lay-text="ON|OFF" />
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script type="text/html" id="chooseTableTpl">
    {{# layui.each(d.data, function(index, item){ }}
    <option value="{{ item }}">{{ item }}</option>
    {{# }); }}
</script>
<script type="text/html" id="pjgzTpl">
    {{# layui.each(d.data, function(index, item){ }}
    <button class="layui-btn bdc-secondary-btn" type="button">
        {{ item }}
        <i class="layui-icon layui-unselect layui-tab-close" lay-event="closeTab" >&#x1006;</i>
    </button>
    {{# }); }}
</script>
<script>
$(function () {
    layui.use(['form', 'jquery', 'laytpl', 'element'], function () {
        var form = layui.form;
        var laytpl = layui.laytpl;
        var element = layui.element;
        var nullOnly = true;
        $.ajax({
            url: "../zlsx/getconfig",
            dataType: "json",
            async: false,
            success: function (data) {
                if(data.sxgz){
                    var sxgzList = data.sxgz.split(",");
                    var json = {
                        data : sxgzList
                    };
                    renderPjgz(json);
                }
                if(!data.nullOnly){
                    $("#nullOnly").removeAttr("checked");
                    nullOnly = false;
                }
                layui.use(['form', 'jquery', 'laytpl', 'element'], function () {
                    var form = layui.form;
                    form.render();
                });
            },
            error:function (e) {
                layer.msg("读取默认配置失败");
            }
        });

        // 拼接规则 关闭标签 点击事件
        $('#pjgzBtns').on('click', '.layui-tab-close',function(){
            $(this).parent().remove();
        });

        // 监听提交事件
        form.on("submit(subBtn)",function(data){
            if(!data.field.djh && !data.field.fwDcbIndex){
                layer.alert("请选择宗地或逻辑幢");
                return;
            }
            // 是否只刷新空值
            data.field.nullOnly = nullOnly;
            // 获取拼接规则
            var sxgz = "";
            $.each($("#pjgzBtns").children(),function(i){
                var innerHtml = $(this).html();
                if(innerHtml){
                    var idx = innerHtml.indexOf("<i");
                    var value = innerHtml.substr(0,idx).trim();
                    sxgz += value + ",";
                }
            });
            if(sxgz){
                sxgz = sxgz.substr(0,sxgz.length-1);
            }else{
                layer.alert("请增加拼接规则");
            }
            data.field.sxgz = sxgz;
            var loadIndex = layer.load(2, {shade: [0.3, '#000']});
            $.ajax({
                url: "../zlsx",
                dataType: "json",
                data: data.field,
                async: false,
                success: function (data) {
                    layer.close(loadIndex);
                    layer.alert("刷新成功");
                },
                error:function (e) {
                    layer.alert("读取默认配置失败");
                }
            });

        });

        // 只刷新控制 checkbox 监听
        form.on('switch(nullOnlyF)', function(data){
            if(data.elem.checked){
                nullOnly = true;
            }else{
                nullOnly = false;
            }
        });

        // 监听 拼接规则 字段选择下拉框
        form.on('select(chooseTable)', function(data){
            var json = {
                data: []
            };
            if(data.value == "FW_LJZ"){
                json.data = ["ZLDZ","FWMC"];
            }
            if(data.value == "FW_HS"){
                json.data = ["DYH","FJH"];
            }
            //获取模板
            var tpl = $("#chooseTableTpl").html();
            //渲染数据
            laytpl(tpl).render(json, function (html) {
                $("#chooseColumn").html(html);
            });
            form.render();
        });

        // 监听拼接类型单选框
        form.on('radio(pjtype)', function(data){
            layHide($(".pjtype"));
            // 字段
            if(data.value == "zd"){
                layShow($("#zdDiv"));
            }
            // 行政区
            if(data.value == "xzq"){
                layShow($("#xzqDiv"));
            }
            // 文字
            if(data.value == "wz"){
                layShow($("#wzDiv"));
            }
        });

        // 增加 字段
        $('#addZd').on('click', function(){
            var tableName = $("#chooseTable").val();
            var columnName = $("#chooseColumn").val();
            if(tableName && columnName){
                var gz = tableName + "." + columnName;
                var json = {
                    data:[gz]
                };
                renderPjgz(json);
            }else{
                layer.msg("请选择表名和字段名");
                return;
            }
            form.render();
        });

        // 增加行政区
        $('#addXzq').on('click', function(){
            var xzqdmLen = $("#xzqdmLen").val();
            var json = {
                data:["XZQMC_" + xzqdmLen]
            };
            renderPjgz(json);
            form.render();
        });

        // 增加文字
        $('#addWz').on('click', function(){
            var wz = $("#pjwz").val();
            if(wz){
                var json = {
                    data:[wz]
                };
                renderPjgz(json);
            }else{
                layer.msg("请输入文字");
                return;
            }
            form.render();
        });
    });

    $("#chooseZd").click(function () {
        var index = layer.open({
            type: 2,
            title: "选择宗地",
            area: ['1300px', '600px'],
            fixed: false, //不固定
            content: '../zd/picklist'
        });
    })
    $("#chooseLjz").click(function () {
        var index = layer.open({
            type: 2,
            title: "选择宗地",
            area: ['1300px', '600px'],
            fixed: false, //不固定
            content: '../ljz/picklist?showQuery=lszd,ljzh,zldz'
        });
    })
});


function renderPjgz(json){
    layui.use(['form', 'jquery', 'laytpl', 'element'], function () {
        var form = layui.form;
        var laytpl = layui.laytpl;
        var element = layui.element;
        //获取模板
        var tpl = $("#pjgzTpl").html();
        //渲染数据
        laytpl(tpl).render(json, function (html) {
            if(!$("#pjgzBtns").html()){
                $("#pjgzBtns").html(html);
            }else{
                $("#pjgzBtns").append(html);
            }
        });
        form.render();
        element.render();
    })
}
function layHide(elem) {
    elem.addClass("layui-hide");
}
function layShow(elem) {
    elem.removeClass("layui-hide");
}

function pickLjzCallback(data){
    $("#fwmc").val(data.fwmc);
    $("#djh").val(data.lszd);
    $("#fwDcbIndex").val(data.fw_dcb_index);
    layui.use(['layer','form'], function () {
        var form = layui.form;
        form.render();
        layer.closeAll();
    });
}
// 宗地列表回调函数
function pickZdlistCallback(djh){
    $("#djh").val(djh);
    $("#fwmc").val("");
    $("#fwDcbIndex").val("");
    layui.use(['layer','form'], function () {
        var form = layui.form;
        form.render();
    });
}
</script>

</body>

</html>
