<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1.0">
    <title>楼盘表</title>
    <script src="../lib/js/jquery.min.js"></script>
    <link rel="stylesheet" href="../lib/font-awesome-4.7.0/css/font-awesome.css">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/form.css"/>
    <link rel="stylesheet" href="../css/index.css?v17">
</head>
<body>
<div class="bdc-container">
    <div class="bdc-aside-zoom bdc-aside-close bdc-hide">
        <i class="layui-icon layui-icon-left"></i>
    </div>
    <div class="bdc-aside-zoom bdc-aside-open layui-hide">
        <i class="layui-icon layui-icon-right"></i>
    </div>
    <!--左侧菜单栏开始-->
    <div class="bdc-menu-aside">
        <div class="aside" id="asideCon"></div>
    </div>
    <!--左侧菜单栏结束-->

    <!--右侧主内容开始-->
    <div class="bdc-right-content">
        <input type="hidden" id="fwDcbIndex" value="${fwDcbIndex!}"/>
        <input type="hidden" id="code" value="${code!}"/>
        <input type="hidden" id="zrzh" value=""/>
        <input type="hidden" id="djh" value=""/>
        <!--tab栏切换-->
        <div class="layui-tab" lay-filter="tabFilter">
            <ul class="layui-tab-title layui-hide">
                <li id="zdTabLi" class="layui-hide">宗地基本信息</li>
                <li id="zrzTabLi" class="layui-hide">自然幢信息</li>
                <li id="ljzTabLi" class="layui-hide">逻辑幢信息</li>
                <li id="ychsTabLi" class="layui-hide">预测楼盘表</li>
                <li id="hsTabLi" class="layui-this">楼盘表</li>
            </ul>
            <div class="layui-tab-content">
                <div class="layui-tab-item layui-hide" id="zdTab">
                </div>
                <div class="layui-tab-item layui-hide" id="zrzTab">
                </div>
                <div class="layui-tab-item layui-hide" id="ljzTab">
                </div>
                <div class="layui-tab-item" id="ychsTab">
                    <input type="hidden" id="ycfwDcbIndex" value=""/>
                    <!--状态展示-->
                    <div class="layui-tab-item layui-show">
                        <!--状态展示-->
                        <div class="bdc-state-show">
                        </div>
                        <div class="bdc-state-zoom layui-hide">
                            <i class="layui-icon layui-icon-down bdc-hide"></i>
                            <i class="layui-icon layui-icon-up"></i>
                        </div>
                        <!--表格展示-->
                        <table id="ycTableView" lay-filter="ycLpbTable"></table>
                    </div>
                </div>
                <div class="layui-tab-item layui-show" id="hsTab">
                    <!--状态展示-->
                    <div class="layui-tab-item layui-show">
                        <!--状态展示-->
                        <div class="bdc-state-show">
                        </div>
                        <div class="bdc-state-zoom layui-hide">
                            <i class="layui-icon layui-icon-down bdc-hide"></i>
                            <i class="layui-icon layui-icon-up"></i>
                        </div>
                        <!--表格展示-->
                        <table id="tableView" lay-filter="lpbTable"></table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--右侧主内容结束-->
</div>
</body>
<div class="bdc-details bdc-hide">
    <p class="bdc-details-name">2单元301号</p>
    <table class="layui-table">
        <tbody>
        <tr>
            <td class="bdc-details-title">不动产单元号</td>
            <td>>320684403200HGTNKMFSCKHBH</td>
        </tr>
        <tr>
            <td class="bdc-details-title">单元房号</td>
            <td>201</td>
        </tr>
        <tr>
            <td class="bdc-details-title">实测建筑面积</td>
            <td>129.9m²</td>
        </tr>
        <tr>
            <td class="bdc-details-title">实测套内建筑面积</td>
            <td>129.9m²</td>
        </tr>
        <tr>
            <td class="bdc-details-title">实测分摊建筑面积</td>
            <td>129.9m²</td>
        </tr>
        <tr>
            <td class="bdc-details-title">规划用途</td>
            <td>住宅</td>
        </tr>
        <tr>
            <td class="bdc-details-title">房屋结构</td>
            <td>钢筋混凝土结构</td>
        </tr>
        </tbody>
    </table>
</div>
<script type="text/html" id="toolbarTpl">
    <div class="layui-btn-container">
        {{# if(d.btns){ }}
        {{# layui.each(d.btns, function(index, item){ }}
            <button class="layui-btn layui-btn-sm {{ item.btnClass }}" type="button"
                    {{# if(item.btnEvent){ }}
                    lay-event="{{ item.btnEvent }}"
                    {{# }else if(item.btnCallback){ }}
                    onclick="btnCallBack('{{item.btnCallback}}')"
                    {{# } }}
                    >{{ item.desc }}
            </button>
        {{# }); }}
        {{# } }}
        {{# if(d.moreBtns.length > 0){ }}
        <div class="bdc-more-box">
            <button class="layui-btn layui-btn-sm bdc-table-second-btn bdc-btn-more">
                更多操作 <i class="layui-icon layui-icon-down"></i>
            </button>
            <div class="bdc-table-btn-more">
            {{# layui.each(d.moreBtns, function(index, item){ }}
                <a href="javascript:void(0);" onclick="moreClick('{{item.btnEvent}}')">{{ item.desc }}</a>
            {{# }); }}
            </div>
        </div>
        {{# } }}
    </div>
</script>
<script type="text/html" id="hsToolbar">
</script>
<script type="text/html" id="ychsToolbar">
</script>
<script type="text/html" id="ychsState">
</script>
<script type="text/html" id="zdTreeTpl">
    {{# if(d.zdDjdcbDO && d.zdDjdcbDO.djh){ }}
    <h4>宗地号：{{ d.zdDjdcbDO.djh }}</h4>
    <div id="aside">
        <ul id="accordion" class="accordion">
            {{# layui.each(d.zrzList, function(index, item){ }}
            {{# if(item.fwLjzDOList){ }}
            <li class="open">
                {{# }else{ }}
            <li>
                {{# } }}
                <div class="link" onclick="showLjz('{{d.zdDjdcbDO.djh}}','{{item.zrzh}}')">
                    <i class="fa fa-caret-right"></i>
                    <img src="../image/file.png" alt="图标" class="docu-icon"/>
                    自然幢 {{item.zrzh}}
                </div>
                {{# if(item.fwLjzDOList){ }}
                {{# $("#zrzh").val(item.zrzh); }}
                <ul class="submenu" id="{{d.zdDjdcbDO.djh}}_{{item.zrzh}}" style="display: block;">
                    {{# layui.each(item.fwLjzDOList, function(index, ljz){ }}
                    <li>
                        {{# if(ljz.fwDcbIndex == $("#fwDcbIndex").val()){ }}
                        <a href="javascript:;" onclick="treeClickLjz('{{ljz.fwDcbIndex}}')" class="active">
                            {{# }else{ }}
                            <a href="javascript:;" onclick="treeClickLjz('{{ljz.fwDcbIndex}}')">
                                {{# } }}
                                <img src="../image/log.png" alt="图标" class="docu-icon">{{ljz.fwmc}}
                            </a>
                    </li>
                    {{# }); }}
                </ul>
                {{# }else{ }}
                <ul class="submenu" id="{{d.zdDjdcbDO.djh}}_{{item.zrzh}}"></ul>
                {{# } }}
            </li>
            {{# }); }}
        </ul>
    </div>
    {{# } }}
</script>
<script type="text/html" id="zdTreeLjzListTpl">
    {{# layui.each(d.data, function(index, ljz){ }}
    <li>
        {{# if(ljz.fwDcbIndex == $("#fwDcbIndex").val()){ }}
        <a href="javascript:;" onclick="treeClickLjz('{{ljz.fwDcbIndex}}')" class="active">
            {{# }else{ }}
            <a href="javascript:;" onclick="treeClickLjz('{{ljz.fwDcbIndex}}')">
                {{# } }}
                {{# if(ljz.fwmc){}}
                <img src="../image/log.png" alt="图标" class="docu-icon">{{ljz.fwmc ||''}}
                {{# }else{ }}
                <img src="../image/log.png" alt="图标" class="docu-icon">{{ljz.ljzh ||''}}
                {{# } }}
            </a>
    </li>
    {{# }); }}
</script>
<script src="../lib/layui/layui.js"></script>
<script type="text/html" id="DmMcTpl">
    {{# layui.each(d, function(index, zdItem){ }}
    <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
    {{# }); }}
</script>
<script>
    // 全局变量
    var globalData = {};
    // 监听复选框选择
    var hsCheckList = [];
    var ychsCheckList = [];

    var zdList = {};
    // 外围系统传递的参数JSON
    var param = '${param!}';
    // checkbox是否隐藏
    var hsCheckboxHide = true;
    var ychsCheckboxHide = true;
    var hsUrl = "../lpb/initdata";
    var ychsUrl = "";
    $(function () {
        $.ajax({
            url: "../zd/mul",
            dataType: "json",
            data: {
                zdDoNames: "SZdMjdwDO,SZdQsxzDO,SZdTdsyqlxDO,SZdGmjjhydmDO," +
                "SZdDldmDO,SZdQlsdfsDO,SZdTddjDO,SZdFwjgDO,SDmDwxxDO,SZdFwytDO,SZdQtgsDO,SZdJzwztDO,SZdBdcdyFwlxDO"
            },
            async: false,
            success: function (data) {
                zdList = $.extend({}, data)
            }
        });
    });
</script>
<script src="../js/common.js?v=1.1"></script>
<script src="../js/fwhsbg.js?v=1.4"></script>
<script src="../js/fwhs/fwhsgl.js?v=c1"></script>
<script src="../js/index.js?v=2019-02-12"></script>
<script src="../js/lpb/hbCheck.js?v=0.8"></script>
<script src="../js/lpb/zdtab.js?v=a1"></script>
<script src="../js/lpb/zrztab.js?v=a1"></script>
<script src="../js/lpb/ljztab.js?v=a1"></script>
<script src="../js/lpb/zdTree.js?v=a2"></script>
<script src="../js/lpb/btn.js?v=c36"></script>
<script src="../js/lpb/state.js?v=2019-02-12"></script>
<script src="../js/lpb/ychsTab.js?v=14"></script>
</html>