<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>编辑逻辑幢</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../css/zdtree.css?v=1.2.4">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js"></script>
    <link rel="stylesheet" href="../css/eleTree.css" media="all">
</head>
<body>
<div class="main-container">
    <div class="page-title-container">
        <div class="page-operate-parent">
            <div class="page-operate clear">
                <p id="top-text"></p>
                <div class="title-btn-area .layui-layout-right">
                    <button class="layui-btn bdc-major-btn" id="saveInfo" type="button">提交</button>
                    <button class="layui-btn bdc-secondary-btn" id="gjzd" type="button">挂接宗地</button>
                <#--<button class="layui-btn bdc-secondary-btn" id="gjzrz" type="button">挂接自然幢</button>-->
                </div>
            </div>
        </div>
    </div>
    <div class="content-main">
        <input type="text" class="layui-input layui-hide" id="fwDcbIndex" value="${fwDcbIndex!}">
        <input type="text" class="layui-input layui-hide" id="djh" value="${djh!}">
        <input type="text" class="layui-input layui-hide" id="fwXmxxIndex" value="${fwXmxxIndex!}">
        <input type="text" class="layui-input layui-hide" id="bdcdyfwlx" value="${bdcdyfwlx!}">
        <div class="layui-tab layui-tab-brief" lay-filter="tab" lay-filter="docDemoTabBrief">
            <ul class="layui-tab-title">
                <li class="layui-this" lay-id="ldxx" id="ldxx">楼栋信息</li>
                <li class="layui-hide" lay-id="dcxx" id="dcxx">调查信息</li>
                <li class="layui-hide" lay-id="fwqlr" id="fwqlr">房产权利人</li>
                <li class="layui-hide" lay-id="pmt" id="pmt">平面图</li>
                <li class="layui-hide" lay-id="zdt" id="zdt">宗地图</li>
            </ul>
            <div class="layui-tab-content">
                <div class="layui-tab-item layui-show" id="ldxxTab">
                    <iframe id="ldxxIframe" align="center"></iframe>
                </div>
                <div class="layui-tab-item" id="dcxxTab">
                    <iframe id="dcxxIframe" align="center"></iframe>
                </div>
                <div class="layui-tab-item" id="fwqlrTab">
                    <iframe id="fwqlrIframe" align="center"></iframe>
                </div>
                <div class="layui-tab-item" id="pmtTab">
                    尚未完成4
                </div>
                <div class="layui-tab-item" id="zdtTab">
                    尚未完成5
                </div>
            </div>

        </div>
    </div>
</div>
<script>
    //改变div的高度
    $(".layui-tab-item").height($(window).height() * 0.75);
    if ($("#fwDcbIndex").val()) {
        //如果已有fwdcbindex 获取当前逻辑幢信息
        $.ajax({
            url: "../ljz/infoljz",
            dataType: "json",
            async: false,
            data: {
                fwDcbIndex: $("#fwDcbIndex").val()
            },
            success: function (data) {
                if (data) {
                    changeLjzDjh(data.lszd)
                    $("#bdcdyfwlx").val(data.bdcdyfwlx)
                    //处理显示tab页
                    changeTabShow(data.bdcdyfwlx)
                }
            }
        });
    }

    layui.use(['jquery', 'element', 'laytpl'], function () {
        var $ = layui.jquery;
        var element = layui.element;
        var laytpl = layui.laytpl;

        $("#ldxxTab iframe").attr("src", "../ljz/info?djh=" + $("#djh").val() + "&fwDcbIndex=" + $("#fwDcbIndex").val() + "&fwXmxxIndex=" + $("#fwXmxxIndex").val());
        $("#dcxxTab iframe").attr("src", "../dcxx/initsave?fwIndex=" + $("#fwDcbIndex").val() + "&bdcdyfwlx=" + $("#bdcdyfwlx").val());
        $("#fwqlrTab iframe").attr("src", "../fwqlr/info?fwIndex=" + $("#fwDcbIndex").val());

        //循环调用提交按钮
        $("#saveInfo").click(function () {
            if (!$("#ldxx").hasClass("layui-hide")) {
                element.tabChange('tab', "ldxx");
                $("#ldxxIframe").contents().find("#saveInfo").click();
            }
            if (!$("#dcxx").hasClass("layui-hide")) {
                element.tabChange('tab', "dcxx");
                $("#dcxxIframe").contents().find("#saveDcxx").click();
            }
            if (!$("#fwqlr").hasClass("layui-hide")) {
                element.tabChange('tab', "fwqlr");
                $("#fwqlrIframe").contents().find("#saveQlrList").click();
            }
        })


        $("#gjzd").click(function () {
            var index = layer.open({
                type: 2,
                title: "挂接宗地",
                area: ['800px', '500px'],
                fixed: false, //不固定
                content: '../zd/picklist'
            });
        })
    })

    function changeTabShow(bdcdyfwlx) {
        if (bdcdyfwlx == "2") {
            $("#ldxx").removeClass("layui-hide")
            $("#dcxx").removeClass("layui-hide")
            $("#fwqlr").removeClass("layui-hide")
            $("#pmt").removeClass("layui-hide")
            $("#zdt").removeClass("layui-hide")
        } else {
            $("#ldxx").removeClass("layui-hide")
            $("#dcxx").addClass("layui-hide")
            $("#fwqlr").addClass("layui-hide")
            $("#pmt").addClass("layui-hide")
            $("#zdt").addClass("layui-hide")
        }

    }

    //修改逻辑幢对应的地籍号，主要是给挂接宗地用
    function changeLjzDjh(changeDjh) {
        if (changeDjh) {
            $("#djh").val(changeDjh)
            $("#gjzd").addClass("layui-hide")
            $("#top-text").text("当前宗地地籍号：" + changeDjh)
        }
    }

    //修改当前逻辑幢信息
    function changeLjz(changgeLjzInfo) {
        if (changgeLjzInfo) {
            $("#fwDcbIndex").val(changgeLjzInfo.fwDcbIndex)
            changeLjzDjh(changgeLjzInfo.lszd)
        }
    }
</script>
</body>

</html>
