<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>逻辑幢查询列表</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.1"></script>
    <link rel="stylesheet" href="../lib/bdcui/css/table.css">
    <link rel="stylesheet" href="../lib/bdcui/css/search.css">
</head>
<body>
<div class="bdc-table-box">
    <!--表单模块-->
    <form class="layui-form">
        <div id="queryDiv" class="layui-form-item pf-form-item">
            <div class="layui-inline">
                <label class="layui-form-label">逻辑幢号</label>
                <div class="layui-input-inline">
                    <input type="text" name="ljzh" id="ljzh" placeholder="请输入逻辑幢号" class="layui-input">
                </div>
            </div>
            <div id="btnDiv" class="layui-inline">
                <button class="layui-btn layui-btn-normal bdc-major-btn" lay-submit="" id="query" lay-filter="query"
                        type="button">
                    查询
                </button>
                <button type="reset" class="layui-btn layui-btn-normal bdc-secondary-btn" id="reset">重置</button>
            </div>
        </div>
    </form>
    <hr class="layui-bg-gray">
    <table id="ljzList" lay-data="{id: 'ljzList'}" lay-filter="dataTable"></table>
</div>
<script src="../lib/bdcui/js/table.js"></script>
<script>
    var fwDcbIndex = "${fwDcbIndex!}";
    var lszd = "${lszd!}";


    //绑定回车键
    $(document).keydown(function (event) {
        if (event.keyCode == 13) {
            $("#query").click();
        }
    });

    layui.use(['jquery', 'element', 'form', 'table', 'laytpl'], function () {
        var $ = layui.jquery;
        var element = layui.element;
        var form = layui.form;
        var table = layui.table;
        var laytpl = layui.laytpl;
        var index = parent.layer.getFrameIndex(window.name);
        //提交表单
        form.on("submit(query)", function (data) {
            tableReload('ljzList', data.field);
            return false;
        });

        // 变更户室逻辑幢逻辑 默认查询宗地和自然幢下逻辑幢
        var param  = "";
        if(lszd ){
            var param  = "?lszd="+lszd+"&notfwXmxxIndex="+"notfwXmxxIndex";
        }
        var tableConfig = {
            url: '../ljz/listbypage' + param,
             cols:
                    [[
                        // {type: 'numbers', fixed: 'left'},
                        {
                            field: 'ljzh', title: '逻辑幢号',
                            templet: '<div><a href="javascript:void(0);" onclick="" lay-event="pickLjz" class="layui-table-link">{{d.ljzh||"选择"}}</a></div>'
                        },
                        {field: 'lszd', title: '隶属宗地', width: '20%'
                            ,templet: function (d) {
                                return splitDjh(d.lszd || '');
                            }
                        },
                        {field: 'zrzh', title: '自然幢号', width: '10%'},
                        {field: 'zldz', title: '坐落地址', width: '20%'},
                        {field: 'fwmc', title: '房屋名称', width: '20%'},
                    ]]
        }

        //加载表格
        loadDataTablbeByUrl("#ljzList", tableConfig);

        //父页面的该页面索引
        table.on('tool(dataTable)', function (obj) {
            var data = obj.data;
            if (data) {
                if(fwDcbIndex){
                    data.yFwDcbIndex = fwDcbIndex;
                }
                if (obj.event === "pickLjz") {
                    //选择逻辑幢信息
                    parent.relevanceLjz(data);
                }
            } else {
                layer.alert("当前数据主键缺失，请检查数据");
                return false
            }
        });

    })
</script>
</body>

</html>
