<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>逻辑幢查询列表</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.1"></script>
    <link rel="stylesheet" href="../lib/bdcui/css/table.css">
    <link rel="stylesheet" href="../lib/bdcui/css/search.css">
</head>
<body>
<div class="bdc-table-box">
    <!--表单模块-->
    <form class="layui-form">
        <div class="layui-form-item pf-form-item">
            <div class="layui-inline">
                <label class="layui-form-label">地籍号</label>
                <div class="layui-input-inline">
                    <input type="text" name="lszd" class="layui-input" placeholder="请输入地籍号">
                </div>
            </div>
            <div class="layui-inline">
                <label class="layui-form-label">房屋名称</label>
                <div class="layui-input-inline">
                    <input type="text" name="fwmc" class="layui-input" placeholder="请输入房屋名称">
                </div>
            </div>
            <div class="layui-inline">
                <label class="layui-form-label">坐落</label>
                <div class="layui-input-inline">
                    <input type="text" name="zldz" class="layui-input" placeholder="请输入房屋坐落">
                </div>
            </div>
            <div class="layui-inline">
                <label class="layui-form-label">自然幢号</label>
                <div class="layui-input-inline">
                    <input type="text" name="zrzh" class="layui-input" placeholder="请输入自然幢号">
                </div>
            </div>
            <div class="layui-inline">
                <label class="layui-form-label">逻辑幢号</label>
                <div class="layui-input-inline">
                    <input type="text" name="ljzh" class="layui-input" placeholder="请输入逻辑幢号">
                </div>
            </div>
            <div class="layui-inline bdc-button-box">
                <button class="layui-btn layui-btn-normal bdc-major-btn" lay-submit="" id="query" lay-filter="query"
                        type="button">
                    查询
                </button>
                <button type="reset" class="layui-btn layui-btn-normal bdc-secondary-btn" id="reset">重置</button>
            </div>
        </div>
    </form>
    <hr class="layui-bg-gray">
    <table id="ljzList" lay-data="{id: 'ljzList'}" lay-filter="dataTable"></table>
</div>
<script type="text/html" id="toolbarDemo">
    <div class="layui-btn-container">
        <button class="layui-btn layui-btn-sm bdc-table-second-btn" lay-event="addHs">新增户室</button>
        <button class="layui-btn layui-btn-sm bdc-table-second-btn" lay-event="addYchs" id="addYchs">新增预测户室</button>
        <button class="layui-btn layui-btn-sm bdc-table-second-btn" lay-event="importLpb" id="importLpb">导入楼盘表</button>
        <button class="layui-btn layui-btn-sm bdc-table-second-btn" lay-event="exportLpb" id="exportLpb">导出楼盘表</button>
        <button class="layui-btn layui-btn-sm bdc-table-second-btn" lay-event="importScjzmj" id="importScjzmj">导入实测面积
        </button>
    </div>
</script>
<script type="text/html" id="ljzListToolBarTmpl">
    <div class="layui-btn-container">
        <span class="layui-btn layui-btn-xs  bdc-major-btn" lay-event="editLjz">修改</span>
        <span class="layui-btn layui-btn-xs bdc-delete-btn" lay-event="deleteLjz">删除</span>
        <a class="layui-btn layui-btn-xs bdc-secondary-btn bdc-more-btn">
            更多<i class="layui-icon layui-icon-down"></i>
        </a>
        <div class="bdc-table-btn-more">
            <a lay-event="toLpbView">查看楼盘表</a>
            <a lay-event="buildLpb" id="buildLpb">构建楼盘表</a>
            <a lay-event="fwlxBg">房屋类型变更</a>
            <a lay-event="ycToSc">预测转实测</a>
            <a lay-event="ycScGl">预测实测关联</a>
            <a lay-event="zlsx">刷新户室坐落</a>
        </div>
    </div>
</script>
<script src="../lib/bdcui/js/table.js?v1"></script>
<script>
    var zdList = {};
    var zdparam = "SZdBdcdyFwlxDO";
    $.ajax({
        url: "../zd/mul",
        data: "zdDoNames=" + zdparam,
        dataType: "json",
        async: false,
        success: function (data) {
            zdList = $.extend({}, data);
        }
    });

    //绑定回车键
    $(document).keydown(function (event) {
        if (event.keyCode == 13) {
            refreshView();
        }
    });
    layui.use(['jquery', 'layer', 'element', 'form', 'table', 'laytpl', 'upload'], function () {
        var $ = layui.jquery;
        var element = layui.element;
        var form = layui.form;
        var table = layui.table;
        var laytpl = layui.laytpl;
        var upload = layui.upload;
        //提交表单
        form.on("submit(query)", function (data) {
            var postData = data.field
            tableReload('ljzList', postData)
            return false;
        })

        var tableConfig = {
            toolbar: "#toolbarDemo"
            , url: '../ljz/listbypage' //数据接口
            , cols: [[
                {type: 'radio', fixed: 'left', align: 'center', width: '4%'},
                {field: 'lszd', title: '隶属宗地', width: '15%'
                    ,templet: function (d) {
                        return splitDjh(d.lszd || '');
                    }
                },
                {field: 'zrzh', title: '自然幢号', width: '8%'},
                {field: 'ljzh', title: '逻辑幢号', width: '10%'},
                {field: 'bdcdyh', title: '不动产单元号', width: '20%'
                    ,templet: function (d) {
                        return splitBdcdyh(d.bdcdyh);
                    }
                },
                {
                    field: 'bdcdyfwlx', title: '房屋类型', width: '8%',
                    templet: function (d) {
                        return convertZdDmToMc("SZdBdcdyFwlxDO", d.bdcdyfwlx);
                    }
                },
                {field: 'fwmc', title: '房屋名称', width: '10%'},
                {field: 'zldz', title: '坐落', width: '19%'},
                {title: '操作', fixed: 'right',align: 'center', fixed: 'right', toolbar: '#ljzListToolBarTmpl', width: '15%'}
            ]]
        }
        //加载表格
        loadDataTablbeByUrl("#ljzList", tableConfig);

        //头工具栏事件
        table.on('toolbar(dataTable)', function (obj) {
            //获取选中行状态
            var checkStatus = table.checkStatus(obj.config.id);
            //获取选中行数据,目前只为单选，不考虑多条数据情况
            var data = checkStatus.data;
            if (data && data.length > 0 && data[0].fw_dcb_index) {
                if (data && data.length === 1) {
                    if (obj.event === "addHs") { //新增户室
                        layer.open({
                            type: 2,
                            title: "新增户室",
                            maxmin: true,
                            area: ['100%', '100%'],
                            fixed: false, //不固定
                            content: '../fwhs/info?fwDcbIndex=' + data[0].fw_dcb_index
                            , end: function (index, layero) {
                                refreshView();
                                return false;
                            }
                        });
                        return false
                    }
                    if (obj.event === "addYchs") { //新增户室
                        var index = layer.open({
                            type: 2,
                            title: "新增预测户室",
                            maxmin: true,
                            area: ['100%', '100%'],
                            fixed: false, //不固定
                            content: '../fwychs/info?fwDcbIndex=' + data[0].fw_dcb_index
                            , end: function (index, layero) {
                                refreshView();
                                return false;
                            }
                        });
                        layer.full(index);
                        return false
                    }
                    if (obj.event === "importLpb") {
                        var index = layer.open({
                            type: 2,
                            title: "导入楼盘表",
                            maxmin: true,
                            area: ['700px', '350px'],
                            fixed: false, //不固定
                            content: '../import/lpb?fwDcbIndex=' + data[0].fw_dcb_index
                        });
                        return false;
                    }
                    if (obj.event === "exportLpb") {
                        window.location.href='../export/lpb?fwDcbIndex=' + data[0].fw_dcb_index
                        return false;
                    }
                    if (obj.event === "importScjzmj") {
                        var index = layer.open({
                            type: 2,
                            title: "导入实测面积",
                            maxmin: true,
                            area: ['700px', '300px'],
                            fixed: false, //不固定
                            content: '../import/scmj?fwDcbIndex=' + data[0].fw_dcb_index
                        });
                        return false;
                    }
                } else {
                    layer.alert("请选择一条数据进行操作");
                }
            }  else if (obj.event.indexOf("LAYTABLE") < 0) {
                layer.alert("请选择一条数据进行操作");
            }
        });
        table.on('tool(dataTable)', function (obj) {
            var data = obj.data;
            if (data && data.fw_dcb_index) {
                if (obj.event === "editLjz") { //修改
                    var index = layer.open({
                        type: 2,
                        title: "编辑逻辑幢",
                        maxmin: true,
                        area: ['100%', '100%'],
                        fixed: false, //不固定
                        content: '../ljz/saveorupdateljz?fwDcbIndex=' + data.fw_dcb_index
                        , end: function (index, layero) {
                            refreshView();
                            return false;
                        }
                    });
                    layer.full(index);
                }
                if (obj.event === "deleteLjz") { //删除
                    layer.confirm('真的删除行么', function (index) {
                        deleteLjzFun(data.fw_dcb_index);
                    });
                }
                if (obj.event === "buildLpb") { //构建楼盘表
                    var index = layer.open({
                        type: 2,
                        title: "构建楼盘表",
                        maxmin: true,
                        area: ['1280px', '500px'],
                        fixed: false, //不固定
                        content: '../ljz/buildlpbview?fwDcbIndex=' + data.fw_dcb_index + '&bdcdyfwlx=' + data.bdcdyfwlx
                        , end: function (index, layero) {
                            refreshView();
                            return false;
                        }
                    });
                }
                if(obj.event == "toLpbView"){
                    var index = layer.open({
                        type: 2,
                        title: "查看楼盘表",
                        maxmin: true,
                        area: ['1280px', '500px'],
                        fixed: false, //不固定
                        content: '../lpb/view?fwDcbIndex=' + data.fw_dcb_index + '&code=default'
                        , end: function (index, layero) {
                            refreshView();
                            return false;
                        }
                    });
                    layer.full(index);
                }
                if (obj.event === "fwlxBg") { //房屋类型变更
                    var index = layer.open({
                        type: 2,
                        title: "房屋类型变更",
                        maxmin: true,
                        area: ['700px', '350px'],
                        fixed: false, //不固定
                        content: '../bdcdyfwlxbg/view?fwDcbIndex=' + data.fw_dcb_index
                        , end: function (index, layero) {
                            refreshView();
                            return false;
                        }
                    });
                }
                if (obj.event === "ycToSc") {//预测转实测
                    var index = layer.load(2, {shade: [0.1, '#fff']});
                    $.ajax({
                        url: "../yctosc/ychstoschs",
                        contentType: "application/json;charset=utf-8",
                        type: "GET",
                        data: {
                            fwDcbIndex: data.fw_dcb_index
                        },
                        success: function (data) {
                            layer.close(index);
                            layer.msg(data.msg);
                        },
                        error: function (xhr, status, error) {
                            delAjaxErrorMsg(xhr)
                        }
                    });
                }
                if (obj.event === "ycScGl") {
                    var index = layer.open({
                        type: 2,
                        title: "预测实测关联",
                        maxmin: true,
                        area: ['100%', '100%'],
                        fixed: false, //不固定
                        content: '../fwhsgl/ycsc?fwDcbIndex=' + data.fw_dcb_index
                        , end: function (index, layero) {
                            refreshView();
                            return false;
                        }
                    });
                }

                if(obj.event == "zlsx"){
                    var index = layer.load(2, {shade: [0.1, '#fff']});
                    $.ajax({
                        url: "../zlsx/ljz/byconfig",
                        type: "GET",
                        data: {
                            fwDcbIndex: data.fw_dcb_index
                        },
                        success: function (data) {
                            layer.close(index);
                            layer.msg(data.msg);
                        },
                        error: function (xhr, status, error) {
                            delAjaxErrorMsg(xhr)
                        }
                    });
                }
            } else {
                layer.alert("当前数据主键缺失，请检查数据");
                return false
            }
        });

        function deleteLjzFun(fwDcbIndex) {
            var index = layer.load(1, {shade: [0.1, '#fff']});
            //获取数据
            $.ajax({
                url: "../ljz/delbyfwdcbindex",
                contentType: "application/json;charset=utf-8",
                type: "GET",
                data: {
                    fwDcbIndex: fwDcbIndex
                },
                success: function (data) {
                    layer.closeAll();
                    if (!data || !data.success) {
                        layer.alert("删除失败");
                    }
                    refreshView();
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
        }
    })
    function refreshView() {
        $("#query").click();
    }
</script>
</body>
</html>
