<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>房屋逻辑幢基本信息编辑</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form.css">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.0"></script>
</head>
<body>
<div class="bdc-form-div">
    <form class="layui-form setOverflow" lay-filter="form">
        <div class="content-title layui-clear">
            <div class="title-btn-area">
                <button class="layui-btn bdc-major-btn layui-hide" lay-submit="" id="saveInfo" lay-filter="saveInfo"
                        type="button">提交
                </button>
                <button class="layui-btn bdc-secondary-btn layui-hide" id="gjzrz" type="button">挂接自然幢号</button>
                <button class="layui-btn bdc-secondary-btn" id="getBdcdyh" type="button">获取不动产单元号</button>
            </div>
        </div>
        <div class="form-margin-area">
            <div class="basic-info">
                <div class="layui-form-item layui-hide">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">fwDcbIndex</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" id="fwDcbIndex" name="fwDcbIndex"
                                   value="${fwDcbIndex!}">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">fwXmxxIndex</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" id="fwXmxxIndex" name="fwXmxxIndex"
                                   value="${fwXmxxIndex!}">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item change-textarea-margin">
                    <label class="layui-form-label change-label-width">逻辑幢号</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" id="ljzh" name="ljzh">
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">隶属宗地</label>
                        <div class="layui-input-inline">
                            <input type="text" readonly id="lszd" class="layui-input" name="lszd" value="${lszd!}">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">自然幢号</label>
                        <div class="layui-input-inline">
                            <input type="text" id="zrzh" class="layui-input" name="zrzh">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋名称</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="fwmc">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">不动产单元房屋类型</label>
                        <div class="layui-input-inline">
                            <select name="bdcdyfwlx" lay-search="" lay-filter="bdcdyfwlx" class="SZdBdcdyFwlxDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">权利状态</label>
                        <div class="layui-input-inline">
                            <select name="bdczt" readonly lay-search="" lay-filter="bdczt">
                                <option value="">请选择</option>
                                <option value="0">不可用</option>
                                <option value="1">可用</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">幢号</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="dh">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item change-textarea-margin">
                    <label class="layui-form-label change-label-width">不动产单元号</label>
                    <div class="layui-input-inline">
                        <input type="text" readonly class="layui-input" id="bdcdyh" name="bdcdyh">
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋层数</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="fwcs">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">门牌号</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="mph">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">竣工日期</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" id="jgrq" name="jgrq">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">地上层数</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="dscs">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">地下层数</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="dxcs">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">预测建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="ycjzmj">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">实测建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="scjzmj">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">预测地下面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="ycdxmj">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">实测地下面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="scdxmj">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">预测其他面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="ycqtmj">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">实测其他面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="scqtmj">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">占地面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="zzdmj">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">用地面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="zydmj">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋结构</label>
                        <div class="layui-input-inline">
                            <select name="fwjg" lay-search="" lay-filter="fwjg" class="SZdFwjgDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋用途</label>
                        <div class="layui-input-inline">
                            <select name="fwyt" lay-search="" lay-filter="fwyt" class="SZdFwytDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">建筑物状态</label>
                        <div class="layui-input-inline">
                            <select name="jzwzt" lay-search="" lay-filter="jzwzt" class="SZdJzwztDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">状态日期</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" id="ztrq" name="ztrq">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">墙体归属 东</label>
                        <div class="layui-input-inline">
                            <select name="d" lay-search="" lay-filter="d" class="SZdQtgsDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">墙体归属 南</label>
                        <div class="layui-input-inline">
                            <select name="n" lay-search="" lay-filter="n" class="SZdQtgsDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">墙体归属 西</label>
                        <div class="layui-input-inline">
                            <select name="x" lay-search="" lay-filter="x" class="SZdQtgsDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">墙体归属 北</label>
                        <div class="layui-input-inline">
                            <select name="b" lay-search="" lay-filter="b" class="SZdQtgsDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item change-textarea-margin">
                    <label class="layui-form-label change-label-width">总套数</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="zts">
                    </div>
                </div>
                <div class="layui-form-item change-textarea-margin">
                    <label class="layui-form-label change-label-width">坐落地址</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="zldz">
                    </div>
                </div>
                <div class="layui-form-item change-textarea-margin">
                    <label class="layui-form-label change-label-width">产别</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="cb">
                    </div>
                </div>
                <div class="layui-form-item change-textarea-margin">
                    <label class="layui-form-label change-label-width">备注</label>
                    <div class="layui-input-inline">
                        <textarea class="layui-textarea change-textarea-width" name="bz"></textarea>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script type="text/html" id="DmMcTpl">
    {{# layui.each(d, function(index, zdItem){ }}
    <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
    {{# }); }}
</script>
<script src="../lib/bdcui/js/form.js"></script>
<script src="../js/form.js"></script>
<script>
    var zdList = {}
    $.ajax({
        url: "../zd/mul",
        dataType: "json",
        data: {
            zdDoNames: "SZdFwytDO,SZdQtgsDO,SZdBdcdyFwlxDO,SZdFwjgDO,SZdJzwztDO"
        },
        async: false,
        success: function (data) {
            zdList = $.extend({}, data)
        }
    });
    layui.use(['form', 'jquery', 'laytpl', 'element', 'laydate'], function () {
        var form = layui.form;
        var $ = layui.jquery;
        var laydate = layui.laydate;
        var laytpl = layui.laytpl;
        var element = layui.element;
        //处理列表选择
        var tpl = $("#DmMcTpl").html();
        if (tpl && zdList) {
            $.each(zdList, function (key, value) {
                laytpl(tpl).render(value, function (html) {
                    $("." + key).append(html);
                });
            })
        }
        laydate.render({
            elem: '#jgrq'
        });
        laydate.render({
            elem: '#ztrq'
            , type: 'datetime'
        });
        //form初始化
        form.render();
        //表单初始化
        if ($("#fwDcbIndex").val()) {
            loadFwLjz();
        }
        //提交表单
        form.on("submit(saveInfo)", function (data) {
            var postData = data.field
            var url = "../ljz/insertorupdate";
            var formLayer = layer;
            if (parent.layer) {
                formLayer = parent.layer
            }
            $.ajax({
                url: url,
                dataType: "json",
                data: postData,
                success: function (data) {
                    if (data && data.success) {
                        formLayer.msg("提交成功")
                        if (data.data) {
                            form.val("form", data.data)
                        }
                    } else if (data && data.msg) {
                        formLayer.alert(data.msg)
                    } else {
                        formLayer.alert("提交失败")
                    }
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
            return false;
        })

        form.on('select(bdcdyfwlx)', function (data) {
            if (parent.changeTabShow) {
                parent.changeTabShow(data.value)
            }
            if (data.value != "2") {
                $("#getBdcdyh").addClass("layui-hide")
                $("input[name='bdcdyh']").parent().parent().addClass("layui-hide")
                $("select[name='bdczt']").parent().parent().addClass("layui-hide")
                $("input[name='cb']").parent().parent().addClass("layui-hide")
            } else {
                $("#getBdcdyh").removeClass("layui-hide")
                $("input[name='bdcdyh']").parent().parent().removeClass("layui-hide")
                $("select[name='bdczt']").parent().parent().removeClass("layui-hide")
                $("input[name='cb']").parent().parent().removeClass("layui-hide")
            }
        });

        $("#getBdcdyh").click(function () {
            var postUrl = "";
            var postData;
            if ($("#fwDcbIndex").val()) {
                postUrl = "../bdcdyh/createbdcdyhbyfwdcbindex";
                postData = {fwDcbIndex: $("#fwDcbIndex").val()}
            } else if ($("#lszd").val() && $("#zrzh").val()) {
                postUrl = "../bdcdyh/creatfwbdcdyhbydjhandzrzh";
                postData = {djh: $("#lszd").val(), zrzh: $("#zrzh").val()}
            }
            if (postUrl) {
                $.ajax({
                    url: postUrl,
                    dataType: "json",
                    data: postData,
                    success: function (data) {
                        layer.closeAll();
                        if (data && data.success && data.bdcdyh) {
                            layer.msg("获取成功")
                            $("input[name='bdcdyh']").val(data.bdcdyh)
                        } else {
                            layer.alert("获取失败，请检查隶属宗地与自然幢号")
                        }
                    },
                    error: function (xhr, status, error) {
                        delAjaxErrorMsg(xhr)
                    }
                });
            } else {
                layer.alert("请先挂接宗地与自然幢")
            }
        })

        function writeFormxx(data) {
            form.val("form", data)
        }

        //页面入口
        function loadFwLjz() {
            //获取数据
            var index = layer.load(1, {shade: [0.1, '#fff']});
            $.ajax({
                url: "../ljz/infoljz",
                dataType: "json",
                data: {
                    fwDcbIndex: $("#fwDcbIndex").val()
                },
                success: function (data) {
                    layer.closeAll();
                    //处理查询出来的数据
                    writeFormxx(data)
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
        }
    });


</script>
</body>

</html>
