<!DOCTYPE html>
<html lang="zh-cn">
<head>
    <meta charset="utf-8">
    <title>逻辑幢信息</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form.css?v=1.0.1">
    <link rel="stylesheet" href="../lib/bdcui/css/search.css"/>
    <link rel="stylesheet" href="../lib/bdcui/css/form-tab.css?v=1.04"/>
    <link rel="stylesheet" href="../css/upload.css?v=1.1.2">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.2"></script>
    <script src="../lib/bdcui/js/form.js?v=1.2"></script>
</head>
<body>
<div class="bdc-form-div">
    <form class="layui-form setOverflow" lay-filter="form">
        <div class="content-title layui-clear">
            <div class="title-btn-area">
                <button class="layui-btn bdc-major-btn" lay-submit="" id="saveForm" lay-filter="saveForm">提交</button>
            </div>
        </div>

        <div class="layui-tab" lay-filter="tabFilter">
            <ul class="layui-tab-title">
                <li class="layui-this">楼栋信息</li>
                <li class="layui-hide" id="slickDcxx">调查信息</li>
                <li class="layui-hide" id="slickQlr">房产权利人</li>
                <li class="layui-hide" id="slickPmt">平面图</li>
            </ul>
            <div class="layui-tab-content">
                <div class="layui-tab-item layui-show">
                    <div class="bdc-tab-btn">
                        <button class="layui-btn layui-btn-sm bdc-secondary-btn layui-hide" id="gjzd" type="button">
                            挂接宗地
                        </button>
                        <button class="layui-btn layui-btn-sm bdc-secondary-btn layui-hide" id="gjzrz" type="button">
                            挂接自然幢
                        </button>
                        <button class="layui-btn layui-btn-sm bdc-secondary-btn" id="getLjzh" type="button">获取逻辑幢号
                        </button>
                    </div>
                    <div class="basic-info" id="ldxxFrom">
                        <div class="title-sign"><a id="ldxx" href="javascript:;"></a></div>
                        <div class="layui-form-item layui-hide">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">fwDcbIndex</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" id="fwDcbIndex" name="fwDcbIndex"
                                           value="${fwDcbIndex!}">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">fwXmxxIndex</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" id="fwXmxxIndex" name="fwXmxxIndex"
                                           value="${fwXmxxIndex!}">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">逻辑幢号</label>
                            <div class="layui-input-inline">
                                <input type="text" class="layui-input" id="ljzh" name="ljzh">
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">隶属宗地</label>
                                <div class="layui-input-inline">
                                    <input type="text" readonly id="lszd" class="layui-input" name="lszd" value="${djh!}">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">自然幢号</label>
                                <div class="layui-input-inline">
                                    <input type="text" readonly id="zrzh" class="layui-input" name="zrzh">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋名称</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="fwmc">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">不动产单元房屋类型</label>
                                <div class="layui-input-inline">
                                    <select name="bdcdyfwlx" id="bdcdyfwlx" lay-search="" lay-filter="bdcdyfwlx"
                                            class="SZdBdcdyFwlxDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">权利状态</label>
                                <div class="layui-input-inline">
                                    <select name="bdczt" readonly lay-search="" lay-filter="bdczt">
                                        <option value="">请选择</option>
                                        <option value="0">不可用</option>
                                        <option value="1">可用</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">幢号</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="dh">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin layui-hide" id="bdcdyhFrom">
                            <label class="layui-form-label change-label-width">不动产单元号</label>
                            <div class="layui-input-inline">
                                <input type="text" readonly class="layui-input" id="bdcdyh" name="bdcdyh">
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋层数</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="fwcs">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">门牌号</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="mph">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">竣工日期</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" id="jgrq" name="jgrq">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">地上层数</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="dscs">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">地下层数</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="dxcs">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">预测建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="ycjzmj">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">实测建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="scjzmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">预测地下面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="ycdxmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">实测地下面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="scdxmj">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">预测其他面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="ycqtmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">实测其他面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="scqtmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">占地面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="zzdmj">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">用地面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="zydmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋结构</label>
                                <div class="layui-input-inline">
                                    <select name="fwjg" lay-search="" lay-filter="fwjg" class="SZdFwjgDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋用途</label>
                                <div class="layui-input-inline">
                                    <select name="fwyt" lay-search="" lay-filter="fwyt" class="SZdFwytDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">建筑物状态</label>
                                <div class="layui-input-inline">
                                    <select name="jzwzt" lay-search="" lay-filter="jzwzt" class="SZdJzwztDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">状态日期</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" id="ztrq" name="ztrq">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">墙体归属 东</label>
                                <div class="layui-input-inline">
                                    <select name="d" lay-search="" lay-filter="d" class="SZdQtgsDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">墙体归属 南</label>
                                <div class="layui-input-inline">
                                    <select name="n" lay-search="" lay-filter="n" class="SZdQtgsDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">墙体归属 西</label>
                                <div class="layui-input-inline">
                                    <select name="x" lay-search="" lay-filter="x" class="SZdQtgsDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">墙体归属 北</label>
                                <div class="layui-input-inline">
                                    <select name="b" lay-search="" lay-filter="b" class="SZdQtgsDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">总套数</label>
                            <div class="layui-input-inline">
                                <input type="number" class="layui-input" name="zts">
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">坐落地址</label>
                            <div class="layui-input-inline">
                                <input type="text" class="layui-input" name="zldz">
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">产别</label>
                            <div class="layui-input-inline">
                                <input type="text" class="layui-input" name="cb">
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">备注</label>
                            <div class="layui-input-inline">
                                <textarea class="layui-textarea change-textarea-width" name="bz"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="layui-tab-item">
                    <div class="basic-info layui-hide" id="dcxxForm">
                        <div class="title-sign"><a id="dcxx" href="javascript:;"></a></div>
                        <div class="layui-form-item layui-hide">
                            <input type="text" class="layui-input" name="fwIndex" id="fwIndex" value="${fwIndex!}">
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">调查者</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="dcz" id="dcz">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">调查时间</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="dcsj" id="dcsj">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">产权来源</label>
                            <div class="layui-input-inline">
                                <textarea class="layui-textarea change-textarea-width" name="cqly"></textarea>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">共有情况</label>
                            <div class="layui-input-inline">
                                <textarea class="layui-textarea change-textarea-width" name="gyqk"></textarea>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">附加说明</label>
                            <div class="layui-input-inline">
                                <textarea class="layui-textarea change-textarea-width" name="fjsm"></textarea>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">调查意见</label>
                            <div class="layui-input-inline">
                                <textarea class="layui-textarea change-textarea-width" name="dcyj"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="layui-tab-item">
                    <div class="bdc-tab-btn">
                        <button class="layui-btn layui-btn-sm bdc-secondary-btn" id="addQlr" type="button">新增权利人
                        </button>
                    </div>
                    <div class="basic-info layui-hide" id="qlrForm">
                        <div class="title-sign"><a id="qlrxx" href="javascript:;"></a></div>
                        <div class="form-margin-area">
                            <div class="basic-info">
                                <!--表单块的标题-->
                                <input type="text" class="layui-input layui-hide" name="fwIndex" id="fwIndex"
                                       value="${fwIndex!}">

                                <div class="layui-collapse" lay-filter="test" id="qlrList">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="layui-tab-item">
                    <div class="bdc-tab-btn">
                        <button class="layui-btn layui-btn-sm  bdc-major-btn layui-hide" id="downHst" type="button">下载
                        </button>
                        <button class="layui-btn layui-btn-sm  bdc-delete-btn layui-hide" id="deletHst" type="button">
                            删除
                        </button>
                    </div>
                    <div class="bdc-upload-dragdiv">
                        <div class="layui-upload-drag img-drag" id="hst">
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </form>
</div>
</body>
<script type="text/html" id="qlrTpl">
    {{# layui.each(d.data, function(index, item){ }}
    {{# var length=d.start+index }}
    <div class="layui-colla-item">
        <div class="layui-colla-title">
            <span id="{{ item.fwFcqlrIndex || ''}}" class="layui-btn layui-btn-sm bdc-delete-btn colla-title-btn"
                  onclick="delQlr(this)">删除
            </span>
            <h3>{{ item.qlr || '权利人'}}</h3>
        </div>
        <div class="layui-colla-content layui-show">
            <div class="layui-form-item layui-hide">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人id</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].fwFcqlrIndex"
                               value="{{ item.fwFcqlrIndex || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].qlr"
                               value="{{ item.qlr || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人证件类型</label>
                    <div class="layui-input-inline">
                        <select name="qlrList[{{length}}].qlrzjlx" lay-search="" lay-filter="zjlx">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdZjllxDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==item.qlrzjlx){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人证件号</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].qlrzjh"
                               value="{{ item.qlrzjh || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人序号</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].qlrbh" value="{{length+1}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">发证机关</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].fzjg"
                               value="{{ item.fzjg || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">性别</label>
                    <div class="layui-input-inline">
                        <select name="qlrList[{{length}}].xb" lay-search="" lay-filter="xb">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdQlrxbDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==item.xb){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">电话</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].dh" value="{{ item.dh || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">邮编</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].yb" value="{{ item.yb || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">工作单位</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].gzdw"
                               value="{{ item.gzdw || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人性质</label>
                    <div class="layui-input-inline">
                        <select name="qlrList[{{length}}].qlrxz" lay-search="" lay-filter="qlrxz">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdQlrxzDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==item.qlrxz){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">共有方式</label>
                    <div class="layui-input-inline">
                        <select name="qlrList[{{length}}].gyfs" lay-search="" lay-filter="gyfs">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdGyfsDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==item.gyfs){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利比例</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].qlbl"
                               value="{{ item.qlbl || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利面积</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="qlrList[{{length}}].qlmj"
                               value="{{ item.qlmj || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">地址</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].dz" value="{{ item.dz || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item change-textarea-margin">
                <label class="layui-form-label change-label-width">备注</label>
                <div class="layui-input-inline">
                    <textarea class="layui-textarea" name="qlrList[{{length}}].bz"
                              value="{{ item.bz || ''}}"></textarea>
                </div>
            </div>
        </div>
    </div>
    {{# }); }}
</script>
<script type="text/html" id="DmMcTpl">
    {{# layui.each(d, function(index, zdItem){ }}
    <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
    {{# }); }}
</script>
<script type="text/html" id="uploadTpl">
    {{# if(d.srcUrl){ }}
    <img id="img" class="upload-img" src="{{d.srcUrl}}" alt="">
    {{# }else{ }}
    <div class="upload-icon">
        <i class="layui-icon">&#xe654;</i>
        <span>上传平面图</span>
    </div>
    <h4>点击/拖拽单个文件到这里上传</h4>
    <p>支持jpeg、jpg、png格式，大小在10M以下</p>
    <img id="img" class="upload-img" src="" alt="">
    <div class="video-icon"></div>
    {{# } }}
</script>
<script>
    // 文档中心地址
    var storageUrl = '${storageUrl!}';

    // 房屋户室主键
    var fwDcbIndex = '${fwDcbIndex!}';

    // 户室图主键
    var fwHstIndex = '';
    var zdList = {}
    $.ajax({
        url: "../zd/mul",
        dataType: "json",
        data: {
            zdDoNames: "SZdFwytDO,SZdQtgsDO,SZdBdcdyFwlxDO,SZdFwjgDO,SZdJzwztDO,SZdGyfsDO,SZdQlrxzDO,SZdQlrxbDO,SZdZjllxDO"
        },
        async: false,
        success: function (data) {
            zdList = $.extend({}, data)
        }
    });


    layui.use(['form', 'jquery', 'laytpl', 'element', 'laydate', 'upload'], function () {
        var form = layui.form;
        var $ = layui.jquery;
        var laydate = layui.laydate;
        var laytpl = layui.laytpl;
        var element = layui.element;
        var upload = layui.upload;
        //处理列表选择
        var tpl = $("#DmMcTpl").html();
        if (tpl && zdList) {
            $.each(zdList, function (key, value) {
                laytpl(tpl).render(value, function (html) {
                    $("." + key).append(html);
                });
            })
        }
        laydate.render({
            elem: '#jgrq'
        });
        laydate.render({
            elem: '#ztrq'
            , type: 'datetime'
        });
        laydate.render({
            elem: '#dcsj'
            , type: 'datetime'
        });
        //form初始化
        form.render();

        //表单初始化
        if ($("#fwDcbIndex").val()) {
            disableBdcdyfwlx();
            loadFwLjz();
        }else{
            // 如果是新增 BDCDYFWLX 则 默认选中 独幢
            $("select[name='bdcdyfwlx']").val("2");
            form.render();
            changeViewByBdcdyfwlx();
            if (!$("#lszd").val()) {
                $("#gjzd").removeClass("layui-hide");
            }
            if (!$("#zrzh").val()) {
                $("#gjzrz").removeClass("layui-hide");
            }
        }

        //如果从外部传递了房屋项目主键，说明为多幢
        var fwXmxxIndex = "${fwXmxxIndex!}";
        if (fwXmxxIndex) {
            disableBdcdyfwlx();
            form.val("form", {bdcdyfwlx: '1'})
        }
        //提交表单
        form.on("submit(saveForm)", function (data) {
            var postData = data.field;
            //删除不动产单元号中的空格
            postData.bdcdyh=postData.bdcdyh.replace(/\s*/g,"");
            var formLayer = layer;
            if (parent.layer) {
                formLayer = parent.layer
            }
            var loadIndex = formLayer.load(2, {shade: [0.1, '#fff']});
            $.ajax({
                url: "../ljz/saveorupdate",
                dataType: "json",
                type: "post",
                data: {jsonData:JSON.stringify(formSubmitDealJson(postData))},
                success: function (data) {
                    formLayer.close(loadIndex);
                    if (data && data.success) {
                        formLayer.msg("提交成功");
                        disableBdcdyfwlx();
                        if (data.data) {
                            if(data.data.bdcdyh){
                                data.data.bdcdyh = splitBdcdyh(data.data.bdcdyh);
                            }
                            form.val("form", data.data);
                        }
                        loadQlrList();
                    } else if (data && data.msg) {
                        formLayer.alert(data.msg)
                    } else {
                        formLayer.alert("提交失败")
                    }
                },
                error: function (xhr, status, error) {
                    formLayer.close(loadIndex);
                    delAjaxErrorMsg(xhr);
                }
            });
            return false;
        })

        element.on('tab(tabFilter)', function(data){
            var tabid=$(".layui-tab-title .layui-this").attr("id");
            if(tabid=="slickQlr"){
                if($("#fwDcbIndex").val()){
                    loadQlrList();
                }else {
                    generateQlrList();
                }
                $('#slickQlr').attr('id', 'newSlickQlr');
            }else if(tabid=="slickPmt"){
                if ($("#fwDcbIndex").val()) {
                    var imgElementSrc = $("#img").attr("src");
                    if(!imgElementSrc){
                        // 查询 户室图
                        $.ajax({
                            url: "../hst/queryfwljzpmt",
                            dataType: "json",
                            data: {
                                fwDcbIndex: $("#fwDcbIndex").val()
                            },
                            async: false,
                            success: function (data) {
                                if (data.fwHstIndex) {
                                    fwHstIndex = data.fwHstIndex;
                                }
                                if (data.src) {
                                    renderTpl({srcUrl: data.src});
                                } else {
                                    renderTpl({});
                                }
                            },
                            error: function (xhr, status, error) {
                                delAjaxErrorMsg(xhr)
                            }
                        });
                    }
                } else {
                    $("#hst").addClass("layui-hide");
                    layer.alert("请先保存逻辑幢信息");
                }
            }
        });

        //根据不动产类型判断显示哪些
        form.on('select(bdcdyfwlx)', function (data) {
            if (data.value != "2") {
                $("#addQlr").addClass("layui-hide")
                $("#slickDcxx").addClass("layui-hide")
                $("#slickQlr").addClass("layui-hide")
                $("#slickPmt").addClass("layui-hide")
                $("#qlrForm").addClass("layui-hide")
                $("#dcxxForm").addClass("layui-hide")
                $("#bdcdyhFrom").addClass("layui-hide")
            } else {
                $("#addQlr").removeClass("layui-hide")
                $("#slickDcxx").removeClass("layui-hide")
                $("#slickQlr").removeClass("layui-hide")
                $("#slickPmt").removeClass("layui-hide")
                $("#qlrForm").removeClass("layui-hide")
                $("#dcxxForm").removeClass("layui-hide")
                $("#bdcdyhFrom").removeClass("layui-hide")
            }
        });

        //拖拽上传
        upload.render({
            elem: '#hst'
            , url: '../hst/uploadfwljzpmt'
            , accept: 'images'
            , data: {
                fwDcbIndex: function () {
                    return $("#fwDcbIndex").val()
                }
            }
            , auto: true
            , done: function (res) {
                if (res.success && res.imgId && res.fwHstIndex) {
                    fwHstIndex = res.fwHstIndex;
                    var imgUrl = storageUrl + "/rest/files/download/" + res.imgId;
                    renderTpl({srcUrl: imgUrl});
                    layer.msg("上传成功");
                    layer.closeAll();
                } else {
                    layer.msg("上传失败");
                    layer.closeAll();
                }
            }
            , before:function(){
                var loadIndex = layer.load(1, {shade: [0.3, '#000']});
            }
            ,error : function () {
                layer.closeAll();
            }
        });

        function writeFormxx(data) {
            if(data.bdcdyh){
                data.bdcdyh = splitBdcdyh(data.bdcdyh);
            }
            form.val("form", data);
            if (!$("#bdcdyh").val() && data.bdcdyfwlx == '2') {
            }
            if (data.bdcdyfwlx == 2) {
               // generateQlrList(data.qlrList, 0)
                changeViewByBdcdyfwlx()
            }

            if (!$("#lszd").val()) {
                $("#gjzd").removeClass("layui-hide");
            }

            if (!$("#zrzh").val()) {
                $("#gjzrz").removeClass("layui-hide");
            }
        }

        //页面入口
        function loadFwLjz() {
            //获取数据
            var index = layer.load(1, {shade: [0.1, '#fff']});
            $.ajax({
                url: "../ljz/infoljz",
                dataType: "json",
                data: {
                    fwDcbIndex: $("#fwDcbIndex").val()
                },
                success: function (data) {
                    layer.closeAll();
                    //处理查询出来的数据
                    if (data) {
                        writeFormxx(data)
                        if (data.lszd) {
                            $("#gjzd").addClass("layui-hide")
                        }
                    }
                },
                error: function (xhr, status, error) {
                    formLayer.msg("没有权利人数据")
                    //delAjaxErrorMsg(xhr)
                }
            });
        }
    });

    //添加权利人
    $("#addQlr").click(function () {
        $("html,body").animate({scrollTop: $('#qlrForm').offset().top - 119 + "px"}, 200);
        generateQlrList([{}], $(".layui-colla-item").length);
    })

    //页面入口
    function loadQlrList() {
        //获取数据
        var index = layer.load(1, {shade: [0.1, '#fff']});
        $.ajax({
            url: "../fwqlr/listqlr",
            dataType: "json",
            data: {
                fwIndex: $("#fwDcbIndex").val()
            },
            success: function (data) {
                layer.closeAll();
                //处理查询出来的数据
                if (data && data.success) {
                    if (data.data) {
                        generateQlrList(data.data, 0)
                    }
                } else {
                    generateQlrList();
                }

            },
            error: function (xhr, status, error) {
                delAjaxErrorMsg(xhr)
            }
        });
    }

    //生成权利人list表单 qlrList：权利人列表 listStartWhith：从第几个开始生成 isFg：是否需要覆盖
    function generateQlrList(qlrList, listStartWhith) {
        layui.use(['form', 'jquery', 'laytpl', 'element'], function () {
            var form = layui.form;
            var $ = layui.jquery;
            var laytpl = layui.laytpl;
            var element = layui.element;
            if (qlrList == null) {
                qlrList = [{}]
            }
            if (listStartWhith == null) listStartWhith = 0;
            var json = {
                start: listStartWhith,
                data: qlrList,
                zdList: zdList
            }
            //获取模板
            var tpl = $("#qlrTpl").html();
            //渲染数据
            laytpl(tpl).render(json, function (html) {
                if (listStartWhith === 0) {
                    //如果覆盖之前的
                    $("#qlrList").html(html);
                } else {
                    $("#qlrList").append(html);
                }
            });
            form.render();
            element.render();
            listStartWhith = listStartWhith + qlrList.length;
            if (qlrList.length == 0) {
                listStartWhith++;
            }
            return listStartWhith;
        })
    }


    //删除权利人
    function delQlr(delDom) {
        event.stopPropagation();
        layer.open({
            content: '删除操作后会重新加载数据，确定是否有未提交数据？'
            , btn: ['确定', '取消']
            , yes: function (index, layero) {
                if (delDom.id) {
                    layer.open({
                        content: '这条权利人已经入库，将直接从数据库删除，是否确定？'
                        , btn: ['确定', '取消']
                        , yes: function (index, layero) {
                            $.ajax({
                                url: "../fwqlr/deleteqlr",
                                dataType: "json",
                                data: {
                                    fwFcqlrIndex: delDom.id
                                },
                                success: function (data) {
                                    if (data && data.success) {
                                        layer.msg("成功")
                                        loadQlrList();
                                    } else {
                                        layer.alert("删除失败，请检查数据!")
                                    }
                                    layer.closeAll();
                                },
                                error: function (xhr, status, error) {
                                    delAjaxErrorMsg(xhr)
                                }
                            });
                        }

                    });
                } else {
                    $(delDom).parent().parent().remove();
                    layer.closeAll();
                }
            }
        });
    }

    // 挂接宗地
    $("#gjzd").click(function () {
        if(checkHasFwhs()){
            var index = layer.open({
                type: 2,
                title: "挂接宗地",
                area: ['1300px', '600px'],
                fixed: false, //不固定
                content: '../zd/picklist'
            });
        }else{
            layer.msg("逻辑幢下已有户室，不允许挂接");
        }
    });

    // 挂接自然幢
    $("#gjzrz").click(function(){
        if(checkHasFwhs()){
            var lszd = $("#lszd").val();
            if(lszd){
                var index = layer.open({
                    type: 2,
                    title: "挂接自然幢",
                    area: ['1300px', '600px'],
                    fixed: false, //不固定
                    content: '../zrz/picklist?lszd='+lszd
                });
            }else{
                layer.msg("请先挂接宗地");
            }
        }else{
            layer.msg("逻辑幢下已有户室，不允许挂接");
        }
    });


    $("#getLjzh").click(function () {
        var lszd = $("#lszd").val();
        if (lszd) {
            $.ajax({
                url: "../ljz/getljzh",
                dataType: "json",
                data: {
                    lszd: lszd
                },
                success: function (data) {
                   // $("html,body").animate({scrollTop: $('#ldxxFrom').offset().top - 119 + "px"}, 200);
                    $("#ljzh").val(data)
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
        } else {
            layer.msg("请挂接宗地");
        }
    })

    function changeViewByBdcdyfwlx() {
        $("#addQlr").removeClass("layui-hide")
        $("#slickDcxx").removeClass("layui-hide")
        $("#slickQlr").removeClass("layui-hide")
        $("#slickPmt").removeClass("layui-hide")
        $("#qlrForm").removeClass("layui-hide")
        $("#dcxxForm").removeClass("layui-hide")
        $("#bdcdyhFrom").removeClass("layui-hide")
    }

    function disableBdcdyfwlx() {
        $("#bdcdyfwlx").attr("disabled", "disabled");
    }

    //修改逻辑幢对应的地籍号，主要是给挂接宗地用
    function pickZdlistCallback(changeDjh) {
        $("#lszd").val(changeDjh);
        $("#gjzd").addClass("layui-hide");
    }

    // 下载图片
    $("#downHst").click(function () {
        var srcURL = $("#img").attr("src");
        if (srcURL && srcURL.indexOf("storage") > 0) {
            window.open(srcURL + "?attachment=1");
        } else {
            layer.msg("当前图片不支持下载");
        }
    });

    // 删除按钮
    $("#deletHst").click(function () {
        // 删除户室图
        $.ajax({
            url: "../hst/delfwljzpmt",
            dataType: "json",
            data: {
                fwDcbIndex: $("#fwDcbIndex").val()
            },
            async: false,
            success: function (data) {
                if (data.success) {
                    renderTpl({});
                    // 户室图主键清空
                    fwHstIndex = "";
                    layer.msg("删除成功");
                }
            },
            error: function (xhr, status, error) {
                delAjaxErrorMsg(xhr)
            }
        });

    });


    function renderTpl(json) {
        $("#hst").removeClass("layui-hide");
        if (json.srcUrl) {
            $("#downHst").removeClass("layui-hide");
            $("#deletHst").removeClass("layui-hide");
        } else {
            $("#downHst").addClass("layui-hide");
            $("#deletHst").addClass("layui-hide");
        }
        layui.use('laytpl', function () {
            //获取模板
            var tpl = $("#uploadTpl").html();
            var laytpl = layui.laytpl;
            //渲染数据
            laytpl(tpl).render(json, function (html) {
                $("#hst").html(html);
            });
        })
    }

    function pickZrzCallBack(data){
        if(data.zrzh){
            $("#zrzh").val(data.zrzh);
            $("#gjzrz").addClass("layui-hide");
        }
    }

    function checkHasFwhs(){
        var result = true;
        var fwDcbIndex = $("#fwDcbIndex").val();
        if(fwDcbIndex){
            $.ajax({
                url: "../fwhs/listljzidbypage",
                dataType: "json",
                data: {
                    fwDcbIndex: fwDcbIndex
                },
                async: false,
                success: function (data) {
                    if ( !data.content || data.content.length == 0) {
                        result = true;
                    }else{
                        result = false;
                    }
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
        }
        return result;
    }
</script>
</html>