<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>构建楼盘表</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form.css">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js"></script>
</head>
<body>
<div class="bdc-form-div">
    <form class="layui-form setOverflow" lay-filter="form">
        <div class="content-title layui-clear">
            <p>构建楼盘表</p>
            <div class="title-btn-area">
                <button class="layui-btn bdc-major-btn" lay-submit=""  lay-filter="buildBtn"
                        id="buildBtn" type="button">提交</button>
                <button class="layui-btn bdc-secondary-btn dtgj" id="dtgjAdd" type="button">增加单元</button>
            </div>
        </div>
        <div class="form-margin-area" style="min-height: 500px">
            <div class="layui-form-item layui-hide">
                <input type="text" class="layui-input" name="fwDcbIndex" value="${fwDcbIndex!}"/>
                <input type="text" class="layui-input" name="bdcdyfwlx" value="${bdcdyfwlx!}"/>
            </div>
            <div class="basic-info" id="dtgjDiv">
                <div class="layui-form-item layui-show">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">层数</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="cs" />
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">构建方式</label>
                        <div class="layui-input-inline">
                            <select name="gjfs" id="gjfs" lay-search="" lay-filter="gjfs">
                                <option value="0">请选择</option>
                                <option value="1">无单元按户构建</option>
                                <option value="2">按单元户数平均构建</option>
                                <option value="3">按单元户数动态构建</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item layui-show wdygj">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">每层户数</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="mchs" />
                        </div>
                    </div>
                </div>
                <div class="layui-form-item layui-show pjgj">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">单元数</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="dys" />
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">每层户数</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="dymshs" />
                        </div>
                    </div>
                </div>
                <div class="layui-form-item layui-show dtgj">
                    <input type="text" class="layui-input layui-hide hsdtgj" name="hsdtgj[0]" />
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">单元号</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input hsdtgj-dyh" name="dtgj[0].dyh" />
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">户数</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input hsdtgj-hs" name="dtgj[0].hs" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script type="text/html" id="dtgjTpl">
    {{# layui.each(d.data, function(index, item){ }}
    {{# var length=d.start+index }}
    <div class="layui-form-item layui-show dtgj">
        <input type="text" class="layui-input layui-hide hsdtgj" name="hsdtgj[{{length}}]" />
        <div class="layui-inline margin-top-ipt">
            <label class="layui-form-label change-label-width">单元号</label>
            <div class="layui-input-inline">
                <input type="text" class="layui-input hsdtgj-dyh" name="dtgj[{{length}}].dyh" />
            </div>
        </div>
        <div class="layui-inline margin-top-ipt">
            <label class="layui-form-label change-label-width">户数</label>
            <div class="layui-input-inline">
                <input type="text" class="layui-input hsdtgj-hs" name="dtgj[{{length}}].hs" />
            </div>
        </div>
    </div>
    {{# }); }}
</script>
<script>
    var bdcdyfwlx = "${bdcdyfwlx!}";
    var fwDcbIndex = "${fwDcbIndex!}";

    layHide($(".wdygj,.pjgj,.dtgj"));

    layui.use(['form', 'jquery', 'laytpl', 'element'], function () {
        var form = layui.form;
        var $ = layui.jquery;
        //form初始化
        form.render();

        // 动态构建 添加 单元号 和户数
        $("#dtgjAdd").click(function () {
            generateDtgjList([{}], $(".dtgj").length);
        });

        function initHsdtgj(){
            var itemlist = [];
            $(".dtgj").each(function (i) {
                var dyh = $(this).find(".hsdtgj-dyh").val();
                var hs = $(this).find(".hsdtgj-hs").val();
                if(dyh && hs){
                    var item = {};
                    item.hs = hs;
                    item.dyh = dyh;
                    itemlist.push(item);
                }
            });
            return JSON.stringify(itemlist);
        }


        //提交表单
        form.on("submit(buildBtn)", function (data) {
            var postData = data.field;
            if(postData.gjfs == '3'){
                postData.dtgjJson = initHsdtgj();
            }
            // loading加载
            var loadIndex = layer.load(2, {shade: [0.1, '#fff']});
            $.ajax({
                url: "../ljz/build",
                dataType: "json",
                data: postData,
                success: function (data) {
                    layer.closeAll();
                    if (parent.$("#buildLpb") && parent.$("#buildLpb").length > 0) {
                        var index = parent.layer.getFrameIndex(window.name);
                        parent.layer.close(index)
                        parent.layer.msg("提交成功")
                    } else {
                        layer.msg("提交成功")
                    }
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
            return false;
        });

        form.on('select(gjfs)', function(data){
            layHide($(".wdygj,.pjgj,.dtgj"));

            // 请选择 隐藏全部
            if(data.value == '0'){
            }
            // 无单元按户构建
            if(data.value == '1'){
                layShow($(".wdygj"));
            }
            // 按单元户数平均构建
            if(data.value == '2'){
                layShow($(".pjgj"));
            }
            // 按单元户数动态构建
            if(data.value == '3'){
                layShow($(".dtgj"));
            }
        });

        function generateDtgjList(dtgjList, listStartWhith) {
            layui.use(['form', 'jquery', 'laytpl', 'element'], function () {
                var form = layui.form;
                var $ = layui.jquery;
                var laytpl = layui.laytpl;
                var element = layui.element;
                if (dtgjList == null) {
                    dtgjList = [{}];
                }
                if (listStartWhith == null) listStartWhith = 0;
                var json = {
                    start: listStartWhith,
                    data: dtgjList
                };
                //获取模板
                var tpl = $("#dtgjTpl").html();
                //渲染数据
                laytpl(tpl).render(json, function (html) {
                    $("#dtgjDiv").append(html);
                });
                form.render();
                element.render();
                listStartWhith = listStartWhith + dtgjList.length;
                if (dtgjList.length == 0) {
                    listStartWhith++;
                }
                return listStartWhith;
            })

        }
    });
    function layHide(elem) {
        elem.addClass("layui-hide");
    }
    function layShow(elem) {
        elem.removeClass("layui-hide");
    }
</script>
</body>

</html>
