<!DOCTYPE html>
<html lang="zh-cn">
<head>
    <meta charset="utf-8">
    <title>平面图</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form.css">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js"></script>
    <link rel="stylesheet" href="../css/upload.css?v=1.0.7">
</head>
<body>
<div class="content-title layui-clear">
    <div class="title-btn-area">
        <button class="layui-btn bdc-major-btn layui-hide" lay-submit=""  lay-filter="downHst"
                id="downHst" type="button">下载</button>
        <button class="layui-btn bdc-delete-btn layui-hide" lay-submit=""  lay-filter="deletHst"
                id="deletHst" type="button">删除</button>
    </div>
</div>
<div class="bdc-upload-dragdiv">
    <!-- 图片上传开始 -->
    <div class="layui-upload-drag img-drag" id="hst">
    </div>
</div>
<script type="text/html" id="uploadTpl">
    {{# if(d.srcUrl){ }}
    <img id="img" class="upload-img" src="{{d.srcUrl}}" alt="">
    {{# }else{ }}
    <div class="upload-icon">
        <i class="layui-icon">&#xe654;</i>
        <span>上传平面图</span>
    </div>
    <h4>点击/拖拽单个文件到这里上传</h4>
    <p>支持jpeg、jpg、png格式，大小在10M以下</p>
    <img id="img"  class="upload-img" src="" alt="">
    <div class="video-icon"></div>
    {{# } }}
</script>
<script>
    // 文档中心地址
    var storageUrl = '${storageUrl!}';

    // 房屋户室主键
    var fwDcbIndex = '${fwDcbIndex!}';

    // 户室图主键
    var fwHstIndex = '';

    // 查询 户室图
    $.ajax({
        url: "../hst/queryfwljzpmt",
        dataType: "json",
        data: {
            fwDcbIndex: fwDcbIndex
        },
        async: false,
        success: function (data) {
            if(data.fwHstIndex){
                fwHstIndex = data.fwHstIndex;
            }
            if(data.src){
                renderTpl({srcUrl:data.src});
            }else{
                renderTpl({});
            }
        },
        error: function (xhr, status, error) {
            delAjaxErrorMsg(xhr)
        }
    });

    // 下载图片
    $("#downHst").click(function(){
        var srcURL = $("#img").attr("src");
        if(srcURL && srcURL.indexOf("storage")>0){
            window.open(srcURL + "?attachment=1");
        }else{
            layer.msg("当前图片不支持下载");
        }
    });

    // 删除按钮
    $("#deletHst").click(function(){
        // 删除户室图
        $.ajax({
            url: "../hst/delfwljzpmt",
            dataType: "json",
            data: {
                fwDcbIndex: fwDcbIndex
            },
            async: false,
            success: function (data) {
                if(data.success){
                    renderTpl({});
                    // 户室图主键清空
                    fwHstIndex = "";
                    layer.msg("删除成功");
                }
            },
            error: function (xhr, status, error) {
                delAjaxErrorMsg(xhr)
            }
        });

    });


    function renderTpl(json){
        if(json.srcUrl){
            $("#downHst").removeClass("layui-hide");
            $("#deletHst").removeClass("layui-hide");
        }else{
            $("#downHst").addClass("layui-hide");
            $("#deletHst").addClass("layui-hide");
        }
        layui.use('laytpl', function () {
            //获取模板
            var tpl = $("#uploadTpl").html();
            var laytpl = layui.laytpl;
            //渲染数据
            laytpl(tpl).render(json, function (html) {
                $("#hst").html(html);
            });
        })
    }

    layui.use('upload', function(){
        var $ = layui.jquery;
        var upload = layui.upload;
        //拖拽上传
        upload.render({
            elem: '#hst'
            ,url: '../hst/uploadfwljzpmt?fwDcbIndex=' + fwDcbIndex
            ,accept: 'file'
            ,auto: true
            ,done: function(res){
                if(res.success && res.imgId && res.fwHstIndex){
                    fwHstIndex = res.fwHstIndex;
                    var imgUrl = storageUrl + "/rest/files/download/" + res.imgId;
                    renderTpl({srcUrl:imgUrl});
                    layer.msg("上传成功");
                }else{
                    layer.msg("上传失败");
                }
            }
        });
    });

</script>
</body>
</html>
