<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>子户室基本信息编辑</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form.css">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.0"></script>
</head>
<body>
<div class="bdc-form-div">
    <form class="layui-form setOverflow" lay-filter="form">
        <div class="content-title layui-clear">
            <div class="title-btn-area">
                <button class="layui-btn bdc-major-btn" lay-submit="" id="saveFwZhs" lay-filter="saveFwZhs"
                        type="button">提交
                </button>
                <button class="layui-btn bdc-secondary-btn" id="jczhs" type="button">继承主户室</button>
            </div>
        </div>
        <div class="form-margin-area">
            <div class="basic-info">
                <!--表单块的标题-->
                <div class="title-sign">
                    <p>子户室信息</p>
                </div>
                <div class="layui-form-item layui-hide">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">fwhsIndex</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" id="fwHsIndex" name="fwHsIndex" value="${fwHsIndex!}">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item layui-hide">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">fwZhsIndex</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" id="fwZhsIndex" name="fwZhsIndex" value="${fwZhsIndex!}">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房间号</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="fjh">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">室序号</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="sxh">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">物理层</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="wlcs">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">定义层</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="dycs">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">单元号</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="dyh">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋编码</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="fwbm">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">层高(m)</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="cg">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">权利ID</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="qlid">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">共有土地面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="gytdmj">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">预测建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="ycjzmj">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">实测建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="scjzmj">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">预测套内建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="yctnjzmj">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">实测套内建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="sctnjzmj">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">预测分摊建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="ycftjzmj">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">实测分摊建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="scftjzmj">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">预测地下部分建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="ycdxbfjzmj">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">实测地下部分建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="scdxbfjzmj">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">预测其他建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="ycqtjzmj">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">实测其它建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="scqtjzmj">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">预测分摊系数</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="ycftxs">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">实测分摊系数</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="scftxs">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">分摊土地面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="fttdmj">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">独用土地面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="dytdmj">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋用途</label>
                        <div class="layui-input-inline">
                            <select name="ghyt" lay-search="" lay-filter="ghyt" class="SZdFwytDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋类型</label>
                        <div class="layui-input-inline">
                            <select name="fwlx" lay-search="" lay-filter="fwlx" class="SZdFwlxDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋性质</label>
                        <div class="layui-input-inline">
                            <select name="fwxz" lay-search="" lay-filter="fwxz" class="SZdFwxzDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋结构</label>
                        <div class="layui-input-inline">
                            <select name="hxjg" lay-search="" lay-filter="hxjg" class="SZdHxjgDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">交易价格(万元)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="jyjg">
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">建成时装修程度</label>
                        <div class="layui-input-inline">
                            <select name="jczxcd" lay-search="" lay-filter="jczxcd" class="SZdJczxcdDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋户型</label>
                        <div class="layui-input-inline">
                            <select name="fwhx" lay-search="" lay-filter="fwhx" class="SZdFwhxDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item change-textarea-margin">
                    <label class="layui-form-label change-label-width">坐落</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="zl">
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">墙体归属 东</label>
                        <div class="layui-input-inline">
                            <select name="d" lay-search="" lay-filter="d" class="SZdQtgsDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">墙体归属 南</label>
                        <div class="layui-input-inline">
                            <select name="n" lay-search="" lay-filter="n" class="SZdQtgsDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">墙体归属 西</label>
                        <div class="layui-input-inline">
                            <select name="x" lay-search="" lay-filter="x" class="SZdQtgsDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">墙体归属 北</label>
                        <div class="layui-input-inline">
                            <select name="b" lay-search="" lay-filter="b" class="SZdQtgsDO">
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script type="text/html" id="SZdFwytDOTpl">
    {{# layui.each(d, function(index, zdItem){ }}
    <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
    {{# }); }}
</script>
<script type="text/html" id="SZdFwlxDOTpl">
    {{# layui.each(d, function(index, zdItem){ }}
    <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
    {{# }); }}
</script>
<script type="text/html" id="SZdFwxzDOTpl">
    {{# layui.each(d, function(index, zdItem){ }}
    <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
    {{# }); }}
</script>
<script type="text/html" id="SZdQtgsDOTpl">
    {{# layui.each(d, function(index, zdItem){ }}
    <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
    {{# }); }}
</script>
<script type="text/html" id="SZdHxjgDOTpl">
    {{# layui.each(d, function(index, zdItem){ }}
    <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
    {{# }); }}
</script>
<script type="text/html" id="SZdFwhxDOTpl">
    {{# layui.each(d, function(index, zdItem){ }}
    <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
    {{# }); }}
</script>
<script type="text/html" id="SZdJczxcdDOTpl">
    {{# layui.each(d, function(index, zdItem){ }}
    <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
    {{# }); }}
</script>
<script src="../lib/bdcui/js/form.js"></script>
<script>
    var zdList = {};
    $.ajax({
        url: "../zd/mul",
        dataType: "json",
        data: {
            zdDoNames: "SZdFwhxDO,SZdJczxcdDO,SZdFwytDO,SZdFwlxDO,SZdFwxzDO,SZdQtgsDO,SZdHxjgDO"
        },
        async: false,
        success: function (data) {
            zdList = $.extend({}, data)
        }
    });
    layui.use(['form', 'jquery', 'laytpl', 'element', 'laydate'], function () {
        var form = layui.form;
        var $ = layui.jquery;
        var laydate = layui.laydate;
        var laytpl = layui.laytpl;
        var element = layui.element;
        var layerIndex = parent.layer.getFrameIndex(window.name);
        //处理列表选择
        $.each(zdList, function (key, value) {
            var tpl = $("#" + key + "Tpl").html();
            laytpl(tpl).render(value, function (html) {
                $("." + key).append(html);
            });
        });

        //form验证
        form.render();
        var fwZhsIndex = $("#fwZhsIndex").val();
        if (fwZhsIndex) {
            loadFwzhs();
        }

        function loadFwzhs() {
            var fwZhsIndex = $("#fwZhsIndex").val();
            //获取数据
            // loading加载
            var loadIndex = layer.load(2, {shade: [0.1, '#fff']});
            $.ajax({
                url: "../fwzhs/querybyindex",
                dataType: "json",
                data: {
                    fwZhsIndex: fwZhsIndex
                },
                success: function (data) {
                    layer.closeAll();
                    //处理查询出来的数据
                    writeFwzhsxx(data)
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
        }

        //提交表单
        form.on("submit(saveFwZhs)", function (data) {
            var postData = data.field;
            var fwHsIndex = $("#fwHsIndex").val();
            if (fwHsIndex) {
                // loading加载
                var loadIndex = layer.load(2, {shade: [0.1, '#fff']});
                $.ajax({
                    url: "../fwzhs/save",
                    dataType: "json",
                    data: postData,
                    success: function (data) {
                        layer.closeAll();
                        if (data && data.success) {
                            if (data.data) {
                                form.val("form", data.data);
                            }
                            parent.reloadTable(layerIndex);
                        } else {
                            layer.alert("提交失败");
                        }
                    },
                    error: function (xhr, status, error) {
                        delAjaxErrorMsg(xhr);
                    }
                });
            } else {
                layer.message("户室主键为空，不能提交")
            }
            return false;
        })

        $("#jczhs").click(function () {
            layer.confirm('继承后将覆盖已有数据，是否继承？', function (index) {
                var fwHsIndex = $("#fwHsIndex").val();
                var fwZhsIndex = $("#fwZhsIndex").val();
                var hslx="${hslx!}"
                // loading加载
                var loadIndex = layer.load(2, {shade: [0.1, '#fff']});

                $.ajax({
                    url: "../fwzhs/extendfwhs",
                    dataType: "json",
                    data: {
                        fwZhsIndex: fwZhsIndex,
                        fwHsIndex: fwHsIndex,
                        hslx:hslx
                    },
                    success: function (data) {
                        layer.closeAll();
                        //处理查询出来的数据
                        writeFwzhsxx(data)
                    },
                    error: function (xhr, status, error) {
                        delAjaxErrorMsg(xhr)
                    }
                });
            })
        })

        function writeFwzhsxx(data) {
            form.val("form", data)
        }
    });

</script>
</body>

</html>
