<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>已有预测户室列表</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js"></script>
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/search.css?v=1.0.8">
    <link rel="stylesheet" href="../lib/bdcui/css/table.css">
</head>
<body>
<div class="bdc-table-box">
    <!--表单模块-->
    <form class="layui-form">
        <div class="layui-form-item pf-form-item">
            <table class="layui-table" lay-skin="nob">
                <colgroup>
                    <col width="10%">
                    <col width="30%">
                    <col width="10%">
                    <col width="30%">
                    <col width="20%">
                </colgroup>
                <tbody>
                <tr>
                    <td class="form-tb-lable">房间号:</td>
                    <td>
                        <input type="text" name="fjh" class="layui-input" autocomplete="off" placeholder="请输入房间号">
                    </td>
                    <td class="form-tb-lable">单元号:</td>
                    <td>
                        <input type="text" name="dyh" class="layui-input" autocomplete="off" placeholder="请输入单元号">
                    </td>
                    <td>
                        <button class="layui-btn layui-btn-normal bdc-major-btn" lay-submit="" id="query"
                                lay-filter="query"
                                type="button">
                            查询
                        </button>
                        <button type="reset" class="layui-btn layui-btn-normal bdc-secondary-btn" id="reset">重置</button>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    </form>
    <hr class="layui-bg-gray">
    <table id="tableList" lay-data="{id: 'tableList'}" lay-filter="dataTable"></table>
</div>
<script src="../lib/bdcui/js/table.js"></script>
<script>
    var fwDcbIndex = "${fwDcbIndex!}"
    //绑定回车键
    $(document).keydown(function (event) {
        if (event.keyCode == 13) {
            $("#query").click();
        }
    });
    layui.use(['jquery', 'layer', 'element', 'form', 'table', 'laytpl'], function () {
        var $ = layui.jquery;
        var element = layui.element;
        var form = layui.form;
        var table = layui.table;
        var laytpl = layui.laytpl;
        //父页面的该页面索引
        var index = parent.layer.getFrameIndex(window.name);
        //提交表单
        form.on("submit(query)", function (data) {
            var postData = data.field;
            postData.fwDcbIndex = fwDcbIndex
            tableReload('tableList', data.field)
            return false;
        })

        var tableConfig = {
            url: '../fwychs/listbypage'
            , where: {
                fwDcbIndex: fwDcbIndex
            }
            , limit: 7
            , limits: [7, 10, 15, 20]
            , cols: [[
                {type: 'numbers', fixed: 'left', width: '4%'},
                {
                    field: 'fjh', title: '房间号',
                    templet: '<div><a href="javascript:void(0);" onclick="" lay-event="pickFwhs" class="layui-table-link">{{d.fjh}}</a></div>',
                    width: '9%'
                },
                {field: 'dycs', title: '定义层数', width: '9%'},
                {field: 'sxh', title: '室序号', width: '9%'},
                {field: 'dyh', title: '单元号', width: '9%'},
                {field: 'bdcdyh', title: '不动产单元号', width: '25%'},
                {field: 'fwbm', title: '房屋编码', width: '10%'},
                {field: 'zl', title: '坐落', width: '25%'}
            ]]
        }
        //加载表格
        loadDataTablbeByUrl("#tableList", tableConfig);

        table.on('tool(dataTable)', function (obj) {
            var data = obj.data;
            if (data) {
                if (obj.event === "pickFwhs") {
                    //选择房屋户室
                    delete data.fwHsIndex
                    delete data.bdcdyh
                    delete data.fwbm
                    if (parent.jchsxx) {
                        parent.jchsxx(data)
                        parent.layer.close(index);
                    }
                }
            } else {
                layer.alert("当前数据主键缺失，请检查数据");
                return false
            }
        });

    })

</script>
</body>

</html>
