<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>房屋预测户室查询列表</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.1"></script>
    <link rel="stylesheet" href="../lib/bdcui/css/table.css">
    <link rel="stylesheet" href="../lib/bdcui/css/search.css">
</head>
<body>
<div class="bdc-table-box">
    <!--表单模块-->
    <form class="layui-form">
        <div class="layui-form-item pf-form-item">
            <div class="layui-inline">
                <label class="layui-form-label">不动产单元号</label>
                <div class="layui-input-inline">
                    <input type="text" name="bdcdyh" class="layui-input" placeholder="请输入不动产单元号">
                </div>
            </div>
            <div class="layui-inline">
                <label class="layui-form-label">坐落</label>
                <div class="layui-input-inline">
                    <input type="text" name="zl" class="layui-input" placeholder="请输入坐落">
                </div>
            </div>
            <div class="layui-inline">
                <button class="layui-btn layui-btn-normal bdc-major-btn" lay-submit="" id="query" lay-filter="query"
                        type="button">
                    查询
                </button>
                <button type="reset" class="layui-btn layui-btn-normal bdc-secondary-btn" id="reset">重置</button>
            </div>
        </div>
    </form>
    <hr class="layui-bg-gray">
    <table id="fwychsList" lay-data="{id: 'fwychsList'}" lay-filter="dataTable"></table>
</div>
<script type="text/html" id="toolbarDemo">
    <div class="layui-btn-container">
        <button class="layui-btn layui-btn-sm bdc-delete-btn" lay-event="delete">删除</button>
    </div>
</script>
<script type="text/html" id="fwychsListToolBarTmpl">
    <div class="layui-btn-container">
        <span class="layui-btn layui-btn-xs bdc-secondary-btn" lay-event="editYchs">修改</span>
    </div>
</script>
<script src="../lib/bdcui/js/table.js"></script>
<script>
    var zdList = {};
    var zdparam = "SZdFwlxDO,SZdFwytDO";
    $.ajax({
        url: "../zd/mul",
        data: "zdDoNames=" + zdparam,
        dataType: "json",
        async: false,
        success: function (data) {
            zdList = $.extend({}, data);
        }
    });
    layui.use(['jquery', 'layer', 'element', 'form', 'table', 'laytpl'], function () {
        var $ = layui.jquery;
        var element = layui.element;
        var form = layui.form;
        var table = layui.table;
        var laytpl = layui.laytpl;
        //提交表单
        form.on("submit(query)", function (data) {
            tableReload('fwychsList', data.field);
            return false;
        });

        var tableConfig = {
            toolbar: "#toolbarDemo"
            , url: '../fwychs/listbypage' //数据接口
            , cols: [[
                {type: 'checkbox', fixed: 'left', align: 'center', width: '50'},
                {field: 'lszd', title: '隶属宗地', width: '180'
                    ,templet: function (d) {
                        return splitDjh(d.lszd);
                    }
                },
                {field: 'bdcdyh', title: '不动产单元号', width: '200'
                    ,templet: function (d) {
                        return splitBdcdyh(d.bdcdyh);
                    }
                },
                {field: 'zl', title: '坐落', width: '200'},
                {field: 'fjh', title: '房间号', width: '80'},
                {field: 'dyh', title: '单元号', width: '80'},
                {field: 'wlcs', title: '物理层数', width: '100'},
                {field: 'qlr', title: '权利人', width: '100'},
                {
                    field: 'ghyt', title: '规划用途', width: '100',
                    templet: function (d) {
                        return convertZdDmToMc("SZdFwytDO", d.ghyt);
                    }
                },
                {field: 'scjzmj', title: '实测建筑面积(㎡)', width: '200'},
                {field: 'scftjzmj', title: '实测分摊建筑面积(㎡)', width: '200'},
                {field: 'sctnjzmj', title: '实测套内建筑面积(㎡)', width: '200'},
                {field: 'ycjzmj', title: '预测建筑面积(㎡)', width: '200'},
                {field: 'yctnjzmj', title: '预测套内建筑面积(㎡)', width: '200'},
                {field: 'ycftjzmj', title: '预测分摊建筑面积(㎡)', width: '200'},
                {
                    field: 'fwlx', title: '房屋类型', width: '200',
                    templet: function (d) {
                        return convertZdDmToMc("SZdFwlxDO", d.fwlx);
                    }
                },
                {title: '操作', align: 'center', fixed: 'right', width: '70', toolbar: '#fwychsListToolBarTmpl'}
            ]]
        };

        //加载表格
        loadDataTablbeByUrl("#fwychsList", tableConfig);

        //头工具栏事件
        table.on('toolbar(dataTable)', function (obj) {
            //获取选中行状态
            var checkStatus = table.checkStatus(obj.config.id);
            //获取选中行数据,目前只为单选，不考虑多条数据情况
            var data = checkStatus.data;
            if (data && data.length > 0) {
                if (obj.event === "delete") { //删除
                    layer.confirm('确定删除？', function (index) {
                        deleteYcfwhs(data);
                        return false
                    });
                }
            }

        });
        table.on('tool(dataTable)', function (obj) {
            var data = obj.data;
            if (data && data.fw_hs_index) {
                if (obj.event === "editYchs") {
                    var index = layer.open({
                        type: 2,
                        title: "编辑预测户室",
                        maxmin: true,
                        area: ['100%', '100%'],
                        fixed: false, //不固定
                        content: '../fwychs/info?fwDcbIndex=' + data.fw_dcb_index + "&fwHsIndex=" + data.fw_hs_index
                        , end: function (index, layero) {
                            refreshView();
                            return false;
                        }
                    });
                    layer.full(index)
                    return false
                }
            } else {
                layer.alert("当前数据主键缺失，请检查数据");
                return false
            }
        });

        function deleteYcfwhs(data) {
            var fwHsIndexList = [];
            for (var i = 0; i < data.length; i++) {
                fwHsIndexList.push(data[i].fw_hs_index);
            }
            // loading加载
            var loadIndex = layer.load(2, {shade: [0.1, '#fff']});
            $.ajax({
                url: "../fwychs/delbyindex",
                type: "GET",
                data: "fwHsIndexList=" + encodeURI(fwHsIndexList),
                success: function (data) {
                    layer.closeAll();
                    if (!data || !data.success) {
                        layer.alert("删除失败");
                    }
                    $("#query").click();
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
        }
    })
</script>
</body>

</html>
