<!DOCTYPE html>
<html lang="zh-cn">
<head>
    <meta charset="utf-8">
    <title>房屋预测户室基本信息编辑</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form-tab.css"/>
    <link rel="stylesheet" href="../lib/bdcui/css/form.css?v=1.0.3">
    <link rel="stylesheet" href="../lib/bdcui/css/search.css"/>
    <link rel="stylesheet" href="../lib/bdcui/css/table.css"/>
    <link rel="stylesheet" href="../css/upload.css?v=1.13">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.2"></script>
    <script src="../lib/bdcui/js/form.js?v=1.1"></script>
    <script src="../lib/bdcui/js/table.js"></script>
</head>
<body>
<div class="bdc-form-div">
    <form class="layui-form setOverflow" lay-filter="form">
        <div class="content-title layui-clear">
            <div class="title-btn-area">
                <button class="layui-btn bdc-major-btn" lay-submit="" id="saveForm" lay-filter="saveForm">提交</button>
            </div>
        </div>
        <div class="layui-tab" lay-filter="tabFilter">
            <ul class="layui-tab-title">
                <li class="layui-this" id="hsTab">户室信息</li>
                <li id="dcxxTab">调查信息</li>
                <li id="qlrTab">房产权利人</li>
                <li id="zhsTab">子户室列表</li>
                <li id="hstTab">户室图</li>
            </ul>
            <div class="layui-tab-content">
                <div class="layui-tab-item layui-show">
                    <div class="bdc-tab-btn">
                        <button class="layui-btn layui-btn-sm bdc-secondary-btn" id="jcyyhs" type="button">
                            继承已有户室
                        </button>
                        <button class="layui-btn layui-btn-sm bdc-secondary-btn layui-hide" id="getBdcdyh"
                                type="button">获取不动产单元号
                        </button>
                    </div>
                    <div class="basic-info">
                        <div class="title-sign"><a id="hsxx" href="javascript:;"></a></div>
                        <!--表单块的标题-->
                        <div class="layui-form-item change-textarea-margin layui-hide">
                            <label class="layui-form-label change-label-width">不动产单元编号</label>
                            <div class="layui-input-inline">
                                <input type="text" class="layui-input" name="bdcdyh" id="bdcdyh" disabled>
                            </div>
                        </div>
                        <div class="layui-form-item layui-hide">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">fwhsIndex</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="fwHsIndex" id="fwHsIndex"
                                           value="${fwHsIndex!}">
                                </div>
                                <label class="layui-form-label change-label-width">fwDcbIndex</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="fwDcbIndex" id="fwDcbIndex"
                                           value="${fwDcbIndex!}">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房间号</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="fjh">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">室序号</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="sxh">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">物理层数</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="wlcs">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">定义层数</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="dycs">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">单元号</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="dyh">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋编码</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="fwbm">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">层高(m)</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="cg">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">权利ID</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="qlid">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">共有土地面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="gytdmj">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">预测建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="ycjzmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">实测建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="scjzmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">预测套内建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="yctnjzmj">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">实测套内建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="sctnjzmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">预测分摊建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="ycftjzmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">实测分摊建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="scftjzmj">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">预测地下部分建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="ycdxbfjzmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">实测地下部分建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="scdxbfjzmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">预测其他建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="ycqtjzmj">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">实测其它建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="scqtjzmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">预测分摊系数</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="ycftxs">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">实测分摊系数</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="scftxs">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">分摊土地面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="fttdmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">独用土地面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="dytdmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋用途</label>
                                <div class="layui-input-inline">
                                    <select name="ghyt" lay-search="" lay-filter="ghyt" class="SZdFwytDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">土地用途</label>
                                <div class="layui-input-inline">
                                    <select name="tdyt" lay-search="" lay-filter="tdyt" class="SZdDldmDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">土地使用权类型</label>
                                <div class="layui-input-inline">
                                    <select name="tdsyqlx" lay-search="" lay-filter="tdsyqlx" class="SZdTdsyqlxDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">起始日期</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" id="qsrq" name="qsrq">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">终止日期</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="zzrq" id="zzrq">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋类型</label>
                                <div class="layui-input-inline">
                                    <select name="fwlx" lay-search="" lay-filter="fwlx" class="SZdFwlxDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋性质</label>
                                <div class="layui-input-inline">
                                    <select name="fwxz" lay-search="" lay-filter="fwxz" class="SZdFwxzDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">交易价格(万元)</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="jyjg">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">建成时装修程度</label>
                                <div class="layui-input-inline">
                                    <select name="jczxcd" lay-search="" lay-filter="jczxcd" class="SZdJczxcdDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋户型</label>
                                <div class="layui-input-inline">
                                    <select name="fwhx" lay-search="" lay-filter="fwhx" class="SZdFwhxDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋结构</label>
                                <div class="layui-input-inline">
                                    <select name="hxjg" lay-search="" lay-filter="hxjg" class="SZdHxjgDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">是否附属设施</label>
                                <div class="layui-input-inline">
                                    <select name="isfsss" lay-search="" lay-filter="isfsss" class="SZdBoolDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt layui-hide">
                                <label class="layui-form-label change-label-width">产别</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="cb">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">参与分摊土地面积计算</label>
                                <div class="layui-input-inline">
                                    <select name="syfttdmjjs" lay-search="" lay-filter="b" class="SZdSyfttdmjjsDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">坐落</label>
                            <div class="layui-input-inline">
                                <input type="text" class="layui-input" name="zl">
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">墙体归属 东</label>
                                <div class="layui-input-inline">
                                    <select name="d" lay-search="" lay-filter="d" class="SZdQtgsDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">墙体归属 南</label>
                                <div class="layui-input-inline">
                                    <select name="n" lay-search="" lay-filter="n" class="SZdQtgsDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">墙体归属 西</label>
                                <div class="layui-input-inline">
                                    <select name="x" lay-search="" lay-filter="x" class="SZdQtgsDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">墙体归属 北</label>
                                <div class="layui-input-inline">
                                    <select name="b" lay-search="" lay-filter="b" class="SZdQtgsDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">备注</label>
                            <div class="layui-input-inline">
                                <textarea class="layui-textarea change-textarea-width" name="bz"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="layui-tab-item">
                    <div class="basic-info" id="dcxxForm">
                        <div class="title-sign"><a id="dcxx" href="javascript:;"></a></div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">调查者</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="dcz" id="dcz">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">调查时间</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="dcsj" id="dcsj">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">产权来源</label>
                            <div class="layui-input-inline">
                                <textarea class="layui-textarea change-textarea-width" name="cqly"></textarea>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">共有情况</label>
                            <div class="layui-input-inline">
                                <textarea class="layui-textarea change-textarea-width" name="gyqk"></textarea>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">附加说明</label>
                            <div class="layui-input-inline">
                                <textarea class="layui-textarea change-textarea-width" name="fjsm"></textarea>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">调查意见</label>
                            <div class="layui-input-inline">
                                <textarea class="layui-textarea change-textarea-width" name="dcyj"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="layui-tab-item">
                    <div class="bdc-tab-btn">
                        <button class="layui-btn layui-btn-sm bdc-secondary-btn" id="addQlr" type="button">新增权利人
                        </button>
                    </div>
                    <div class="basic-info" id="qlrForm">
                        <div class="title-sign"><a id="qlrxx" href="javascript:;"></a></div>
                        <div class="form-margin-area">
                            <div class="basic-info">
                                <!--表单块的标题-->
                                <input type="text" class="layui-input layui-hide" name="fwIndex" id="fwIndex"
                                       value="${fwHsIndex!}">

                                <div class="layui-collapse" lay-filter="test" id="qlrList">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="layui-tab-item">
                    <div class="bdc-tab-btn">
                    </div>
                    <div class="bdc-table-box">
                        <table id="fwzhsList" lay-data="{id: 'fwzhsList'}" lay-filter="dataTable"></table>
                    </div>
                </div>
                <div class="layui-tab-item">
                    <div class="bdc-tab-btn">
                        <button class="layui-btn layui-btn-sm  bdc-major-btn layui-hide" id="downHst" type="button">下载
                        </button>
                        <button class="layui-btn layui-btn-sm  bdc-delete-btn layui-hide" id="deletHst" type="button">
                            删除
                        </button>
                    </div>
                    <div class="bdc-upload-dragdiv">
                        <div class="layui-upload-drag img-drag" id="hst">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
</body>
<script type="text/html" id="uploadTpl">
    {{# if(d.srcUrl){ }}
    <img id="img" class="upload-img" src="{{d.srcUrl}}" alt="">
    {{# }else{ }}
    <div class="upload-icon">
        <i class="layui-icon">&#xe654;</i>
        <span>上传户室图</span>
    </div>
    <h4>点击/拖拽单个文件到这里上传</h4>
    <p>支持jpeg、jpg、png格式，大小在10M以下</p>
    <img id="img" class="upload-img" src="" alt="">
    <div class="video-icon"></div>
    {{# } }}
</script>
<script type="text/html" id="qlrTpl">
    {{# layui.each(d.data, function(index, item){ }}
    {{# var length=d.start+index }}
    <div class="layui-colla-item">
        <div class="layui-colla-title">
            <span id="{{ item.fwFcqlrIndex || ''}}" class="layui-btn layui-btn-sm bdc-delete-btn colla-title-btn"
                  onclick="delQlr(this)">删除
            </span>
            <h3>{{ item.qlr || '权利人'}}</h3>
        </div>
        <div class="layui-colla-content layui-show">
            <div class="layui-form-item layui-hide">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人id</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].fwFcqlrIndex"
                               value="{{ item.fwFcqlrIndex || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].qlr"
                               value="{{ item.qlr || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人证件类型</label>
                    <div class="layui-input-inline">
                        <select name="qlrList[{{length}}].qlrzjlx" lay-search="" lay-filter="zjlx">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdZjllxDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==item.qlrzjlx){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人证件号</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].qlrzjh"
                               value="{{ item.qlrzjh || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人序号</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].qlrbh" value="{{length+1}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">发证机关</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].fzjg"
                               value="{{ item.fzjg || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">性别</label>
                    <div class="layui-input-inline">
                        <select name="qlrList[{{length}}].xb" lay-search="" lay-filter="xb">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdQlrxbDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==item.xb){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">电话</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].dh" value="{{ item.dh || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">邮编</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].yb" value="{{ item.yb || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">工作单位</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].gzdw"
                               value="{{ item.gzdw || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利人性质</label>
                    <div class="layui-input-inline">
                        <select name="qlrList[{{length}}].qlrxz" lay-search="" lay-filter="qlrxz">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdQlrxzDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==item.qlrxz){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">共有方式</label>
                    <div class="layui-input-inline">
                        <select name="qlrList[{{length}}].gyfs" lay-search="" lay-filter="gyfs">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdGyfsDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==item.gyfs){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利比例</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].qlbl"
                               value="{{ item.qlbl || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利面积</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="qlrList[{{length}}].qlmj"
                               value="{{ item.qlmj || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">地址</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="qlrList[{{length}}].dz" value="{{ item.dz || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item change-textarea-margin">
                <label class="layui-form-label change-label-width">备注</label>
                <div class="layui-input-inline">
                    <textarea class="layui-textarea" name="qlrList[{{length}}].bz"
                              value="{{ item.bz || ''}}"></textarea>
                </div>
            </div>
        </div>
    </div>
    {{# }); }}
</script>
<script type="text/html" id="DmMcTpl">
    {{# layui.each(d, function(index, zdItem){ }}
    <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
    {{# }); }}
</script>
<script type="text/html" id="toolbar">
    <div class="layui-btn-container">
        <button class="layui-btn layui-btn-sm bdc-major-btn" type="button" lay-event="addzhs">添加</button>
        <button class="layui-btn layui-btn-sm bdc-delete-btn" type="button" lay-event="delzhs">删除</button>
    </div>
</script>
<script type="text/html" id="fwzhsListToolBarTmpl">
    <div class="layui-btn-container">
        <span class="layui-btn layui-btn-xs bdc-major-btn" lay-event="updatezhs">更新</span>
    </div>
</script>
<script>
    var zdList = {}
    // 文档中心地址
    var storageUrl = '${storageUrl!}';

    // 房屋户室主键
    var fwHsIndex = '${fwHsIndex!}';

    // 户室图主键
    var fwHstIndex = '';
    var bdcdyfwlx = ""
    $.ajax({
        url: "../zd/mul",
        dataType: "json",
        data: {
            zdDoNames: "SZdFwhxDO,SZdJczxcdDO,SZdFwytDO,SZdDldmDO,SZdTdsyqlxDO,SZdFwlxDO,SZdFwxzDO,SZdQtgsDO,SZdBoolDO,SZdHxjgDO,SZdGyfsDO,SZdQlrxzDO,SZdQlrxbDO,SZdZjllxDO,SZdSyfttdmjjsDO"
        },
        async: false,
        success: function (data) {
            zdList = $.extend({}, data)
        }
    });

    layui.use(['form', 'jquery', 'laytpl', 'element', 'laydate', 'table', 'upload'], function () {
        var form = layui.form;
        var $ = layui.jquery;
        var laydate = layui.laydate;
        var laytpl = layui.laytpl;
        var element = layui.element;
        var table = layui.table;
        var upload = layui.upload;
        //处理列表选择
        var tpl = $("#DmMcTpl").html();
        $.each(zdList, function (key, value) {
            laytpl(tpl).render(value, function (html) {
                $("." + key).append(html);
            });
        })

        laydate.render({
            elem: '#qsrq'
        });
        laydate.render({
            elem: '#zzrq'
        });
        laydate.render({
            elem: '#dcsj'
            , type: 'datetime'
        });

        //form初始化
        form.render();

        if ($("#fwDcbIndex").val()) {
            //根据逻辑幢类型判断是否显示不动产单元号
            $.ajax({
                url: "../ljz/infoljz",
                dataType: "json",
                data: {
                    fwDcbIndex: $("#fwDcbIndex").val()
                },
                success: function (data) {
                    if (data && data.bdcdyfwlx) {
                        bdcdyfwlx = data.bdcdyfwlx;
                        if (data.bdcdyfwlx == "4") {
                            $("input[name='bdcdyh']").parent().parent().removeClass("layui-hide")
                        }
                    }
                }

            });
        }

        if ($("#fwHsIndex").val()) {
            loadFwhs();
            //loadQlrList()
            //加载表格
        }
        //提交表单
        form.on("submit(saveForm)", function (data) {
            var postData = data.field;
            postData.bdcdyh = postData.bdcdyh.replace(/\s*/g, "");
            if ($("#fwDcbIndex").val()) {
                // loading加载
                var loadIndex = layer.load(2, {shade: [0.1, '#fff']});
                $.ajax({
                    url: "../fwychs/saveorupdate",
                    dataType: "json",
                    type: "post",
                    data: {jsonData:JSON.stringify(formSubmitDealJson(postData))},
                    success: function (data) {
                        layer.close(loadIndex);
                        if (data && data.success) {
                            layer.msg("提交成功");
                            if (data.data) {
                                form.val("form", data.data);
                            }
                        } else if (data && data.msg) {
                            layer.alert(data.msg);
                        } else {
                            layer.alert("提交失败");
                        }
                    },
                    error: function (xhr, status, error) {
                        delAjaxErrorMsg(xhr)
                    }
                });
            } else {
                layer.alert("逻辑幢主键为空，不能提交")
            }
            return false;
        })


        element.on('tab(tabFilter)', function(data){
            var tabid=$(".layui-tab-title .layui-this").attr("id");
            if(tabid=="qlrTab"){
                if($("#fwHsIndex").val()){
                    loadQlrList();
                }else {
                    generateQlrList();
                }
                $('#qlrTab').attr('id', 'newQlrTab');
            }else if(tabid=="zhsTab"){
                loadDataTablbeByUrl("#fwzhsList", tableConfig);
                $('#zhsTab').attr('id', 'newZhsTab');
            }else if(tabid=="hstTab"){
                if ($("#fwHsIndex").val()) {
                    var imgElementSrc = $("#img").attr("src");
                    if(!imgElementSrc){
                        // 查询 户室图
                        $.ajax({
                            url: "../hst/queryfwhst?fwlx=yc",
                            dataType: "json",
                            data: {
                                fwHsIndex: $("#fwHsIndex").val()
                            },
                            async: false,
                            success: function (data) {
                                if (data.fwHstIndex) {
                                    fwHstIndex = data.fwHstIndex;
                                }
                                if (data.src) {
                                    renderTpl({srcUrl: data.src});
                                    $("#downHst").removeClass("layui-hide");
                                    $("#deletHst").removeClass("layui-hide");
                                } else {
                                    renderTpl({});
                                }
                            },
                            error: function (xhr, status, error) {
                                delAjaxErrorMsg(xhr)
                            }
                        });
                    }
                } else {
                    $("#hst").addClass("layui-hide");
                    layer.alert("请先保存户室信息");
                }
            }
        });


        //拖拽上传
        upload.render({
            elem: '#hst'
            , url: '../hst/uploadfwhst?fwHstIndex=' + fwHstIndex +"&fwlx=yc"
            , data: {
                fwHsIndex: function () {
                    return $("#fwHsIndex").val()
                }
            }
            , accept: 'file'
            , auto: true
            , done: function (res) {
                if (res.success && res.imgId && res.fwHstIndex) {
                    fwHstIndex = res.fwHstIndex;
                    var imgUrl = storageUrl + "/rest/files/download/" + res.imgId;
                    renderTpl({srcUrl: imgUrl});
                    $("#downHst").removeClass("layui-hide");
                    $("#deletHst").removeClass("layui-hide");
                    layer.closeAll();
                    layer.msg("上传成功");
                } else {
                    layer.closeAll();
                    layer.msg("上传失败");
                }
            }
            , before:function(){
                var loadIndex = layer.load(1, {shade: [0.3, '#000']});
            }
            ,error : function () {
                layer.closeAll();
            }
        });

        $("#jcyyhs").click(function () {
            var index = layer.open({
                type: 2,
                title: "选择已有户室",
                area: ['950px', '505px'],
                fixed: false, //不固定
                content: '../fwychs/listbyljz?fwDcbIndex=' + $("#fwDcbIndex").val()
            });
        })

        function writeFwhsxx(data) {
            if (data.bdcdyh) {
                data.bdcdyh = splitBdcdyh(data.bdcdyh);
            }
            form.val("form", data);
            //generateQlrList(data.qlrList, 0)
            if (!$("#bdcdyh").val() && bdcdyfwlx == "4") {
                $("#getBdcdyh").removeClass("layui-hide");
            }
        }

        //页面入口
        function loadFwhs() {
            //获取数据
            var index = layer.load(1, {shade: [0.1, '#fff']});
            $.ajax({
                url: "../fwychs/infofwychs",
                dataType: "json",
                data: {
                    fwHsIndex: $("#fwHsIndex").val()
                },
                success: function (data) {
                    layer.closeAll();
                    //处理查询出来的数据
                    writeFwhsxx(data)

                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
        }

        //头工具栏事件
        table.on('toolbar(dataTable)', function (obj) {
            var checkStatus = table.checkStatus(obj.config.id);
            var data = checkStatus.data;
            // 删除子户室
            if (obj.event === "delzhs") {
                if (data && data.length >= 1) {
                    layer.confirm('确认删除？', function (index) {
                        var fwZhsIndexList = [];
                        for (var i = 0; i < data.length; i++) {
                            fwZhsIndexList.push(data[i].fwZhsIndex);
                        }
                        deleteFwzhsFun(fwZhsIndexList);
                    });
                } else {
                    layer.msg("至少选择一条数据");
                }
            }
            // 新增子户室
            if (obj.event === "addzhs") {
                if($("#fwHsIndex").val()){
                    // 打开合并页面
                    layer.open({
                        type: 2,
                        title: "新增子户室",
                        area: ['100%', '100%'],
                        content: "../fwzhs/info?fwHsIndex=" + $("#fwHsIndex").val() + "&hslx=" + "yc"
                        , end: function (index, layero) {
                            tableReload('fwzhsList',{fwHsIndex:$("#fwHsIndex").val()});
                            return false;
                        }
                    });
                }else {
                    layer.alert("请先保存户室信息");
                }

            }
        });

        // 修改子户室
        table.on('tool(dataTable)', function (obj) {
            var data = obj.data;
            if (obj.event === "updatezhs") {
                if (data && data.fwZhsIndex) {
                    var zhsIndex = data.fwZhsIndex;
                    layer.open({
                        type: 2,
                        title: "修改子户室",
                        area: ['100%', '100%'],
                        content: "../fwzhs/info?fwHsIndex=" + $("#fwHsIndex").val() + "&fwZhsIndex=" + zhsIndex
                        , end: function (index, layero) {
                            tableReload('fwzhsList');
                            return false;
                        }
                    });
                } else {
                    layer.msg("子户室主键缺失");
                }
            }
        })

        function deleteFwzhsFun(fwZhsIndexList) {
            var loadIndex = layer.load(2, {shade: [0.1, '#fff']})
            $.ajax({
                url: "../fwzhs/batchdel",
                type: "post",
                data: {
                    fwZhsIndexListJson: JSON.stringify(fwZhsIndexList)
                },
                success: function (data) {
                    layer.closeAll();
                    if (!data || !data.success) {
                        layer.alert("删除失败");
                    }
                    tableReload('fwzhsList');
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
        }
    });

    //由子页面调用覆盖数据
    function jchsxx(dom) {
        if (dom) {
            dom.bdcdyh = $("#bdcdyh").val();
            layui.use(['form'], function () {
                var form = layui.form;
                form.val("form", $.extend({}, dom))
            });
        }
    }

    //添加权利人
    $("#addQlr").click(function () {
        $("html,body").animate({scrollTop: $('#qlrForm').offset().top - 119 + "px"}, 200);
        generateQlrList([{}], $(".layui-colla-item").length);
    })

    //加载权利人
    function loadQlrList() {
        //获取数据
        var index = layer.load(1, {shade: [0.1, '#fff']});
        $.ajax({
            url: "../fwqlr/listqlr",
            dataType: "json",
            data: {
                fwIndex: $("#fwHsIndex").val()
            },
            success: function (data) {
                layer.closeAll();
                //处理查询出来的数据
                if (data && data.success) {
                    if (data.data) {
                        generateQlrList(data.data, 0)
                    }
                } else {
                    generateQlrList();
                }

            },
            error: function (xhr, status, error) {
                delAjaxErrorMsg(xhr)
            }
        });
    }

    //生成权利人list表单 qlrList：权利人列表 listStartWhith：从第几个开始生成 isFg：是否需要覆盖
    function generateQlrList(qlrList, listStartWhith) {
        layui.use(['form', 'jquery', 'laytpl', 'element'], function () {
            var form = layui.form;
            var $ = layui.jquery;
            var laytpl = layui.laytpl;
            var element = layui.element;
            if (qlrList == null) {
                qlrList = [{}]
            }
            if (listStartWhith == null) listStartWhith = 0;
            var json = {
                start: listStartWhith,
                data: qlrList,
                zdList: zdList
            }
            //获取模板
            var tpl = $("#qlrTpl").html();
            //渲染数据
            laytpl(tpl).render(json, function (html) {
                if (listStartWhith === 0) {
                    //如果覆盖之前的
                    $("#qlrList").html(html);
                } else {
                    $("#qlrList").append(html);
                }
            });
            form.render();
            element.render();
            listStartWhith = listStartWhith + qlrList.length;
            if (qlrList.length == 0) {
                listStartWhith++;
            }
            return listStartWhith;
        })
    }

    //删除权利人
    function delQlr(delDom) {
        event.stopPropagation();
        layer.open({
            content: '删除操作后会重新加载数据，确定是否有未提交数据？'
            , btn: ['确定', '取消']
            , yes: function (index, layero) {
                if (delDom.id) {
                    layer.open({
                        content: '这条权利人已经入库，将直接从数据库删除，是否确定？'
                        , btn: ['确定', '取消']
                        , yes: function (index, layero) {
                            $.ajax({
                                url: "../fwqlr/deleteqlr",
                                dataType: "json",
                                data: {
                                    fwFcqlrIndex: delDom.id
                                },
                                success: function (data) {
                                    if (data && data.success) {
                                        layer.msg("成功")
                                        loadQlrList();
                                    } else {
                                        layer.alert("删除失败，请检查数据!")
                                    }
                                    layer.closeAll();
                                },
                                error: function (xhr, status, error) {
                                    delAjaxErrorMsg(xhr)
                                }
                            });
                        }

                    });
                } else {
                    $(delDom).parent().parent().remove();
                    layer.closeAll();
                }
            }
        });
    }

    $("#getBdcdyh").click(function () {
        if (!$("#fwDcbIndex").val()) {
            layer.alert("请先挂接宗地与自然幢")
            return false;
        }
        $.ajax({
            url: "../bdcdyh/createbdcdyhbyfwdcbindex",
            dataType: "json",
            data: {fwDcbIndex: $("#fwDcbIndex").val()},
            success: function (data) {
                layer.closeAll();
                if (data && data.success && data.bdcdyh) {
                    layer.msg("获取成功")
                    $("input[name='bdcdyh']").val(data.bdcdyh)
                    $("#getBdcdyh").addClass("layui-hide")
                } else {
                    layer.alert("获取失败，请检查隶属宗地与自然幢号")
                }
            },
            error: function (xhr, status, error) {
                delAjaxErrorMsg(xhr)
            }
        });
    })

    // 下载图片
    $("#downHst").click(function () {
        var srcURL = $("#img").attr("src");
        if (srcURL && srcURL.indexOf("storage") > 0) {
            window.open(srcURL + "?attachment=1");
        } else {
            layer.msg("当前图片不支持下载");
        }
    });

    // 删除按钮
    $("#deletHst").click(function () {
        // 删除户室图
        $.ajax({
            url: "../hst/delfwhst",
            dataType: "json",
            data: {
                fwHsIndex: fwHsIndex
            },
            async: false,
            success: function (data) {
                if (data.success) {
                    renderTpl({});
                    // 户室图主键清空
                    fwHstIndex = "";
                    layer.msg("删除成功");
                }
            },
            error: function (xhr, status, error) {
                delAjaxErrorMsg(xhr)
            }
        });

    });


    function renderTpl(json) {
        $("#hst").removeClass("layui-hide");
        layui.use('laytpl', function () {
            //获取模板
            var tpl = $("#uploadTpl").html();
            var laytpl = layui.laytpl;
            //渲染数据
            laytpl(tpl).render(json, function (html) {
                $("#hst").html(html);
            });
        })
    }

    // 编辑页面回调函数
    function reloadTable(layerIndex) {
        layer.msg("提交成功");
        tableReload('fwzhsList');
    }

    var tableConfig = {
        toolbar: "#toolbar"
        , url: '../fwzhs/listbypage' //数据接口
        , where: {fwHsIndex: ($("#fwHsIndex").val() ? $("#fwHsIndex").val() : "ttttttt")}
        , cols: [[
            {type: 'checkbox', fixed: 'left', align: 'center', width: '50'},
            {field: 'fjh', title: '房间号', width: '100'},
            {field: 'dyh', title: '单元号', width: '100'},
            {field: 'wlcs', title: '物理层数', width: '90'},
            {field: 'scjzmj', title: '实测建筑面积(㎡)', width: '180'},
            {field: 'sctnjzmj', title: '实测套内建筑面积(㎡)', width: '180'},
            {field: 'scftjzmj', title: '实测分摊建筑面积(㎡)', width: '180'},
            {field: 'ycjzmj', title: '预测建筑面积(㎡)', width: '180'},
            {field: 'yctnjzmj', title: '预测套内建筑面积(㎡)', width: '180'},
            {field: 'ycftjzmj', title: '预测分摊建筑面积(㎡)', width: '180'},
            {
                field: 'fwlx', title: '房屋类型', width: '100',
                templet: function (d) {
                    return convertZdDmToMc("SZdFwlxDO", d.fwlx);
                }
            },
            {
                field: 'hxjg', title: '户型结构', width: '100',
                templet: function (d) {
                    return convertZdDmToMc("SZdHxjgDO", d.hxjg);
                }
            },
            {title: '操作', align: 'center', fixed: 'right', width: '100', toolbar: '#fwzhsListToolBarTmpl'}
        ]]
    }
</script>
</html>