<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>预测实测关联</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.1"></script>
    <script src="../js/fwhsbg.js?v=15"></script>
    <link rel="stylesheet" href="../lib/bdcui/css/table.css">
    <link rel="stylesheet" href="../lib/bdcui/css/search.css">
    <link rel="stylesheet" href="../css/ycscgl.css?v=1">
    <script src="../lib/bdcui/js/table.js"></script>
</head>
<body>
<div class="bdc-table-box">
    <div class="layui-fluid">
        <div class="layui-row">
            <div class="layui-col-md5"  style="width: 44%">
                <div class="bdc-search-box">
                    <form class="layui-form" lay-filter="ycform">
                        <div class="layui-inline">
                            <label class="layui-form-label">预测房间号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="fjh" autocomplete="off" placeholder="请输入房间号"
                                       class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <a href="javascript:;" class="layui-btn layui-btn-normal bdc-major-btn" lay-submit=""
                               lay-filter="ycsearch" id="ycsearch">查询</a>
                            <button type="reset" class="layui-btn layui-btn-normal bdc-secondary-btn" id="ycreset">重置
                            </button>
                        </div>
                    </form>
                </div>
                <!--表格开始-->
                <div class="bdc-table-box">
                    <table id="fwychsTable" lay-data="{id: 'fwychsTable'}" lay-filter="fwychsTable"></table>
                </div>
            </div>
            <div class="layui-col-md2"  style="width: 12%">
                <div class="demoTable">
                    <button class="layui-btn layui-btn-primary" style="width: 115px" data-type="zzgl" id="zzgl"
                            type="button">整幢关联<i class="layui-icon"></i></button>
                    <button class="layui-btn layui-btn-primary" style="width: 115px" data-type="qxzzgl" id="qxzzgl"
                            type="button">取消整幢关联<i class="layui-icon"></i></button>
                    <button class="layui-btn layui-btn-primary" data-type="ycglsc" id="ycglsc"
                            type="button">关&emsp;&emsp;联<i class="layui-icon"></i></button>
                    <button class="layui-btn layui-btn-primary" data-type="qxgl" id="qxgl"
                            type="button"><i class="layui-icon"></i>取消关联
                    </button>
                    <button class="layui-btn layui-btn-primary" data-type="ckglschs" id="ckglschs"
                            type="button">查看关联<i class="layui-icon"></i></button>
                    <button class="layui-btn layui-btn-primary" data-type="ckglychs" id="ckglychs"
                            type="button"><i class="layui-icon"></i>查看关联
                    </button>
                </div>


            </div>
            <div class="layui-col-md5"  style="width: 44%">
                <div class="bdc-search-box">
                    <form class="layui-form" lay-filter="scform">
                        <div class="layui-inline">
                            <label class="layui-form-label">实测房间号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="fjh" autocomplete="off" placeholder="请输入房间号"
                                       class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <a href="javascript:;" class="layui-btn layui-btn-normal bdc-major-btn" lay-submit=""
                               lay-filter="scsearch" id="scsearch">查询</a>
                            <button type="reset" class="layui-btn layui-btn-normal bdc-secondary-btn" id="screset">重置
                            </button>
                        </div>
                    </form>
                </div>
                <div class="bdc-table-box">
                    <table id="fwhsTable" lay-data="{id: 'fwhsTable'}" lay-filter="fwhsTable"></table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    var fwDcbIndex = "${fwDcbIndex!}"
    layui.use(['jquery', 'form', 'table'], function () {
        var $ = layui.jquery;
        var form = layui.form;
        var table = layui.table;
        var cols = [[
            {type: 'checkbox', fixed: 'left', align: 'center', width: '50'},
            {field: 'fjh', title: '房间号', width: '80'},
            {field: 'dyh', title: '单元号', width: '70'},
            {field: 'glhs', title: '已关联', width: '90'},
            {field: 'bdcdyh', title: '不动产单元号', width: '200'
                ,templet: function (d) {
                    return splitBdcdyh(d.bdcdyh);
                }
            },
            {field: 'wlcs', title: '物理层数', width: '100'},
            {field: 'zl', title: '坐落', width: '200'},
        ]]
        var tableYcConfig = {
            url: '../fwychs/gl/listbypage?sort=fjh&fwDcbIndex=' + fwDcbIndex
            , cols: cols
        };
        var tableScConfig = {
            url: '../fwhs/gl/listbypage?sort=fjh&fwDcbIndex=' + fwDcbIndex
            , cols: cols
        };

        loadDataTablbeByUrl("#fwhsTable", tableScConfig);
        loadDataTablbeByUrl("#fwychsTable", tableYcConfig);

        var $ = layui.$, active = {
            ycglsc: function () {
                var fwychsData = table.checkStatus('fwychsTable').data;
                var fwhsData = table.checkStatus('fwhsTable').data;
                if (fwychsData.length < 1 || fwhsData.length < 1) {
                    layer.alert("请左右各最少选择一个")
                } else if (fwychsData.length == 1 || fwhsData.length == 1) {
                    var postData = {};
                    $.each(fwychsData, function (index, data) {
                        postData["ychsIndexList[" + index + "]"] = data.fwHsIndex
                    })
                    var schsHasYcfwbm = false;
                    $.each(fwhsData, function (index, data) {
                        if (data.ycfwbm) {
                            schsHasYcfwbm = true
                            return false;
                        }
                        postData["schsIndexList[" + index + "]"] = data.fwHsIndex
                    })
                    if (schsHasYcfwbm) {
                        layer.alert("当前选择的实测户室已经有关联，请先取消");
                        return false;
                    }
                    var index = layer.load(2, {shade: [0.1, '#fff']});
                    $.ajax({
                        url: "../fwhsgl/ycschsgl",
                        dataType: "json",
                        data: postData,
                        success: function (data) {
                            layer.close(index);
                            if (data && data.success) {
                                layer.msg("关联成功")
                                reloadTableLsit()
                            } else {
                                layer.alert(data.msg)
                            }
                        },
                        error: function (xhr, status, error) {
                            delAjaxErrorMsg(xhr)
                        }
                    })
                } else {
                    layer.alert("不能同时选择多个实测户室和多个预测户室")
                }
            }
            , qxgl: function () {
                var fwhsData = table.checkStatus('fwhsTable').data;
                if (fwhsData.length < 1) {
                    layer.alert("请最少选择一个实测户室取消关联")
                } else {
                    var postData = {};
                    var schsHasYcfwbm = true;
                    $.each(fwhsData, function (index, data) {
                        if (!data.ycfwbm) {
                            schsHasYcfwbm = false
                            return false;
                        }
                        postData["schsIndexList[" + index + "]"] = data.fwHsIndex
                    })
                    if (!schsHasYcfwbm) {
                        layer.alert("当前选择的实测户室有未关联户室，不需要取消")
                    }else{
                        var index = layer.load(2, {shade: [0.1, '#fff']});
                        $.ajax({
                            url: "../fwhsgl/cancleycscgl",
                            dataType: "json",
                            data: postData,
                            success: function (data) {
                                layer.close(index);
                                if (data && data.success) {
                                    layer.msg("取消成功")
                                    reloadTableLsit()
                                } else {
                                    layer.alert("取消失败")
                                }
                            },
                            error: function (xhr, status, error) {
                                delAjaxErrorMsg(xhr)
                            }
                        })
                    }
                }
            }
            , ckglschs: function () {
                var fwychsData = table.checkStatus('fwychsTable').data;
                if (fwychsData.length < 1) {
                    layer.alert("请最少选择一个户室进行查看")
                } else {
                    var fwychsIndexs = "";
                    $.each(fwychsData, function (index, data) {
                        fwychsIndexs = fwychsIndexs + data.fwbm + ","
                    })
                    fwychsIndexs = fwychsIndexs.substr(0, fwychsIndexs.length - 1);
                    tableReload('fwhsTable', {
                        ycfwbm: fwychsIndexs
                    });
                }
            }
            , ckglychs: function () {
                var fwhsData = table.checkStatus('fwhsTable').data;
                if (fwhsData.length < 1) {
                    layer.alert("请最少选择一个户室进行查看")
                } else {
                    var fwhsIndexs = ""
                    $.each(fwhsData, function (index, data) {
                        fwhsIndexs = fwhsIndexs + data.ycfwbm + ","
                    })
                    fwhsIndexs = fwhsIndexs.substr(0, fwhsIndexs.length - 1)
                    tableReload('fwychsTable', {
                        fwbm: fwhsIndexs
                    });
                }
            }
            ,zzgl : function(){
                var index = layer.open({
                    type: 2,
                    title: "整幢关联",
                    maxmin: true,
                    area: ['700px', '350px'],
                    fixed: false, //不固定
                    content: '../fwhsgl/zzglview?fwDcbIndex=' + fwDcbIndex
                    , end: function (index, layero) {
                        reloadTableLsit();
                        return false;
                    }
                });
                return false;
            }
            ,qxzzgl: function(){
                var index = layer.load(2, {shade: [0.1, '#fff']});
                $.ajax({
                    url: "../fwhsgl/canclezzgl?fwDcbIndex=" + fwDcbIndex,
                    dataType: "json",
                    success: function (data) {
                        layer.close(index);
                        if (data && data.success) {
                            layer.msg(data.msg);
                            reloadTableLsit();
                        } else {
                            layer.alert("取消失败")
                        }
                    },
                    error: function (xhr, status, error) {
                        delAjaxErrorMsg(xhr)
                    }
                })
            }
        };

        $('.demoTable .layui-btn').on('click', function () {
            var type = $(this).data('type');
            active[type] ? active[type].call(this) : '';
        });

        form.on("submit(ycsearch)", function (data) {
            var postDada = data.field;
            postDada.fwbm = ''
            tableReload('fwychsTable', postDada);
            return false;
        });
        form.on("submit(scsearch)", function (data) {
            var postDada = data.field;
            postDada.ycfwbm = ''
            tableReload('fwhsTable', postDada);
            return false;
        });

    })

    function reloadTableLsit() {
        $("#ycsearch").click()
        $("#scsearch").click()
    }
</script>
</body>

</html>
