<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>户室基本信息</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form.css">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.0"></script>
    <script src="../js/fwhsbg.js?v=1.0"></script>
</head>
<body>
<div class="bdc-form-div">
    <form class="layui-form setOverflow" lay-filter="form">
        <div class="content-title layui-clear">
            <div class="title-btn-area">
            </div>
        </div>
        <div class="form-margin-area">
            <div class="basic-info">
                <!--表单块的标题-->
                <div class="layui-form-item change-textarea-margin">
                    <label class="layui-form-label change-label-width">不动产单元编号</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="bdcdyh" readonly>
                    </div>
                </div>
                <div class="layui-form-item layui-hide">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">fwhsIndex</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="fwHsIndex" id="fwHsIndex"
                                   value="${fwHsIndex!}" readonly>
                        </div>
                        <label class="layui-form-label change-label-width">fwDcbIndex</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="fwDcbIndex" id="fwDcbIndex"
                                   value="${fwDcbIndex!}" readonly>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房间号</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="fjh" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">室序号</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="sxh" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">物理层数</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="wlcs" readonly>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">定义层数</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="dycs" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">单元号</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="dyh" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋编码</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="fwbm" readonly>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">层高(m)</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="cg" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">权利ID</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="qlid" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">共有土地面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="gytdmj" readonly>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">预测建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="ycjzmj" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">实测建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="scjzmj" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">预测套内建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="yctnjzmj" readonly>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">实测套内建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="sctnjzmj" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">预测分摊建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="ycftjzmj" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">实测分摊建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="scftjzmj" readonly>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">预测地下部分建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="ycdxbfjzmj" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">实测地下部分建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="scdxbfjzmj" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">预测其他建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="ycqtjzmj" readonly>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">实测其它建筑面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="scqtjzmj" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">预测分摊系数</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="ycftxs" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">实测分摊系数</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="scftxs" readonly>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">分摊土地面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="fttdmj" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">独用土地面积(m²)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="dytdmj" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋用途</label>
                        <div class="layui-input-inline">
                            <select name="ghyt" lay-search="" lay-filter="ghyt" class="SZdFwytDO" disabled>
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">土地用途</label>
                        <div class="layui-input-inline">
                            <select name="tdyt" lay-search="" lay-filter="tdyt" class="SZdDldmDO" disabled>
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">土地使用权类型</label>
                        <div class="layui-input-inline">
                            <select name="tdsyqlx" lay-search="" lay-filter="tdsyqlx" class="SZdTdsyqlxDO" disabled>
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">起始日期</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" id="qsrq" name="qsrq" disabled>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">终止日期</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="zzrq" id="zzrq" disabled>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋类型</label>
                        <div class="layui-input-inline">
                            <select name="fwlx" lay-search="" lay-filter="fwlx" class="SZdFwlxDO" disabled>
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋性质</label>
                        <div class="layui-input-inline">
                            <select name="fwxz" lay-search="" lay-filter="fwxz" class="SZdFwxzDO" disabled>
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">交易价格(万元)</label>
                        <div class="layui-input-inline">
                            <input type="number" class="layui-input" name="jyjg" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">建成时装修程度</label>
                        <div class="layui-input-inline">
                            <select name="jczxcd" lay-search="" lay-filter="jczxcd" class="SZdJczxcdDO" disabled>
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋户型</label>
                        <div class="layui-input-inline">
                            <select name="fwhx" lay-search="" lay-filter="fwhx" class="SZdFwhxDO" disabled>
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">房屋结构</label>
                        <div class="layui-input-inline">
                            <select name="hxjg" lay-search="" lay-filter="hxjg" class="SZdHxjgDO" disabled>
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">是否附属设施</label>
                        <div class="layui-input-inline">
                            <select name="isfsss" lay-search="" lay-filter="isfsss" class="SZdBoolDO" disabled>
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">产别</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="cb" readonly>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item change-textarea-margin">
                    <label class="layui-form-label change-label-width">坐落</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="zl" readonly>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">墙体归属 东</label>
                        <div class="layui-input-inline">
                            <select name="d" lay-search="" lay-filter="d" class="SZdQtgsDO" disabled>
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">墙体归属 南</label>
                        <div class="layui-input-inline">
                            <select name="n" lay-search="" lay-filter="n" class="SZdQtgsDO" disabled>
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">墙体归属 西</label>
                        <div class="layui-input-inline">
                            <select name="x" lay-search="" lay-filter="x" class="SZdQtgsDO" disabled>
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">墙体归属 北</label>
                        <div class="layui-input-inline">
                            <select name="b" lay-search="" lay-filter="b" class="SZdQtgsDO" disabled>
                                <option value="">请选择</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item change-textarea-margin">
                    <label class="layui-form-label change-label-width">备注</label>
                    <div class="layui-input-inline">
                        <textarea class="layui-textarea change-textarea-width" name="bz" readonly></textarea>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script type="text/html" id="DmMcTpl">
    {{# layui.each(d, function(index, zdItem){ }}
    <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
    {{# }); }}
</script>
<script src="../lib/bdcui/js/form.js"></script>
<script>
    var zdList = {}
    $.ajax({
        url: "../zd/mul",
        dataType: "json",
        data: {
            zdDoNames: "SZdFwhxDO,SZdJczxcdDO,SZdFwytDO,SZdDldmDO,SZdTdsyqlxDO,SZdFwlxDO,SZdFwxzDO,SZdQtgsDO,SZdBoolDO,SZdHxjgDO"
        },
        async: false,
        success: function (data) {
            zdList = $.extend({}, data)
        }
    });
    layui.use(['form', 'jquery', 'laytpl', 'element', 'laydate'], function () {
        var form = layui.form;
        var $ = layui.jquery;
        var laydate = layui.laydate;
        var laytpl = layui.laytpl;
        var element = layui.element;

        //处理列表选择
        var tpl = $("#DmMcTpl").html();
        $.each(zdList, function (key, value) {
            laytpl(tpl).render(value, function (html) {
                $("." + key).append(html);
            });
        })

        laydate.render({
            elem: '#qsrq'
        });
        laydate.render({
            elem: '#zzrq'
        });

        //form初始化
        form.render();

        if ($("#fwHsIndex").val()) {
            loadFwhs();
        }
        //页面入口
        function loadFwhs() {
            //获取数据
            var index = layer.load(1, {shade: [0.1, '#fff']});
            var last="${last!}";
            var theLast=false;
            if(last){
                theLast=true;
            }
            $.ajax({
                url: "../fwhs/infohistoryfwhs",
                dataType: "json",
                data: {
                    fwHsIndex: $("#fwHsIndex").val(),
                    last:theLast
                },
                success: function (data) {
                    layer.closeAll();
                    form.val("form", data)
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
        }
    });




</script>
</body>

</html>
