<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>房屋面积修改</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form.css">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.0"></script>
</head>
<body>
<div class="bdc-form-div">
    <form class="layui-form setOverflow" lay-filter="form">
        <div class="content-title layui-clear">
            <div class="title-btn-area">
                <button class="layui-btn bdc-major-btn" lay-submit="" id="mjSubmit" lay-filter="mjSubmit"
                        type="button">提交
                </button>
            </div>
        </div>
        <div class="form-margin-area">
            <div class="basic-info">
                <table class="layui-table">
                    <colgroup>
                        <col width="3%">
                        <col width="27%">
                        <col width="30%">
                        <col width="40%">
                    </colgroup>
                    <thead>
                    <td colspan="4" align="right">
                        <input type="checkbox" lay-filter="updateNullOnly" lay-skin="primary" title="仅刷新空值">
                    </td>
                    </thead>
                    <thead>
                    <td class="form-tb-lable">
                        <input type="checkbox" name="allcheckbox" lay-skin="primary" lay-filter="allChoose" />
                    </td>
                    <td class="form-tb-lable">
                        <center><b>面积名称</b></center>
                    </td>
                    <td class="form-tb-lable">
                        <center><b>面积字段</b></center>
                    </td>
                    <td class="form-tb-lable">
                        <center><b>面积值</b></center>
                    </td>
                    </thead>
                    <tbody>
                    <tr>
                        <td>
                            <input type="checkbox" lay-filter="checkbox" columId="gytdmj" class="checkbox" lay-skin="primary">
                        </td>
                        <td class="form-tb-lable">共有土地面积</td>
                        <td class="form-tb-lable">GYTDMJ</td>
                        <td>
                            <input type="text" id="gytdmj" class="layui-input" placeholder="请输入共有土地面积">
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="checkbox" lay-filter="checkbox" columId="scjzmj" class="checkbox" lay-skin="primary">
                        </td>
                        <td class="form-tb-lable">实测建筑面积</td>
                        <td class="form-tb-lable">SCJZMJ</td>

                        <td>
                            <input type="text" id="scjzmj" class="layui-input" placeholder="请输入实测建筑面积">
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="checkbox" lay-filter="checkbox" columId="sctnjzmj" class="checkbox" lay-skin="primary">
                        </td>
                        <td class="form-tb-lable">实测套内建筑面积</td>
                        <td class="form-tb-lable">SCTNJZMJ</td>
                        <td>
                            <input type="text" id="sctnjzmj" class="layui-input" placeholder="请输入实测套内建筑面积">
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="checkbox" lay-filter="checkbox" columId="scftjzmj" class="checkbox" lay-skin="primary">
                        </td>
                        <td class="form-tb-lable">实测分摊建筑面积</td>
                        <td class="form-tb-lable">SCFTJZMJ</td>
                        <td>
                            <input type="text" id="scftjzmj" class="layui-input" placeholder="请输入实测分摊建筑面积">
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="checkbox" lay-filter="checkbox" columId="scdxbfjzmj" class="checkbox" lay-skin="primary">
                        </td>
                        <td class="form-tb-lable">实测地下部分建筑面积</td>
                        <td class="form-tb-lable">SCDXBFJZMJ</td>
                        <td>
                            <input type="text" id="scdxbfjzmj" class="layui-input" placeholder="请输入实测地下部分建筑面积">
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="checkbox" lay-filter="checkbox" columId="scqtjzmj" class="checkbox" lay-skin="primary">
                        </td>
                        <td class="form-tb-lable">实测其他建筑面积</td>
                        <td class="form-tb-lable">SCQTJZMJ</td>
                        <td>
                            <input type="text" id="scqtjzmj" class="layui-input" placeholder="请输入实测其他建筑面积">
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="checkbox" lay-filter="checkbox" columId="scftxs" class="checkbox" lay-skin="primary">
                        </td>
                        <td class="form-tb-lable">实测分摊系数</td>
                        <td class="form-tb-lable">SCFTXS</td>
                        <td>
                            <input type="text" id="scftxs" class="layui-input" placeholder="请输入实测分摊系数">
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="checkbox" lay-filter="checkbox" columId="ycdxbfjzmj" class="checkbox" lay-skin="primary">
                        </td>
                        <td class="form-tb-lable">预测地下部分建筑面积</td>
                        <td class="form-tb-lable">YCDXBFJZMJ</td>
                        <td>
                            <input type="text" id="ycdxbfjzmj" class="layui-input" placeholder="请输入预测地下部分建筑面积">
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="checkbox" lay-filter="checkbox" columId="ycqtjzmj" class="checkbox" lay-skin="primary">
                        </td>
                        <td class="form-tb-lable">预测其他建筑面积</td>
                        <td class="form-tb-lable">YCQTJZMJ</td>
                        <td>
                            <input type="text" id="ycqtjzmj" class="layui-input" placeholder="请输入预测其他建筑面积">
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="checkbox" lay-filter="checkbox" columId="ycftxs" class="checkbox" lay-skin="primary">
                        </td>
                        <td class="form-tb-lable">预测分摊系数</td>
                        <td class="form-tb-lable">YCFTXS</td>
                        <td>
                            <input type="text" id="ycftxs" class="layui-input" placeholder="请输入预测分摊系数">
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="checkbox" lay-filter="checkbox" columId="ycjzmj" class="checkbox" lay-skin="primary">
                        </td>
                        <td class="form-tb-lable">预测建筑面积</td>
                        <td class="form-tb-lable">YCJZMJ</td>
                        <td>
                            <input type="text" id="ycjzmj" class="layui-input" placeholder="请输入预测建筑面积">
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="checkbox" lay-filter="checkbox" columId="yctnjzmj" class="checkbox" lay-skin="primary">
                        </td>
                        <td class="form-tb-lable">预测套内建筑面积</td>
                        <td class="form-tb-lable">YCTNJZMJ</td>
                        <td>
                            <input type="text" id="yctnjzmj" class="layui-input" placeholder="请输入预测套内建筑面积">
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="checkbox" lay-filter="checkbox" columId="ycftjzmj" class="checkbox" lay-skin="primary">
                        </td>
                        <td class="form-tb-lable">预测分摊建筑面积</td>
                        <td class="form-tb-lable">YCFTJZMJ</td>
                        <td>
                            <input type="text" id="ycftjzmj" class="layui-input" placeholder="请输入预测分摊建筑面积">
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="checkbox" lay-filter="checkbox" columId="dytdmj" class="checkbox" lay-skin="primary">
                        </td>
                        <td class="form-tb-lable">独用土地面积</td>
                        <td class="form-tb-lable">DYTDMJ</td>
                        <td>
                            <input type="text" id="dytdmj" class="layui-input" placeholder="请输入独用土地面积">
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="checkbox" lay-filter="checkbox" columId="fttdmj" class="checkbox" lay-skin="primary">
                        </td>
                        <td class="form-tb-lable">分摊土地面积</td>
                        <td class="form-tb-lable">FTTDMJ</td>
                        <td>
                            <input type="text" id="fttdmj" class="layui-input" placeholder="请输入分摊土地面积">
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
    </form>
</div>
<script src="../lib/bdcui/js/form.js"></script>
<script>
    var fwhsIndexList = [];
    <#if fwHsIndexList?? && (fwHsIndexList?size>0) >
        <#list fwHsIndexList as item >
            fwhsIndexList.push('${item}');
        </#list>
    </#if>
    var checkedElem = [];
    Array.prototype.remove = function (index) {
        if (index > -1) {
            this.splice(index, 1);
        }
    };
    var updateNullOnly = false;
    layui.use(['form', 'jquery', 'laytpl', 'element', 'laydate'], function () {
        var form = layui.form;
        var $ = layui.jquery;
        var layerIndex = parent.layer.getFrameIndex(window.name);
        //form验证
        form.render();
        form.on('checkbox(checkbox)', function(data){
            if(data.elem.checked){
                checkedElem.push(data.elem);
            }else{
                var index = $.inArray(data.elem, checkedElem);
                checkedElem.remove(index);
            }
        });

        form.on('checkbox(allChoose)',function (data) {
            checkedElem = [];
            if(data.elem.checked){
                $.each($("input[lay-filter='checkbox']"),function(i){
                    $(this).next().addClass("layui-form-checked");
                    checkedElem.push($(this));
                });
            }else{
                $.each($("input[lay-filter='checkbox']"),function(i){
                    $(this).next().removeClass("layui-form-checked");
                });
            }
        })

        form.on('checkbox(updateNullOnly)', function(data){
            if(data.elem.checked){
                updateNullOnly = true;
            }else{
                updateNullOnly = false;
            }
        });

        form.on('submit(mjSubmit)', function (data) {
            if(checkedElem.length > 0){
                var itemList = [];
                for(var i = 0 ; i < checkedElem.length ; i++){
                    var name = $(checkedElem[i]).attr("columId");
                    var value = $("#"+name).val();
                    if(!value){
                        value = "null";
                    }
                    var item = name + "_" + value;
                    itemList.push(item);
                }
                var postData = {};
                postData.updateParamList = itemList;
                postData.fwHsIndexList = fwhsIndexList;
                postData.updateNullOnly = updateNullOnly;
                // loading加载
                var loadIndex = layer.load(2, {shade: [0.1, '#fff']});
                $.ajax({
                    url: "../fwhs/batchupdate",
                    dataType: "json",
                    traditional: true,
                    data: postData,
                    success: function (data) {
                        layer.close(loadIndex);
                        if(data.success){
                            parent.plgxCallBack(layerIndex);
                        }else{
                            layer.msg(data.msg);
                        }
                    },
                    error: function (xhr, status, error) {
                        delAjaxErrorMsg(xhr)
                    }
                });
            }else{
                layer.msg("请选中需要更新的面积");
            }
        });
    });
</script>
</body>

</html>
