<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>房屋户室查询列表</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.1"></script>
    <script src="../js/fwhsbg.js?v=18"></script>
    <link rel="stylesheet" href="../lib/bdcui/css/table.css?23">
    <link rel="stylesheet" href="../lib/bdcui/css/search.css">
    <script src="../js/fwhs/fwhsgl.js?v=1.1.11"></script>
</head>
<body>
<div class="bdc-table-box">
    <!--表单模块-->
    <form class="layui-form">
        <div class="layui-form-item pf-form-item">
            <div class="layui-inline">
                <label class="layui-form-label">不动产单元号</label>
                <div class="layui-input-inline">
                    <input type="text" name="bdcdyh" class="layui-input" placeholder="请输入不动产单元号">
                </div>
            </div>
            <div class="layui-inline">
                <label class="layui-form-label">坐落</label>
                <div class="layui-input-inline">
                    <input type="text" name="zl" class="layui-input" placeholder="请输入坐落">
                </div>
            </div>
            <div class="layui-inline">
                <button class="layui-btn layui-btn-normal bdc-major-btn" lay-submit="" id="query" lay-filter="query"
                        type="button">
                    查询
                </button>
                <button type="reset" class="layui-btn layui-btn-normal bdc-secondary-btn" id="reset">重置</button>
            </div>
        </div>
    </form>
    <hr class="layui-bg-gray">
    <table id="fwhsList" lay-data="{id: 'fwhsList'}" lay-filter="dataTable"></table>
</div>

<div class="layui-form-item layui-hide">
    <div id="hshb"></div>
</div>
<script type="text/html" id="toolbarDemo">
    <div class="layui-btn-container">
        <button class="layui-btn layui-btn-sm bdc-delete-btn" lay-event="delete">删除</button>
        <button class="layui-btn layui-btn-sm bdc-table-second-btn" lay-event="hshb">户室合并</button>
        <button class="layui-btn layui-btn-sm bdc-table-second-btn" lay-event="plgxsx">批量更新属性</button>
        <button class="layui-btn layui-btn-sm bdc-table-second-btn" lay-event="plgxmj">批量修改面积</button>
        <button class="layui-btn layui-btn-sm bdc-table-second-btn" lay-event="uploadHst">批量上传户室图</button>
    </div>
</script>
<script type="text/html" id="fwhsListToolBarTmpl">
    <div class="layui-btn-container">
        <span class="layui-btn layui-btn-xs bdc-major-btn" lay-event="edit">修改</span>
    <#--<span class="layui-btn layui-btn-xs bdc-delete-btn" lay-event="delete">删除</span>-->
        <a class="layui-btn layui-btn-xs bdc-secondary-btn bdc-more-btn">
            更多<i class="layui-icon layui-icon-down"></i>
        </a>
        <div class="bdc-table-btn-more">
            <a lay-event="hscf">户室拆分</a>
            <a lay-event="hsms">户室灭失</a>
            <a lay-event="hsbg">户室变更</a>
            <a lay-event="pickLjz">修改逻辑幢</a>
            <a lay-event="fwhsHistory">历史记录</a>
        </div>

    </div>
</script>
<script src="../lib/bdcui/js/table.js"></script>
<script>
    //绑定回车键
    $(document).keydown(function (event) {
        if (event.keyCode == 13) {
            $("#query").click();
        }
    });

    var zdList = {};
    var zdparam = "SZdFwlxDO,SZdFwytDO";
    $.ajax({
        url: "../zd/mul",
        data: "zdDoNames=" + zdparam,
        dataType: "json",
        async: false,
        success: function (data) {
            zdList = $.extend({}, data);
        }
    });

    layui.use(['jquery', 'layer', 'element', 'form', 'table', 'laytpl'], function () {
        var $ = layui.jquery;
        var element = layui.element;
        var form = layui.form;
        var table = layui.table;
        var laytpl = layui.laytpl;

        //提交表单
        form.on("submit(query)", function (data) {
            tableReload('fwhsList', data.field);
            return false;
        });

        var tableConfig = {
            toolbar: "#toolbarDemo"
            , url: '../fwhs/listbypage' //数据接口
            , cols: [[
                {type: 'checkbox', fixed: 'left', align: 'center', width: '50'},
                {field: 'lszd', title: '隶属宗地', width: '180'
                    ,templet: function (d) {
                        return splitDjh(d.lszd);
                    }},
                {field: 'bdcdyh', title: '不动产单元号', width: '200'
                    ,templet: function (d) {
                        return splitBdcdyh(d.bdcdyh);
                    }
                },
                {field: 'zl', title: '坐落', width: '200'},
                {field: 'fjh', title: '房间号', width: '80'},
                {field: 'dyh', title: '单元号', width: '80'},
                {field: 'wlcs', title: '物理层数', width: '100'},
                {field: 'qlr', title: '权利人', width: '100'},
                {
                    field: 'ghyt', title: '规划用途', width: '100',
                    templet: function (d) {
                        return convertZdDmToMc("SZdFwytDO", d.ghyt);
                    }
                },
                {field: 'jzmj', title: '实测建筑面积(单位:㎡)', width: '200'},
                {field: 'scftjzmj', title: '实测分摊建筑面积(单位:㎡)', width: '200'},
                {field: 'sctnjzmj', title: '实测套内建筑面积(单位:㎡)', width: '200'},
                {field: 'ycjzmj', title: '预测建筑面积(单位:㎡)', width: '200'},
                {field: 'yctnjzmj', title: '预测套内建筑面积(单位:㎡)', width: '200'},
                {field: 'ycftjzmj', title: '预测分摊建筑面积(单位:㎡)', width: '200'},
                {
                    field: 'fwlx', title: '房屋类型', width: '200',
                    templet: function (d) {
                        return convertZdDmToMc("SZdFwlxDO", d.fwlx);
                    }
                },
                {title: '操作', align: 'center', fixed: 'right', width: '130', toolbar: '#fwhsListToolBarTmpl'}
            ]]
        };

        //加载表格
        loadDataTablbeByUrl("#fwhsList", tableConfig);
        //头工具栏事件
        table.on('toolbar(dataTable)', function (obj) {
            //获取选中行状态
            var checkStatus = table.checkStatus(obj.config.id);
            //获取选中行数据,目前只为单选，不考虑多条数据情况
            var data = checkStatus.data;
            if (data && data.length > 0) {
                if (obj.event === "hshb") { // 合并户室
                    if (data.length > 1) {
                        fwhsHb(data);
                    } else {
                        layer.alert("请选择多条数据进行合并操作");
                    }
                    return false
                }
                if (obj.event == "plgxmj") { // 批量更新面积
                    plgxmjFun(data);
                    return false
                }
                if (obj.event == "plgxsx") { // 批量更新属性
                    plgxsxFun(data);
                    return false
                }
                if (obj.event == "uploadHst") { // 批量更新属性
                   hstToManyHsView(data);
                    return false
                }

                if (obj.event === "delete") { //删除
                    layer.confirm('确定删除？', function (index) {
                        deletefwhs(data);
                        return false
                    });
                }
            } else {
                if (obj.event == "uploadHst") { // 户室图上传（文件夹）
                    layer.msg("挂文件夹");
                    return false
                } else if (obj.event.indexOf("LAYTABLE") < 0) {
                    layer.msg("请选择一条数据进行操作");
                }
            }
        });
        table.on('tool(dataTable)', function (obj) {
            var data = obj.data;
            if (data && data.fw_hs_index) {
                if (obj.event === "edit") { //修改
                    fwhsUpdate(data);
                    return false;
                }
                if (obj.event === "hscf") { //户室拆分
                    layer.confirm('确定拆分？', function (index) {
                        fwhsCf(data);
                        return false
                    });
                }
                if (obj.event === "hsms") { //户室灭失
                    fwhsMs(data);
                    return false
                }
                if (obj.event === "hsbg") { //户室变更
                    fwhsBg(data);
                    return false
                }
                if (obj.event === "pickLjz") { //修改逻辑幢
                    updateLjzView(data)
                    return false
                }
                if (obj.event == "fwhsHistory") {// 历史记录
                    fwHsHistory(data)
                    return false
                }
            } else {
                layer.alert("当前数据主键缺失，请检查数据");
                return false
            }
        });
        // 批量更新户室面积
        function hstToManyHsView(data) {
            var fwHsIndexList = [];
            for (var i = 0; i < data.length; i++) {
                fwHsIndexList.push(data[i].fw_hs_index);
            }
            // 打开合并页面
            layer.open({
                type: 2,
                title: "户室图上传",
                area: ['900px', '500px'],
                content: "../hst/fwhsttomanyhsview?fwHsIndexList=" + fwHsIndexList
            });
        }
    })
    function refreshMainPage(){
        $("#query").click();
    }
</script>
</body>

</html>
