<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>户室拆分</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/search.css?v=1.0.1">
    <link rel="stylesheet" href="../css/zdtree.css?v=1.0.7">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js"></script>
</head>
<body>
<div class="content-main">
    <div class="layui-field-box">
        <form class="layui-form setOverflow" lay-filter="form">
            <div class="layui-form-item pf-form-item">
                <table class="layui-table" lay-skin="nob">
                    <colgroup>
                        <col width="10%">
                        <col width="20%">
                        <col width="10%">
                        <col width="20%">
                        <col>
                    </colgroup>
                    <tbody>
                    <tr>
                        <td class="form-tb-lable">
                            拆分方向:
                        </td>
                        <td>
                            <input type="radio" name="cffx" value="横向" title="横向" checked="">
                            <input type="radio" name="cffx" value="纵向" title="纵向">
                        </td>
                        <td class="form-tb-lable">
                            拆分户室数量:
                        </td>
                        <td>
                            <input type="number" name="cfhsnum" lay-verify="required" autocomplete="off"
                                   class="layui-input">
                        </td>
                        <td>
                            <button class="layui-btn bdc-secondary-btn" lay-submit lay-filter="cfbtn" id="cfbtn"
                                    type="button">拆分
                            </button>
                            <button class="layui-btn bdc-major-btn" lay-submit="" id="sureCfhs" lay-filter="sureCfhs"
                                    type="button">提交
                            </button>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </form>
        <div id="fjhList" style="text-align: center">

        </div>
    </div>
    <hr class="layui-bg-blue">
    <form class="layui-form setOverflow" lay-filter="form">
        <button class="layui-btn layui-hide" lay-submit lay-filter="saveFwhss" id="saveFwhss"
                type="button">提交多个房屋户室
        </button>
        <div class="layui-tab layui-tab-brief" lay-filter="tab">
            <ul class="layui-tab-title layui-hide" id="fjhLi">

            </ul>
            <div class="layui-tab-content" id="fjhTab">

            </div>

        </div>
    </form>
</div>
<script type="text/html" id="cfHsFjhTpl">
    {{# layui.each(d, function(index, item){ }}
    <a class="layui-btn layui-btn-primary" href="javascript:;" onclick="reloadNowFwHsInfo({{item.fjh}},{{index}})">房间号:{{item.fjh}}</a>
    {{# }); }}
</script>
<script type="text/html" id="fjhLiTpl">
    <li lay-id='{{d.fjh}}' id='{{d.fjh}}'>{{d.fjh}}</li>
</script>
<script type="text/html" id="fjhTabTpl">
    <div class="layui-tab-item" id="tab{{d.fjh}}">
        <div class="basic-info">
            <!--表单块的标题-->
            <div class="layui-form-item layui-hide">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">fwDcbIndex</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="fwHsList[{{d.length}}].fwDcbIndex" id="fwDcbIndex"
                               value="{{ d.fwhsInfo.fwDcbIndex || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">房间号</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="fwHsList[{{d.length}}].fjh" value="{{d.fjh}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">室序号</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].sxh"
                               value="{{ d.fwhsInfo.sxh || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">物理层数</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].wlcs"
                               value="{{ d.fwhsInfo.wlcs || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">定义层数</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="fwHsList[{{d.length}}].dycs"
                               value="{{ d.fwhsInfo.dycs || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">单元号</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="fwHsList[{{d.length}}].dyh"
                               value="{{ d.fwhsInfo.dyh || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">产别</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="fwHsList[{{d.length}}].cb"
                               value="{{ d.fwhsInfo.cb || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">层高(m)</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="fwHsList[{{d.length}}].cg"
                               value="{{ d.fwhsInfo.cg || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">权利ID</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="fwHsList[{{d.length}}].qlid"
                               value="{{ d.fwhsInfo.qlid || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">共有土地面积(m²)</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].gytdmj"
                               value="{{ d.fwhsInfo.gytdmj || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">预测建筑面积(m²)</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].ycjzmj"
                               value="{{ d.fwhsInfo.ycjzmj || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">实测建筑面积(m²)</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].scjzmj"
                               value="{{ d.fwhsInfo.scjzmj || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">预测套内建筑面积(m²)</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].yctnjzmj"
                               value="{{ d.fwhsInfo.yctnjzmj || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">实测套内建筑面积(m²)</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].sctnjzmj"
                               value="{{ d.fwhsInfo.sctnjzmj || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">预测分摊建筑面积(m²)</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].ycftjzmj"
                               value="{{ d.fwhsInfo.ycftjzmj || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">实测分摊建筑面积(m²)</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].scftjzmj"
                               value="{{ d.fwhsInfo.scftjzmj || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">预测地下部分建筑面积(m²)</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].ycdxbfjzmj"
                               value="{{ d.fwhsInfo.ycdxbfjzmj || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">实测地下部分建筑面积(m²)</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].scdxbfjzmj"
                               value="{{ d.fwhsInfo.scdxbfjzmj || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">预测其他建筑面积(m²)</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].ycqtjzmj"
                               value="{{ d.fwhsInfo.ycqtjzmj || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">实测其它建筑面积(m²)</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].scqtjzmj"
                               value="{{ d.fwhsInfo.scqtjzmj || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">预测分摊系数</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].ycftxs"
                               value="{{ d.fwhsInfo.ycftxs || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">实测分摊系数</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].scftxs"
                               value="{{ d.fwhsInfo.scftxs || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">分摊土地面积(m²)</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].fttdmj"
                               value="{{ d.fwhsInfo.fttdmj || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">独用土地面积(m²)</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].dytdmj"
                               value="{{ d.fwhsInfo.dytdmj || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">房屋用途</label>
                    <div class="layui-input-inline">
                        <select name="fwHsList[{{d.length}}].ghyt" lay-search="" lay-filter="ghyt" class="SZdFwytDO">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdFwytDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==d.fwhsInfo.ghyt){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">土地用途</label>
                    <div class="layui-input-inline">
                        <select name="fwHsList[{{d.length}}].tdyt" lay-search="" lay-filter="tdyt" class="SZdDldmDO">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdDldmDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==d.fwhsInfo.tdyt){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">土地使用权类型</label>
                    <div class="layui-input-inline">
                        <select name="fwHsList[{{d.length}}].tdsyqlx" lay-search="" lay-filter="tdsyqlx"
                                class="SZdTdsyqlxDO">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdTdsyqlxDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==d.fwhsInfo.tdsyqlx){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">起始日期</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" id="qsrq{{d.length}}" name="fwHsList[{{d.length}}].qsrq"
                               value="{{ d.fwhsInfo.qsrq || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">终止日期</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="fwHsList[{{d.length}}].zzrq" id="zzrq{{d.length}}"
                               class="zzrq"
                               value="{{ d.fwhsInfo.zzrq || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">房屋类型</label>
                    <div class="layui-input-inline">
                        <select name="fwHsList[{{d.length}}].fwlx" lay-search="" lay-filter="fwlx" class="SZdFwlxDO">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdFwlxDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==d.fwhsInfo.fwlx){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">房屋性质</label>
                    <div class="layui-input-inline">
                        <select name="fwHsList[{{d.length}}].fwxz" lay-search="" lay-filter="fwxz" class="SZdFwxzDO">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdFwxzDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==d.fwhsInfo.fwxz){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">交易价格(万元)</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].jyjg"
                               value="{{ d.fwhsInfo.jyjg || ''}}">
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">建成时装修程度</label>
                    <div class="layui-input-inline">
                        <select name="fwHsList[{{d.length}}].jczxcd" lay-search="" lay-filter="jczxcd"
                                class="SZdJczxcdDO">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdJczxcdDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==d.fwhsInfo.jczxcd){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">房屋户型</label>
                    <div class="layui-input-inline">
                        <select name="fwHsList[{{d.length}}].fwhx" lay-search="" lay-filter="fwhx" class="SZdFwhxDO">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdFwhxDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==d.fwhsInfo.fwhx){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">房屋结构</label>
                    <div class="layui-input-inline">
                        <select name="fwHsList[{{d.length}}].hxjg" lay-search="" lay-filter="hxjg" class="SZdHxjgDO">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdHxjgDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==d.fwhsInfo.hxjg){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">是否附属设施</label>
                    <div class="layui-input-inline">
                        <select name="fwHsList[{{d.length}}].isfsss" lay-search="" lay-filter="isfsss"
                                class="SZdBoolDO">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdBoolDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==d.fwhsInfo.isfsss){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">墙体归属 东</label>
                    <div class="layui-input-inline">
                        <select name="fwHsList[{{d.length}}].d" lay-search="" lay-filter="d" class="SZdQtgsDO">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdQtgsDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==d.fwhsInfo.d){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">墙体归属 南</label>
                    <div class="layui-input-inline">
                        <select name="fwHsList[{{d.length}}].n" lay-search="" lay-filter="n" class="SZdQtgsDO">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdQtgsDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==d.fwhsInfo.n){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">墙体归属 西</label>
                    <div class="layui-input-inline">
                        <select name="fwHsList[{{d.length}}].x" lay-search="" lay-filter="x" class="SZdQtgsDO">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdQtgsDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==d.fwhsInfo.x){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">墙体归属 北</label>
                    <div class="layui-input-inline">
                        <select name="fwHsList[{{d.length}}].b" lay-search="" lay-filter="b" class="SZdQtgsDO">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdQtgsDO, function(index, zdItem){ }}
                            {{# if(zdItem.DM==d.fwhsInfo.b){ }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">合并方向</label>
                    <div class="layui-input-inline">
                        <select name="fwHsList[{{d.length}}].hbfx" lay-search="" lay-filter="hbfx" class="SZdHbfxDO">
                            <option value="">请选择</option>
                            {{# layui.each(d.zdList.SZdHbfxDO, function(index, zdItem){ }}
                            {{# if( $(".layui-form-radioed").prev().val()=="横向" && zdItem.DM=="2"){ }}
                            {{# console.info("-----横向2") }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else if($(".layui-form-radioed").prev().val()=="纵向" && zdItem.DM=="3"){ }}
                            {{# console.info("-----纵向3") }}
                            <option value="{{zdItem.DM}}" selected>{{zdItem.MC}}</option>
                            {{# }else{ }}
                            <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
                            {{# } }}
                            {{# }); }}
                        </select>
                    </div>
                </div>
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">合并户数</label>
                    <div class="layui-input-inline">
                        <input type="number" class="layui-input" name="fwHsList[{{d.length}}].hbhs"
                               value="{{ d.fwhsInfo.hbhs || ''}}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item" style="margin-left: 10px;margin-top: 8px;margin-bottom: 8px">
                <label class="layui-form-label change-label-width">坐落</label>
                <div class="layui-input-block" style="width: 85%">
                    <input type="text" class="layui-input" name="fwHsList[{{d.length}}].zl"
                           value="{{ d.fwhsInfo.zl || ''}}">
                </div>
            </div>
            <div class="layui-form-item" style="margin-left: 10px;margin-top: 8px;margin-bottom: 8px">
                <label class="layui-form-label change-label-width">备注</label>
                <div class="layui-input-block" style="width: 85%">
                    <textarea class="layui-textarea" name="fwHsList[{{d.length}}].bz"
                              value="{{ d.fwhsInfo.bz || ''}}"></textarea>
                </div>
            </div>
        </div>
    </div>
</script>
<script>
    var fwHsIndex = "${fwHsIndex!}";
    var beforeFwhs = {}
    var zdList = {}
    $.ajax({
        url: "../fwhs/infofwhs",
        dataType: "json",
        async: false,
        data: {
            fwHsIndex: fwHsIndex
        },
        success: function (data) {
            beforeFwhs = $.extend({}, data)
        }
    });
    $.ajax({
        url: "../zd/mul",
        dataType: "json",
        data: {
            zdDoNames: "SZdFwhxDO,SZdJczxcdDO,SZdFwytDO,SZdDldmDO,SZdTdsyqlxDO,SZdFwlxDO,SZdFwxzDO,SZdQtgsDO,SZdBoolDO,SZdHxjgDO,SZdHbfxDO"
        },
        async: false,
        success: function (data) {
            zdList = $.extend({}, data)
        }
    });
    layui.use(['jquery', 'element', 'laytpl', 'form', 'laydate'], function () {
        var $ = layui.jquery;
        var element = layui.element;
        var laytpl = layui.laytpl;
        var form = layui.form;
        var laydate = layui.laydate;
        form.render();

        $("#sureCfhs").click(function () {
            $("#saveFwhss").click();
        })

        form.on('submit(cfbtn)', function (data) {
            if (beforeFwhs && beforeFwhs.fjh) {
                var fjhs = []
                var cfhsnum = data.field.cfhsnum;
                if (data.field.cffx == "横向") {
                    for (var i = 0; i < cfhsnum; i++) {
                        fjhs.push({fjh: parseInt(beforeFwhs.fjh) + i})
                    }
                } else if (data.field.cffx == "纵向") {
                    for (var i = 0; i < cfhsnum; i++) {
                        if (beforeFwhs.wlcs >= (parseInt(beforeFwhs.fjh.substring(0, beforeFwhs.fjh.length - 2)) + i)) {
                            fjhs.push({fjh: parseInt(beforeFwhs.fjh) + i * 100})
                        } else {
                            layer.alert("当前拆分超过了当前户室的最大物理层数，不能拆分")
                        }
                    }
                }
                $("#fjhLi").html("");
                $("#fjhTab").html("");
                var tpl = $("#cfHsFjhTpl").html();
                laytpl(tpl).render(fjhs, function (html) {
                    $("#fjhList").html(html);
                });
                $.each($("#fjhList a"), function (index, data) {
                    $(this).click();
                })
            } else {
                layer.alert("当前房屋户室信息没有房间号，请检查")
            }
            return false;
        });

        form.on('submit(saveFwhss)', function (data) {
            if (beforeFwhs) {
                var postData = data.field;
                postData.bgbh = "${bgbh!}"
                postData["yFwHsIndexList[0]"] = fwHsIndex
                // loading加载
                var loadIndex = layer.load(2, {shade: [0.1, '#fff']});
                $.ajax({
                    url: "../fwhsbg/cf",
                    dataType: "json",
                    data: postData,
                    success: function (data) {
                        layer.close(loadIndex);
                        if (data && data.success) {
                            layer.msg(data.msg);
                            parent.layer.closeAll();
                        } else {
                            layer.alert("拆分失败")
                        }
                    },
                    error: function (xhr, status, error) {
                        delAjaxErrorMsg(xhr)
                    }
                });
            } else {
                layer.alert("当前房屋户室信息没有房间号，请检查")
            }
            return false;
        });
    })

    function reloadNowFwHsInfo(fjh, index) {
        layui.use(['jquery', 'element', 'laytpl', 'form', 'laydate'], function () {
            var $ = layui.jquery;
            var element = layui.element;
            var laytpl = layui.laytpl;
            var form = layui.form;
            var laydate = layui.laydate;
            if ($("#" + fjh).length < 1) {
                var tplData = {
                    fjh: fjh,
                    length: index,
                    fwhsInfo: beforeFwhs,
                    zdList: zdList
                }
                var fjhLiTpl = $("#fjhLiTpl").html();
                laytpl(fjhLiTpl).render(tplData, function (html) {
                    $("#fjhLi").append(html);
                });
                var fjhTabTpl = $("#fjhTabTpl").html();
                laytpl(fjhTabTpl).render(tplData, function (html) {
                    $("#fjhTab").append(html);
                });
                laydate.render({
                    elem: '#qsrq' + index
                });
                laydate.render({
                    elem: '#zzrq' + index
                });
                form.render()
            }
            element.tabChange('tab', fjh);
        });
    }
</script>
</body>

</html>
