<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>户室历史变更记录</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form-tab.css"/>
    <link rel="stylesheet" href="../lib/bdcui/css/form.css?v=1.0.3">
    <link rel="stylesheet" href="../lib/bdcui/css/search.css"/>
    <link rel="stylesheet" href="../lib/bdcui/css/table.css"/>
    <link rel="stylesheet" href="../css/upload.css?v=1.13">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.1"></script>
    <script src="../lib/bdcui/js/form.js?v=1.0"></script>
    <script src="../lib/bdcui/js/table.js"></script>
    <script src="../js/fwhsBgHistory.js?v=1.112"></script>
    <script type="text/javascript" src="http://echarts.baidu.com/dist/echarts.min.js"></script>
</head>
<body>

<div class="bdc-form-div">
    <form class="layui-form setOverflow" lay-filter="form">
        <div class="content-title layui-clear">
            <p>户室变更历史关系</p>
            <div class="title-btn-area">
                <button class="layui-btn bdc-major-btn" id="revokeBg" type="button">撤销变更</button>
            </div>
        </div>
        <div id="relationMap"></div>
    </form>

</div>


<script type="text/javascript">
    //获取数据
    var _data = [];
    var fwHsIndex = "${fwHsIndex!}";
    var layerIndex = parent.layer.getFrameIndex(window.name);

    $.ajax({
        url: "../fwhs/hsbghistory",
        dataType: "json",
        data: {
            fwHsIndex: fwHsIndex
        },
        async: false,
        success: function (data) {
            _data = data
        }
    });

    //配置项
    reloadTable(_data);


    $("#revokeBg").click(function () {
        var length = _data.length;
        var bgDate = _data[length - 1]
        var bgbh = bgDate[0].bgbh;
        var bglx = bgDate[0].bglx;
        var fjh = bgDate[0].fjh;
        var yfwHsIndex = bgDate[0].yfwHsIndex;

        if (bgbh) {
            layer.open({
                content: '是否确定撤销本房屋最后一次变更？'
                , btn: ['确定', '取消']
                , yes: function (index, layero) {
                    var loadIndex = layer.load(2, {shade: [0.1, '#fff']});
                    $.ajax({
                        url: "../fwhsbg/revokebg",
                        dataType: "json",
                        traditional: true,
                        data: {
                            bglx: bglx,
                            bgbh: bgbh,
                            fjh: fjh,
                            yfwHsIndexList: yfwHsIndex
                        },
                        success: function (data) {
                            layer.closeAll();
                            var formLayer = layer;
                            if (parent.layer) {
                                formLayer = parent.layer
                            }
                            var index = parent.layer.getFrameIndex(window.name);
                            if (data.success && data.fwHsIndex) {
                                $.ajax({
                                    url: "../fwhs/hsbghistory",
                                    dataType: "json",
                                    data: {
                                        fwHsIndex: data.fwHsIndex
                                    },
                                    async: false,
                                    success: function (newdata) {
                                        formLayer.msg("撤销成功");
                                        if (newdata && newdata.length > 1) {
                                            _data = newdata
                                            reloadTable(_data);
                                        } else {
                                            parent.layer.close(index);
                                        }
                                    }
                                });
                            }
                        },
                        error: function (xhr, status, error) {
                            delAjaxErrorMsg(xhr)
                        }
                    });
                }
            });
        }
    })

</script>
</body>