<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>户室信息</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form-tab.css"/>
    <link rel="stylesheet" href="../lib/bdcui/css/form.css?v=1.0.3">
    <link rel="stylesheet" href="../lib/bdcui/css/search.css"/>
    <link rel="stylesheet" href="../lib/bdcui/css/table.css"/>
    <link rel="stylesheet" href="../css/upload.css?v=1.13">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js?v=1.1"></script>
    <script src="../lib/bdcui/js/form.js?v=1.0"></script>
    <script src="../lib/bdcui/js/table.js"></script>
    <script src="../js/fwhsbg.js?v=1.112"></script>
</head>
<body>
<div class="bdc-form-div">
    <form class="layui-form setOverflow" lay-filter="form">
        <div class="content-title layui-clear">
            <div class="title-btn-area">
                <button class="layui-btn bdc-major-btn" lay-submit="" id="saveForm" lay-filter="saveForm">提交</button>
            </div>
        </div>
        <div class="layui-tab" lay-filter="tabFilter">
            <div class="layui-tab-content">
                <div class="layui-tab-item layui-show">
                    <div class="basic-info">
                        <!--表单块的标题-->
                        <div class="layui-form-item change-textarea-margin layui-hide">
                            <label class="layui-form-label change-label-width">不动产单元编号</label>
                            <div class="layui-input-inline">
                                <input type="text" class="layui-input" name="bdcdyh" id="bdcdyh" disabled>
                            </div>
                        </div>
                        <div class="layui-form-item layui-hide">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">fwhsIndex</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="fwHsIndex" id="fwHsIndex"
                                           value="${fwHsIndex!}">
                                </div>
                            </div>
                            <label class="layui-form-label change-label-width">fwDcbIndex</label>
                            <div class="layui-input-inline">
                                <input type="text" class="layui-input" name="fwDcbIndex" id="fwDcbIndex"
                                       value="${fwDcbIndex!}">
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房间号</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="fjh">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">室序号</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="sxh">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">物理层数</label>
                                <div class="layui-input-inline">
                                    <input type="number" class="layui-input" name="wlcs">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">定义层数</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="dycs">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">单元号</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="dyh">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋编码</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="fwbm">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">层高(m)</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="cg">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">权利ID</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="qlid">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">共有土地面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="text" lay-verify="double" class="layui-input" name="gytdmj">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">预测建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="text" lay-verify="double" class="layui-input" name="ycjzmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">实测建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="text" lay-verify="double" class="layui-input" name="scjzmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">预测套内建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="text" lay-verify="double" class="layui-input" name="yctnjzmj">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">实测套内建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="text" lay-verify="double" class="layui-input" name="sctnjzmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">预测分摊建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="text" lay-verify="double" class="layui-input" name="ycftjzmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">实测分摊建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="text" lay-verify="double" class="layui-input" name="scftjzmj">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">预测地下部分建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="text" lay-verify="double" class="layui-input" name="ycdxbfjzmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">实测地下部分建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="text" lay-verify="double" class="layui-input" name="scdxbfjzmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">预测其他建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="text" lay-verify="double" class="layui-input" name="ycqtjzmj">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">实测其它建筑面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="text" lay-verify="double" class="layui-input" name="scqtjzmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">预测分摊系数</label>
                                <div class="layui-input-inline">
                                    <input type="text" lay-verify="double" class="layui-input" name="ycftxs">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">实测分摊系数</label>
                                <div class="layui-input-inline">
                                    <input type="text" lay-verify="double" class="layui-input" name="scftxs">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">分摊土地面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="text" lay-verify="double" class="layui-input" name="fttdmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">独用土地面积(m²)</label>
                                <div class="layui-input-inline">
                                    <input type="text" lay-verify="double" class="layui-input" name="dytdmj">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋用途</label>
                                <div class="layui-input-inline">
                                    <select name="ghyt" lay-search="" lay-filter="ghyt" class="SZdFwytDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">土地用途</label>
                                <div class="layui-input-inline">
                                    <select name="tdyt" lay-search="" lay-filter="tdyt" class="SZdDldmDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">土地使用权类型</label>
                                <div class="layui-input-inline">
                                    <select name="tdsyqlx" lay-search="" lay-filter="tdsyqlx" class="SZdTdsyqlxDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">起始日期</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" id="qsrq" name="qsrq">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">终止日期</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="zzrq" id="zzrq">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋类型</label>
                                <div class="layui-input-inline">
                                    <select name="fwlx" lay-search="" lay-filter="fwlx" class="SZdFwlxDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋性质</label>
                                <div class="layui-input-inline">
                                    <select name="fwxz" lay-search="" lay-filter="fwxz" class="SZdFwxzDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">交易价格(万元)</label>
                                <div class="layui-input-inline">
                                    <input type="text" lay-verify="double" class="layui-input" name="jyjg">
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">建成时装修程度</label>
                                <div class="layui-input-inline">
                                    <select name="jczxcd" lay-search="" lay-filter="jczxcd" class="SZdJczxcdDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋户型</label>
                                <div class="layui-input-inline">
                                    <select name="fwhx" lay-search="" lay-filter="fwhx" class="SZdFwhxDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">房屋结构</label>
                                <div class="layui-input-inline">
                                    <select name="hxjg" lay-search="" lay-filter="hxjg" class="SZdHxjgDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">是否附属设施</label>
                                <div class="layui-input-inline">
                                    <select name="isfsss" lay-search="" lay-filter="isfsss" class="SZdBoolDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">产别</label>
                                <div class="layui-input-inline">
                                    <input type="text" class="layui-input" name="cb">
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">坐落</label>
                            <div class="layui-input-inline">
                                <input type="text" class="layui-input" name="zl">
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">墙体归属 东</label>
                                <div class="layui-input-inline">
                                    <select name="d" lay-search="" lay-filter="d" class="SZdQtgsDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">墙体归属 南</label>
                                <div class="layui-input-inline">
                                    <select name="n" lay-search="" lay-filter="n" class="SZdQtgsDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">墙体归属 西</label>
                                <div class="layui-input-inline">
                                    <select name="x" lay-search="" lay-filter="x" class="SZdQtgsDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item">
                            <div class="layui-inline margin-top-ipt">
                                <label class="layui-form-label change-label-width">墙体归属 北</label>
                                <div class="layui-input-inline">
                                    <select name="b" lay-search="" lay-filter="b" class="SZdQtgsDO">
                                        <option value="">请选择</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="layui-form-item change-textarea-margin">
                            <label class="layui-form-label change-label-width">备注</label>
                            <div class="layui-input-inline">
                                <textarea class="layui-textarea change-textarea-width" name="bz"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script type="text/html" id="DmMcTpl">
    {{# layui.each(d, function(index, zdItem){ }}
    <option value="{{zdItem.DM}}">{{zdItem.MC}}</option>
    {{# }); }}
</script>
<script src="../lib/bdcui/js/form.js"></script>
<script>
    var fwHsIndex = "${fwHsIndex!}";
    var bgbh = "${bgbh!}";
    var zdList = {};
    $.ajax({
        url: "../zd/mul",
        dataType: "json",
        data: {
            zdDoNames: "SZdFwhxDO,SZdJczxcdDO,SZdFwytDO,SZdDldmDO,SZdTdsyqlxDO,SZdFwlxDO,SZdFwxzDO,SZdQtgsDO,SZdBoolDO,SZdHxjgDO,SZdGyfsDO,SZdQlrxzDO,SZdQlrxbDO,SZdZjllxDO"
        },
        async: false,
        success: function (data) {
            zdList = $.extend({}, data)
        }
    });
    layui.use(['form', 'jquery', 'laytpl', 'element', 'laydate', 'table', 'upload'], function () {
        var form = layui.form;
        var $ = layui.jquery;
        var laydate = layui.laydate;
        var laytpl = layui.laytpl;
        var element = layui.element;
        var table = layui.table;
        var upload = layui.upload;
        laydate.render({
            elem: '#qsrq'
        });
        laydate.render({
            elem: '#zzrq'
        });
        laydate.render({
            elem: '#dcsj'
            , type: 'datetime'
        });
        //处理列表选择
        var tpl = $("#DmMcTpl").html();
        $.each(zdList, function (key, value) {
            laytpl(tpl).render(value, function (html) {
                $("." + key).append(html);
            });
        });
        //form验证
        form.verify({
            double: function(value){
                if(value){
                    var doubleReg = /^[0-9]+(.[0-9]{1,3})?$/;
                    var intReg = /^[1-9]\d*$/;
                    var r = doubleReg.test(value);
                    var i = intReg.test(value);
                    if(!r && !i){
                        return '输入正确数值';
                    }
                }
            }
        });
        form.render();
        if (fwHsIndex) {
            loadFwhs(fwHsIndex);
        }
        //提交表单
        form.on("submit(saveForm)", function (data) {
            fwhsBgMain(data, bgbh);
            return false;
        })

        function writeFwhsxx(data) {
            form.val("form", data);
            if(data.fwDcbIndex){
                //根据逻辑幢类型判断是否显示不动产单元号
                $.ajax({
                    url: "../ljz/infoljz",
                    dataType: "json",
                    data: {
                        fwDcbIndex: data.fwDcbIndex
                    },
                    success: function (data) {
                        if (data && data.bdcdyfwlx) {
                            bdcdyfwlx = data.bdcdyfwlx;
                            if (data.bdcdyfwlx == "4") {
                                $("input[name='bdcdyh']").parent().parent().removeClass("layui-hide")
                            }
                        }
                    }
                });
            }
        }
        //页面入口
        function loadFwhs(fwHsIndex) {
            //获取数据
            var index = layer.load(1, {shade: [0.1, '#fff']});
            $.ajax({
                url: "../fwhs/infofwhs",
                dataType: "json",
                data: {
                    fwHsIndex: fwHsIndex
                },
                success: function (data) {
                    layer.closeAll();
                    //处理查询出来的数据
                    writeFwhsxx(data)
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
        }
    });
</script>
</body>

</html>
