<!DOCTYPE html>
<html lang="zh-cn">
<head>
    <meta charset="utf-8">
    <title>宗地信息</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form.css">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js"></script>
</head>
<body>
<div class="bdc-form-div" style="background-color: #ffffff">
    <form class="layui-form" lay-filter="form">
        <div class="form-margin-area">
            <div class="basic-info">
                <div class="layui-form-item">
                    <div lay-filter="test" id="qlrList">
                    </div>
                    <div class="layui-inline bdc-two-column">
                        <label class="layui-form-label change-label-width">国民经济行业分类代码</label>
                        <div class="layui-input-inline change-input-width">
                            <input type="text" name="gmjjhyfldm" class="layui-input" readonly/>
                        </div>
                    </div>
                    <div class="layui-inline">
                        <label class="layui-form-label change-label-width">
                            预编宗地代码
                        </label>
                        <div class="layui-input-inline">
                            <input type="text" name="ybdjh" class="layui-input" readonly/>
                        </div>
                    </div>
                    <div class="layui-inline">
                        <label class="layui-form-label change-label-width">
                            宗地代码
                        </label>
                        <div class="layui-input-inline">
                            <input type="text" name="djh" class="layui-input" readonly/>
                        </div>
                    </div>
                    <div class="layui-inline">
                        <label class="layui-form-label change-label-width">
                            比例尺
                        </label>
                        <div class="layui-input-inline">
                            <input type="text" name="blc" class="layui-input" readonly/>
                        </div>
                    </div>
                    <div class="layui-inline">
                        <label class="layui-form-label change-label-width">
                            图幅号
                        </label>
                        <div class="layui-input-inline">
                            <input type="text" name="sztfh" class="layui-input" readonly/>
                        </div>
                    </div>
                    <div class="layui-form-item change-textarea-margin">
                        <label class="layui-form-label change-label-width">宗地四至</label>
                        <div class="layui-input-inline">
                        <textarea class="layui-textarea change-textarea-width" readonly autocomplete="off"
                                  name="zdsz" readonly></textarea>
                        </div>
                    </div>
                    <div class="layui-inline">
                        <label class="layui-form-label change-label-width">
                            批准用途
                        </label>
                        <div class="layui-input-inline">
                            <input type="text" name="pzyt" class="layui-input" readonly/>
                        </div>
                    </div>
                    <div class="layui-inline">
                        <label class="layui-form-label change-label-width">
                            地类编码
                        </label>
                        <div class="layui-input-inline">
                            <input type="text" name="dlbm" class="layui-input" readonly/>
                        </div>
                    </div>
                    <div class="layui-inline">
                        <label class="layui-form-label change-label-width">
                            实际用途
                        </label>
                        <div class="layui-input-inline">
                            <input type="text" name="sjyt" class="layui-input" readonly/>
                        </div>
                    </div>
                    <div class="layui-inline">
                        <label class="layui-form-label change-label-width">
                            地类编码
                        </label>
                        <div class="layui-input-inline">
                            <input type="text" name="dlbm" class="layui-input" readonly/>
                        </div>
                    </div>
                    <div class="layui-inline">
                        <label class="layui-form-label change-label-width">
                            批准面积
                        </label>
                        <div class="layui-input-inline">
                            <input type="text" name="pzmj" class="layui-input" readonly/>
                        </div>
                    </div>
                    <div class="layui-inline">
                        <label class="layui-form-label change-label-width">
                            宗地面积
                        </label>
                        <div class="layui-input-inline">
                            <input type="text" name="zdmj" class="layui-input" readonly/>
                        </div>
                    </div>
                    <div class="layui-inline">
                        <label class="layui-form-label change-label-width">
                            建筑占地面积
                        </label>
                        <div class="layui-input-inline">
                            <input type="text" name="zdzmj" class="layui-input" readonly/>
                        </div>
                    </div>
                    <div class="layui-inline">
                        <label class="layui-form-label change-label-width">
                            建筑面积
                        </label>
                        <div class="layui-input-inline">
                            <input type="text" name="jzzmj" class="layui-input" readonly/>
                        </div>
                    </div>
                    <div class="layui-inline bdc-two-column">
                        <label class="layui-form-label change-label-width">共有共用权利人</label>
                        <div class="layui-input-inline change-input-width">
                            <input type="text" name="jzwsuqgyqlr" class="layui-input" readonly/>
                        </div>
                    </div>
                    <div class="layui-inline bdc-two-column">
                        <label class="layui-form-label change-label-width">说明</label>
                        <div class="layui-input-inline change-input-width">
                            <input type="text" name="qtsm" class="layui-input" readonly/>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script type="text/html" id="qlrTpl">
    {{# layui.each(d.data, function(index, item){ }}
    {{# var length=d.start+index }}
    <div class="layui-form-item">
        <div class="layui-inline">
            <label class="layui-form-label change-label-width">
                土地权利人
            </label>
            <div class="layui-input-inline">
                <input type="text" readonly name="qlrList[{{length}}].qlrmc" class="layui-input"
                       value="{{ item.qlrmc || ''}}"/>
            </div>
        </div>
        <div class="layui-inline">
            <label class="layui-form-label change-label-width">
                单位性质
            </label>
            <div class="layui-input-inline">
                <input type="text" readonly name="qlrList[{{length}}].dwxz" class="layui-input"
                       value="{{ item.dwxz || ''}}"/>
            </div>
        </div>
        <div class="layui-inline">
            <label class="layui-form-label change-label-width">
                证件类型
            </label>
            <div class="layui-input-inline">
                <input type="text" readonly name="qlrList[{{length}}].qlrzjlx" class="layui-input"
                       value="{{ item.qlrzjlx || ''}}"/>
            </div>
        </div>
    </div>
    <div class="layui-form-item">
        <div class="layui-inline">
            <label class="layui-form-label change-label-width">
                证件编号
            </label>
            <div class="layui-input-inline">
                <input type="text" readonly name="qlrList[{{length}}].qlrzjh" class="layui-input"
                       value="{{ item.qlrzjh || ''}}"/>
            </div>
        </div>

        <div class="layui-inline bdc-two-column">
            <label class="layui-form-label change-label-width">通讯地址</label>
            <div class="layui-input-inline change-input-width">
                <input type="text" readonly name="qlrList[{{length}}].txdz" class="layui-input"
                       value="{{ item.txdz || ''}}"/>
            </div>
        </div>
    </div>
    <div class="layui-form-item">
        <div class="layui-inline">
            <label class="layui-form-label change-label-width">
                法定代表人或负责人姓名
            </label>
            <div class="layui-input-inline">
                <input type="text" readonly name="qlrList[{{length}}].frdbxm" class="layui-input"
                       value="{{ item.frdbxm || ''}}"/>
            </div>
        </div>
        <div class="layui-inline">
            <label class="layui-form-label change-label-width">
                电话
            </label>
            <div class="layui-input-inline">
                <input type="text" readonly name="qlrList[{{length}}].frdbdhhm" class="layui-input"
                       value="{{ item.frdbdhhm || ''}}"/>
            </div>
        </div>
        <div class="layui-inline">
            <label class="layui-form-label change-label-width">
                证件类型
            </label>
            <div class="layui-input-inline">
                <input type="text" readonly name="qlrList[{{length}}].frdbzjlx" class="layui-input"
                       value="{{ item.frdbzjlx || ''}}"/>
            </div>
        </div>
    </div>
    <div class="layui-form-item">
        <div class="layui-inline">
            <label class="layui-form-label change-label-width">
                证件编号
            </label>
            <div class="layui-input-inline">
                <input type="text" readonly name="qlrList[{{length}}].frdbzjh" class="layui-input"
                       value="{{ item.frdbzjh || ''}}"/>
            </div>
        </div>
        <div class="layui-inline">
            <label class="layui-form-label change-label-width">
                代理人姓名
            </label>
            <div class="layui-input-inline">
                <input type="text" readonly name="qlrList[{{length}}].dlrxm" class="layui-input"
                       value="{{ item.dlrxm || ''}}"/>
            </div>
        </div>
        <div class="layui-inline">
            <label class="layui-form-label change-label-width">
                电话
            </label>
            <div class="layui-input-inline">
                <input type="text" readonly name="qlrList[{{length}}].dlrdhhm" class="layui-input"
                       value="{{ item.dlrdhhm || ''}}"/>
            </div>
        </div>
    </div>
    <div class="layui-form-item">
        <div class="layui-inline">
            <label class="layui-form-label change-label-width">
                证件类型
            </label>
            <div class="layui-input-inline">
                <input type="text" readonly name="qlrList[{{length}}].dlrzjlx" class="layui-input"
                       value="{{ item.dlrzjlx || ''}}"/>
            </div>
        </div>
        <div class="layui-inline">
            <label class="layui-form-label change-label-width">
                证件编号
            </label>
            <div class="layui-input-inline">
                <input type="text" readonly name="qlrList[{{length}}].dlrzjh" class="layui-input"
                       value="{{ item.dlrzjh || ''}}"/>
            </div>
        </div>
        <hr class="layui-bg-gray">
    </div>
    {{# }); }}
</script>
<script>
    var zdList = {}
    var bdcdyh = "${bdcdyh!}"
    $.ajax({
        url: "../zd/mul",
        dataType: "json",
        data: {
            zdDoNames: "SZdFwytDO,SZdQtgsDO,SZdBdcdyFwlxDO,SZdFwjgDO,SZdJzwztDO"
        },
        async: false,
        success: function (data) {
            zdList = $.extend({}, data)
        }
    });

    layui.use(['form', 'jquery', 'laytpl', 'element', 'laydate'], function () {
        var form = layui.form;
        var $ = layui.jquery;


        //获取数据
        var index = layer.load(1, {shade: [0.1, '#fff']});
        $.ajax({
            url: "../djdcb/zdxxinfo",
            dataType: "json",
            data: {
                bdcdyh: bdcdyh
            },
            success: function (data) {
                layer.closeAll();
                var qlrList = data.qlrResponseDTOList;
                if (qlrList) {
                    generateQlrList(qlrList, 0);
                } else {
                    generateQlrList();
                }

                var zdxx = disposeZdsz(data.djDcbResponseDTO);
                form.val("form", zdxx)
            },
            error: function (xhr, status, error) {
                delAjaxErrorMsg(xhr)
            }
        });
    });

    function disposeZdsz(data) {
        if(data){
            var zdsz = data.zdszd + ";" + data.zdszn + ";" + data.zdszx + ";" + data.zdszb + ";"
            data.zdsz = zdsz;
        }
        return data;
    }

    //生成权利人list表单 qlrList：权利人列表 listStartWhith：从第几个开始生成 isFg：是否需要覆盖
    function generateQlrList(qlrList, listStartWhith) {
        layui.use(['form', 'jquery', 'laytpl', 'element'], function () {
            var form = layui.form;
            var $ = layui.jquery;
            var laytpl = layui.laytpl;
            var element = layui.element;
            if (qlrList == null) {
                qlrList = [{}]
            }
            if (listStartWhith == null) listStartWhith = 0;
            var json = {
                start: listStartWhith,
                data: qlrList,
                zdList: zdList
            }
            //获取模板
            var tpl = $("#qlrTpl").html();
            //渲染数据
            laytpl(tpl).render(json, function (html) {
                if (listStartWhith === 0) {
                    //如果覆盖之前的
                    $("#qlrList").html(html);
                } else {
                    $("#qlrList").append(html);
                }
            });
            form.render();
            element.render();
            listStartWhith = listStartWhith + qlrList.length;
            if (qlrList.length == 0) {
                listStartWhith++;
            }
            return listStartWhith;
        })
    }
</script>
</body>
</html>