<!DOCTYPE html>
<html lang="zh-cn">
<head>
    <meta charset="utf-8">
    <title>房屋户室图</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form.css">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js"></script>
    <link rel="stylesheet" href="../css/upload.css?v=1.0.7">
</head>
<body>
    <!-- 图片上传开始 -->
    <div class="layui-upload-drag img-drag" style="background-color: #ffffff" id="hst">
    </div>
<script type="text/html" id="uploadTpl">
    {{# if(d.srcUrl){ }}
    <img id="img" class="upload-img" src="{{d.srcUrl}}" alt="">
    {{# }else{ }}
    <div class="upload-icon">
        <i class="layui-icon">&#xe654;</i>
        <span>上传平面图</span>
    </div>
    <h4>点击/拖拽单个文件到这里上传</h4>
    <p>支持jpeg、jpg、png格式，大小在10M以下</p>
    <img id="img"  class="upload-img" src="" alt="">
    <div class="video-icon"></div>
    {{# } }}
</script>


<script>
    // 户室图主键
    var bdcdyh = '${bdcdyh!}';
    layui.use(['form', 'jquery', 'laytpl', 'element', 'laydate', 'upload'], function () {
        var form = layui.form;
        var $ = layui.jquery;
        var laydate = layui.laydate;
        var laytpl = layui.laytpl;
        var element = layui.element;
        var upload = layui.upload;
        // 查询 户室图
        if (bdcdyh) {
            $.ajax({
                url: "../hst/queryfwhstbybdcdyh",
                dataType: "json",
                data: {
                    bdcdyh: bdcdyh
                },
                async: false,
                success: function (data) {
                    if (data.src) {
                        renderTpl({srcUrl: data.src});
                    } else {
                        layer.msg("无户室图");
                    }
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
        }


        function renderTpl(json) {
            layui.use('laytpl', function () {
                //获取模板
                var tpl = $("#uploadTpl").html();
                var laytpl = layui.laytpl;
                //渲染数据
                laytpl(tpl).render(json, function (html) {
                    $("#hst").html(html);
                });
            })
        }

    })

</script>
</body>
</html>
