<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>逻辑幢建筑面积计算</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form.css">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js"></script>
</head>
<body>
<div class="bdc-form-div">
    <form class="layui-form setOverflow" lay-filter="form">
        <div class="content-title layui-clear">
            <p>逻辑幢建筑面积计算</p>
            <div class="title-btn-area">
                <button class="layui-btn bdc-secondary-btn" id="chooseZd" type="button">选择宗地</button>
                <button class="layui-btn bdc-secondary-btn" id="chooseLjz" type="button">选择逻辑幢</button>
                <button class="layui-btn bdc-major-btn" lay-submit="" lay-filter="calculated"
                        id="calculated" type="button">计算</button>
            </div>
        </div>
        <div class="form-margin-area" style="min-height: 500px">
            <div class="layui-form-item layui-hide">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">fwDcbIndex</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="fwDcbIndex" id="fwDcbIndex"
                               value="">
                    </div>
                </div>
            </div>
            <div class="basic-info">
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width">宗地号</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="zdh" id="zdh" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width">逻辑幢</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" id="fwmc" readonly>
                        </div>
                    </div>
                </div>

                <div class="layui-form-item layui-hide">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">面积类别</label>
                        <div class="layui-input-inline">
                            <input type="radio" class="layui-input" name="mjlb" value="sc" title="实测" checked/>
                            <input type="radio" class="layui-input" name="mjlb" value="yc" title="预测"/>
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt">
                        <label class="layui-form-label change-label-width">计算规则</label>
                        <div class="layui-input-inline">
                            <input type="checkbox" class="layui-input" name="zhs" value="zhs" title="计算子户室建筑面积"/>
                            <input type="checkbox" class="layui-input" name="dxs" value="dxs" title="计算地下室"/>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
    layui.use(['form', 'jquery', 'laytpl', 'element'], function () {
        var form = layui.form;
        var $ = layui.jquery;
        //form初始化
        form.render();
        form.on('radio(jsfw)', function (data) {
            if (data.elem.title == "宗地") {
                $("#chooseZd").removeClass("layui-hide")
                $("#chooseLjz").addClass("layui-hide")
            } else if (data.elem.title == "逻辑幢") {
                $("#chooseLjz").removeClass("layui-hide")
                $("#chooseZd").addClass("layui-hide")
            }
        });
        form.on("submit(calculated)", function (data) {
            var postData = data.field
            if(postData.zhs){
                postData.zhs=true
            }
            if(postData.dxs){
                postData.dxs=true
            }
            var loadIndex = layer.load(2, {shade: [0.1, '#fff']});
            $.ajax({
                url: "../calculated/ljzzjmj",
                dataType: "json",
                data: postData,
                success: function (data) {
                    layer.close(loadIndex)
                    if(data&&data.success){
                        layer.msg(data.msg)
                    }
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
            return false;
        })


        //通过配置计算（先保留）
        /*form.on("submit(calculateConfig)", function (data) {
            var postData = data.field
            $.ajax({
                url: "../calculated/ljzzjmj/byconfig",
                dataType: "json",
                data: {
                    fwDcbIndex:postData.fwDcbIndex
                },
                success: function (data) {

                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
            return false;
        })*/



    });

    $("#chooseZd").click(function () {
        var index = layer.open({
            type: 2,
            title: "选择宗地",
            area: ['1300px', '600px'],
            fixed: false, //不固定
            content: '../zd/picklist'
        });
    });

    $("#chooseLjz").click(function () {
        var index = layer.open({
            type: 2,
            title: "选择宗地",
            area: ['1300px', '600px'],
            fixed: false, //不固定
            content: '../ljz/picklist?showQuery=lszd,ljzh,zldz'
        });
    });

    function pickLjzCallback(data) {
        $("#zdh").val(data.lszd);
        $("#fwDcbIndex").val(data.fw_dcb_index);
        $("#fwmc").val(data.fwmc);
        layui.use(['layer', 'form'], function () {
            var form = layui.form;
            form.render();
            layer.closeAll();
        });
    }
    // 宗地列表回调函数
    function pickZdlistCallback(djh){
        $("#zdh").val(djh);
        $("#fwDcbIndex").val("");
        $("#fwmc").val("");
        layui.use(['layer','form'], function () {
            var form = layui.form;
            form.render();
        });
    }
</script>
</body>

</html>
