<!DOCTYPE html>
<html lang="zh-cn">

<head>
    <meta charset="utf-8">
    <title>分摊土地面积计算</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="stylesheet" href="../lib/layui/css/layui.css" media="all">
    <link rel="stylesheet" href="../lib/bdcui/css/common.css">
    <link rel="stylesheet" href="../lib/bdcui/css/form.css">
    <script src="../lib/layui/layui.js"></script>
    <script src="../lib/js/jquery.min.js"></script>
    <script src="../js/common.js"></script>
</head>
<body>
<div class="bdc-form-div">
    <form class="layui-form setOverflow" lay-filter="form">
        <div class="content-title layui-clear">
            <p>分摊土地面积计算</p>
            <div class="title-btn-area">
                <button class="layui-btn bdc-secondary-btn" id="chooseZd" type="button">选择宗地</button>
                <button class="layui-btn bdc-secondary-btn" id="chooseLjz" type="button">选择逻辑幢</button>
                <button class="layui-btn bdc-major-btn" lay-submit="" lay-filter="calculated"
                        id="calculated" type="button">计算
                </button>
            </div>
        </div>
        <div class="form-margin-area" style="min-height: 500px">
            <div class="layui-form-item layui-hide">
                <div class="layui-inline margin-top-ipt">
                    <label class="layui-form-label change-label-width">fwDcbIndex</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" name="fwDcbIndex" id="fwDcbIndex"
                               value="">
                    </div>
                </div>
            </div>
            <div class="basic-info">
                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width">宗地号</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" name="zdh" id="zdh" readonly>
                        </div>
                    </div>
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width">逻辑幢</label>
                        <div class="layui-input-inline">
                            <input type="text" class="layui-input" id="fwmc" readonly>
                        </div>
                    </div>
                </div>

                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width">计算规则</label>
                        <div class="layui-input-inline">
                            <input type="checkbox" class="layui-input" name="zhs" value="zhs" title="计算子户室建筑面积"/>
                            <input type="checkbox" class="layui-input" name="dxs" value="dxs" title="计算地下室"/>
                        </div>
                    </div>
                </div>

                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width">计算公式</label>
                        <div class="layui-input-inline">
                            <table border="0" style="font-size: 15px;height: 90px">
                                <tr>
                                    <td rowspan="3"><input type="radio" class="layui-input" name="jsgsxh" value="2"
                                                           lay-filter="jsgsxh" checked/></td>
                                    <td rowspan="3" width="20">(</td>
                                    <td align="center" colspan="4">户室建筑面积</td>
                                    <td rowspan="3" width="20" align="right">)</td>
                                    <td rowspan="3">*</td>
                                    <td rowspan="3">宗地内楼幢(
                                        <input type="radio" class="layui-input" name="mjlb" value="sc" lay-filter="mjlb"
                                               title="实测面积" checked/>
                                        <input type="radio" class="layui-input" name="mjlb" value="fz" lay-filter="mjlb"
                                               title="发证面积"/>
                                        )
                                    </td>
                                </tr>
                                <tr>
                                    <td class="x" rowspan="2">宗地内楼幢总建筑面积</td>
                                    <td class="x" rowspan="2">(</td>
                                    <td class="x"><input type="radio" class="layui-input" name="zdnlzzjzmj" value="ljz"
                                                         lay-filter="zdnlzzjzmj" title="逻辑幢(SCJZMJ)" checked/></td>
                                    <td class="x" rowspan="2">)</td>
                                </tr>
                                <tr>
                                    <td><input type="radio" class="layui-input" name="zdnlzzjzmj" value="zrz"
                                               lay-filter="zdnlzzjzmj" title="自然幢(ZDMJ*FWCS)"/></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width"></label>
                        <div class="layui-input-inline">
                            <table border="0" style="font-size: 15px;height: 90px">
                                <tr>
                                    <td rowspan="2"><input type="radio" class="layui-input" name="jsgsxh" value="3"
                                                           lay-filter="jsgsxh"/></td>
                                    <td rowspan="2" width="20">(</td>
                                    <td align="center">户室建筑面积</td>
                                    <td rowspan="2" width="20" align="right">)</td>
                                    <td rowspan="2">*</td>
                                    <td rowspan="2">宗地内楼幢</td>
                                </tr>
                                <tr>
                                    <td class="x">自然幢内楼幢总建筑面积</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width"></label>
                        <div class="layui-input-inline">
                            <table border="0" style="font-size: 15px;height: 90px">
                                <tr>
                                    <td><input type="radio" class="layui-input" name="jsgsxh" value="1"
                                               lay-filter="jsgsxh"/></td>
                                    <td align="center">户室建筑面积</td>
                                    <td>*</td>
                                    <td><input type="text" class="layui-input" name="ftxs" placeholder="分摊系数"/></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="layui-form-item">
                    <div class="layui-inline margin-top-ipt bdc-two-column">
                        <label class="layui-form-label change-label-width"></label>
                        <div class="layui-input-inline">
                            <table border="0" style="font-size: 15px;height: 90px">
                                <tr>
                                    <td rowspan="2"><input type="radio" class="layui-input" name="jsgsxh" value="4"
                                                           lay-filter="jsgsxh"/></td>
                                    <td rowspan="2" width="20">(</td>
                                    <td align="center">户室建筑面积</td>
                                    <td rowspan="2" width="20" align="right">)</td>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="x"><input type="text" class="layui-input" name="lcs" placeholder="楼层数"/>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<style type="text/css">
    .x {
        border-top: 1px solid black;
        border-left: 0px solid black;
        border-right: 0px solid black;
        border-bottom: 0px solid black;
</style>

<script>
    layui.use(['form', 'jquery', 'laytpl', 'element'], function () {
        var form = layui.form;
        var $ = layui.jquery;
        //form初始化
        form.render();
        form.on('radio(jsfw)', function (data) {
            if (data.elem.title == "宗地") {
                $("#chooseZd").removeClass("layui-hide")
                $("#chooseLjz").addClass("layui-hide")
            } else if (data.elem.title == "逻辑幢") {
                $("#chooseLjz").removeClass("layui-hide")
                $("#chooseZd").addClass("layui-hide")
            }
        });
        form.on("submit(calculated)", function (data) {
            var ftxs = 0;
            var postData = data.field
            if (postData.ftxs) {
                ftxs = parseFloat(postData.ftxs);
            }
            postData.ftxs = ftxs;
            if (postData.zhs) {
                postData.zhs = true
            }
            if (postData.dxs) {
                postData.dxs = true
            }
            var loadIndex = layer.load(2, {shade: [0.1, '#fff']});
            $.ajax({
                url: "../calculated/fttdmj",
                dataType: "json",
                data: postData,
                success: function (data) {
                    layer.close(loadIndex)
                    if (data && data.success) {
                        layer.msg(data.msg)
                    } else {
                        layer.msg(data.msg)
                    }
                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
            return false;
        })


        //通过配置计算(先保留)
        /*form.on("submit(calculateConfig)", function (data) {
            var postData = data.field
            $.ajax({
                url: "../calculated/fttdmj/byconfig",
                dataType: "json",
                data: {
                    fwDcbIndex:postData.fwDcbIndex
                },
                success: function (data) {

                },
                error: function (xhr, status, error) {
                    delAjaxErrorMsg(xhr)
                }
            });
            return false;
        })*/

    });

    $("#chooseZd").click(function () {
        var index = layer.open({
            type: 2,
            title: "选择宗地",
            area: ['1300px', '600px'],
            fixed: false, //不固定
            content: '../zd/picklist'
        });
    });

    $("#chooseLjz").click(function () {
        var index = layer.open({
            type: 2,
            title: "选择宗地",
            area: ['1300px', '600px'],
            fixed: false, //不固定
            content: '../ljz/picklist?showQuery=lszd,ljzh,zldz'
        });
    });

    function pickLjzCallback(data) {
        $("#zdh").val(data.lszd);
        $("#fwDcbIndex").val(data.fw_dcb_index);
        $("#fwmc").val(data.fwmc);
        layui.use(['layer', 'form'], function () {
            var form = layui.form;
            form.render();
            layer.closeAll();
        });
    }

    // 宗地列表回调函数
    function pickZdlistCallback(djh) {
        $("#zdh").val(djh);
        $("#fwDcbIndex").val("");
        $("#fwmc").val("");
        layui.use(['layer', 'form'], function () {
            var form = layui.form;
            form.render();
        });
    }

    function layHide(elem) {
        elem.addClass("layui-hide");
    }

    function layShow(elem) {
        elem.removeClass("layui-hide");
    }
</script>
</body>

</html>
