/**
 * author: 前端组
 * date: 2018-12-14
 * version 3.0.0
 * describe: 初始化表格，工具栏事件
 */
layui.use(['table', 'laytpl', 'layer'], function () {
    var table = layui.table,
        $ = layui.jquery,
        layer = layui.layer;

    //监听滚动事件
    var scrollTop = 0,
        scrollLeft = 0;
    $(window).on('scroll', function () {
        scrollTop = $(this).scrollTop();
        scrollLeft = $(this).scrollLeft();
    });

    //点击表格中的更多
    $('.bdc-table-box').on('click', '.bdc-more-btn', function (event) {
        event.stopPropagation();
        var $btnMore = $(this).siblings('.bdc-table-btn-more');
        if ($(this).offset().top + 26 + $btnMore.height() < document.body.offsetHeight) {
            $btnMore.css({top: $(this).offset().top + 26 - scrollTop, left: $(this).offset().left - 30 - scrollLeft});
        } else {
            $btnMore.css({
                top: $(this).offset().top - scrollTop - $btnMore.height(),
                left: $(this).offset().left - 30 - scrollLeft
            });
        }

        $('.bdc-table-btn-more').hide();
        $btnMore.show();
    });
    //点击更多内的任一内容，隐藏
    $('.bdc-table-btn-more a').on('click', function () {
        $(this).parent().hide();
    });
    //点击页面任一空白位置，消失
    $('body').on('click', function () {
        $('.bdc-table-btn-more').hide();
    });

});


//------------工程部异步请求分页数据问题修改---------------------------
//通过url来进行加载数据
function loadDataTablbeByUrl(_domId, _tableConfig) {
    layui.use(['table', 'laypage', 'jquery'], function () {
        if (_domId) {
            var table = layui.table;
            var $ = layui.jquery;
            var tableDefaultConfig = {
                elem: _domId
                , cellMinWidth: 80
                , page: true //开启分页
                , limit: 10
                , parseData: function (res) { //res 即为原始返回的数据
                    if (!res.hasContent) {
                        res.msg = "无数据"
                    }
                    return res;
                }
                , request: {
                    limitName: 'size' //每页数据量的参数名，默认：limit
                }
                , response: {
                    countName: 'totalElements' //数据总数的字段名称，默认：count
                    , dataName: 'content' //数据列表的字段名称，默认：data
                    , statusName: 'hasContent' //规定数据状态的字段名称，默认：code
                    , statusCode: true //规定成功的状态码，默认：0
                }
                ,defaultToolbar : []
            };
            if (!_tableConfig.cols || !_tableConfig.cols[0] || _tableConfig.cols[0].length < 1) {
                _tableConfig.cols = [[]]
            }
            var tableRenderConfig = $.extend({}, tableDefaultConfig, _tableConfig);
            table.render(tableRenderConfig);
        }
    });
}
function tableReload(tableid, postData) {
    layui.use(['table'], function () {
        var table = layui.table;
        table.reload(tableid, {
            where: postData
            , page: {
                //重新从第 1 页开始
                curr: 1
            }
        });
    });
}