function initState(tabFlag){
    $(".bdc-state-zoom").removeClass("layui-hide");
    var info = globalData.resource.info;
    var djzt = "";
    var qlzt = "";
    var jyzt = "";
    for(var key in info){
        var tabType = eval("info." + key + ".tabType");
        // 登记状态
        if(key == "djztState"){
            if(tabType && (tabType.indexOf(tabFlag) == 0 || tabType.indexOf(',' + tabFlag) > 0)){
                djzt = eval("info." + key + ".constant");
            }
        }
        // 权利状态
        if(key == "qlztState"){
            if(tabType && (tabType.indexOf(tabFlag) == 0 || tabType.indexOf(',' + tabFlag) > 0)){
                qlzt = eval("info." + key + ".constant");
            }
        }
        // 交易状态
        if(key == "jyztState"){
            if(tabType && (tabType.indexOf(tabFlag) == 0 || tabType.indexOf(',' + tabFlag) > 0)){
                jyzt = eval("info." + key + ".constant");
            }
        }
    }

    var djztHtml = getDjztState(djzt);
    var jyztHtml = getJyztState(jyzt);
    var qlztHtml = getQlztState(qlzt);


    layui.use(['table'], function () {
        var table = layui.table;
        if(tabFlag == "hs"){
            $("#hsTab").find(".bdc-state-show").html(djztHtml+jyztHtml+qlztHtml);
            if($("#hsTab").find(".layui-icon-up").hasClass("bdc-hide")){
                $("#hsTab .bdc-state-zoom").click();
            }
        }
        if(tabFlag == "ychs"){
            $("#ychsTab").find(".bdc-state-show").html(djztHtml+jyztHtml+qlztHtml);
            refreshZoomTop($("#ychsTab"));
            if($("#ychsTab").find(".layui-icon-up").hasClass("bdc-hide")){
                $("#ychsTab .bdc-state-zoom").click();
            }
        }
    });
}

function getDjztState(djzt){
    var html = "";
    if(djzt){
        var arr = djzt.split(",");
        for(var i = 0 ;i < arr.length ;i++){
            if(arr[i] == "WDJ"){
                html += "<span><i class=\"bdc-wdj\"></i>未登记</span>";
            }
            if(arr[i] == "YG"){
                html += "<span><i class=\"bdc-ywg\"></i>已预告</span>";
            }
            if(arr[i] == "DJ"){
                html += "<span><i class=\"bdc-ydj\"></i>已登记</span>";
            }
            if(arr[i] == "ZX"){
                html += "<span><i class=\"bdc-yzx\"></i>已注销</span>";
            }
        }
    }
    if(html){
        html = "<p>登记状态：" + html +"</p>";
    }
    return html;
}

function getJyztState(jyzt){
    var html = "";
    if(jyzt){
        var arr = jyzt.split(",");
        for(var i = 0 ;i < arr.length ;i++){
            if(arr[i] == "KS"){
                html += "<span><i class=\"bdc-ks\"></i>可售</span>";
            }
            if(arr[i] == "YS"){
                html += "<span><i class=\"bdc-ys\"></i>已售</span>";
            }
            if(arr[i] == "CQ"){
                html += "<span><i class=\"bdc-cq\"></i>草签</span>";
            }
            if(arr[i] == "WGYF"){
                html += "<span><i class=\"bdc-wg\"></i>物管用房</span>";
            }
            if(arr[i] == "AZF"){
                html += "<span><i class=\"bdc-az\"></i>安置房</span>";
            }
            if(arr[i] == "BLF"){
                html += "<span><i class=\"bdc-bl\"></i>保留房</span>";
            }
            if(arr[i] == "FPTZF"){
                html += "<span><i class=\"bdc-fpt\"></i>非普通住房</span>";
            }
        }
    }
    if(html){
        html = "<p>交易状态：" + html +"</p>";
    }
    return html;
}

function getQlztState(qlzt) {
    var html = "";
    if(qlzt){
        var arr = qlzt.split(",");
        for(var i = 0 ;i < arr.length ;i++){
            if(arr[i] == "ZJGCDY"){
                html += "<span><i class=\"bdc-zj\"></i>在建工程抵押</span>";
            }
            if(arr[i] == "DY"){
                html += "<span><i class=\"bdc-ydy\"></i>预抵押</span>";
            }
            if(arr[i] == "YCF"){
                html += "<span><i class=\"bdc-ycf\"></i>预查封</span>";
            }
            if(arr[i] == "CF"){
                html += "<span><i class=\"bdc-cf\"></i>查封</span>";
            }
            if(arr[i] == "DJ"){
                html += "<span><i class=\"bdc-dj\"></i>冻结</span>";
            }
            if(arr[i] == "YY"){
                html += "<span><i class=\"bdc-yy\"></i>异议</span>";
            }
            if(arr[i] == "DYI"){
                html += "<span><i class=\"bdc-dy\"></i>地役</span>";
            }
        }
    }
    if(html){
        html = "<p>权利状态：" + html +"</p>";
    }
    return html;
}


// 调整 收缩按钮高度
function refreshZoomTop(element){
    var height = getStateHeight(element);
    if(height == 0){
        element.find(".bdc-state-zoom").addClass("layui-hide");
    }else{
        element.find(".bdc-state-zoom").animate({"top": (height + 20) + "px"}, 100);
    }
}

function getStateHeight(element){
    var pLength = element.find(".bdc-state-show").find("p").length;
    var height = 0;
    for(var i = 0;i<pLength;i++){
        height += 35;
    }
    return height;
}

function getTableHeight(element){
    if(element.find(".bdc-state-show").hasClass("bdc-state-hide")){
       return 107;
    }else{
        var pLength = element.find(".bdc-state-show").find("p").length;
        var height = 127;
        for(var i = 0;i<pLength;i++){
            height += 35;
        }
        return height;
    }
}