function initYchsBtns(){
    initBtns("ychs","ychsToolbar");
}

function initHsBtns(){
    initBtns("hs","hsToolbar");
}

function initBtns(tabFlag,toolBarId){
    var info = globalData.resource.info;
    var btnInfos = [];
    var moreBtnInfo = [];
    var hsHasSelectBtn = false;
    var ychsHasSelectBtn = false
    $.each(info, function () {
        if (this.type == 'BUTTON') {
            if(this.tabType && (this.tabType.indexOf(tabFlag) == 0
                    || this.tabType.indexOf(',' + tabFlag) > 0)){
                if(this.btnMore){
                    moreBtnInfo.push(this);
                }else{
                    btnInfos.push(this);
                }
                if(this.value == 'select'){
                    if(tabFlag == 'hs'){
                        hsHasSelectBtn = true;
                    }else{
                        ychsHasSelectBtn = true;
                    }
                }
            }
        }
    });

    if(tabFlag == 'hs'){
        if(hsHasSelectBtn){
            hsCheckboxHide = true;
        }else{
            hsCheckboxHide = false;
        }
    }else{
        if(ychsHasSelectBtn){
            ychsCheckboxHide = true;
        }else{
            ychsCheckboxHide = false;
        }
    }
    var json = {
        btns:btnInfos,moreBtns:moreBtnInfo
    };
    layui.use(['laytpl', 'form'], function () {
        var laytpl = layui.laytpl;
        var toolbar = toolbarTpl.innerHTML
            , toolbarDiv = document.getElementById(toolBarId);
        laytpl(toolbar).render(json, function (html) {
            toolbarDiv.innerHTML = html;
        });
    });
}


/**
 * 调用外围系统的回调方法
 * @param callbackFun
 */
function btnCallBack(callbackFun){
    var data = [];
    var paramObj = $.parseJSON(param);
    $.each(hsCheckList, function (index, v) {
        data.push($.parseJSON($("input[data-index='"+v+"']").attr("data-info")));
    });
    $.each(ychsCheckList, function (index, v) {
        data.push($.parseJSON($("input[data-index='"+v+"']").attr("data-info")));
    });
    if(eval("parent."+callbackFun)){
        eval("parent."+callbackFun+"(paramObj,data)");
    }
}

/**
 * 更多按钮事件
 * @param event
 */
function moreClick(event){
    eval(event + "Function()");
}
/**
 * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
 * @description 预设按钮功能定义
 */
/**
 * 选择按钮 event：select
 */
function selectFunction() {
    var hsTab = ishsTab();
    if(hsTab){
        $("#hsTab").find("div[lay-skin='primary']").toggleClass('bdc-hide');
        if (hsCheckboxHide) {
            hsCheckboxHide = false;
        } else {
            hsCheckboxHide = true;
        }
        hsCheckList = [];
        layui.use(['table'], function () {
            var table = layui.table;
            table.reload("hsId");
        })
    }else{
        $("#ychsTab").find("div[lay-skin='primary']").toggleClass('bdc-hide');
        if (ychsCheckboxHide) {
            ychsCheckboxHide = false;
        } else {
            ychsCheckboxHide = true;
        }
        ychsCheckList = [];
        layui.use(['table'], function () {
            var table = layui.table;
            table.reload("ychsId");
        })
    }
}

/**
 * 重置按钮 event: reset
 */
function resetFunction() {
    layui.use(['jquery', 'laytpl', 'element', 'table'], function () {
        var hsTab = ishsTab();
        var table = layui.table;
        if(hsTab){
            hsCheckList = [];
            table.reload("hsId");
        }else{
            ychsCheckList = [];
            table.reload("ychsId");
        }
    })
}

/**
 * 新增操作  event: add
 */
function addFunction() {
    layui.use(['jquery', 'laytpl', 'element', 'table'], function () {
        var fwDcbIndex = $("#fwDcbIndex").val();
        var hsTab = ishsTab();
        if (hsTab){
            layer.open({
                type: 2,
                title: "新增户室",
                maxmin: true,
                area: ['100%', '100%'],
                fixed: false, //不固定
                content: '../fwhs/info?fwDcbIndex=' + fwDcbIndex
                , end: function (index, layero) {
                    refreshMainPage();
                    return false;
                }
            });
        }else{
            layer.open({
                type: 2,
                title: "新增预测户室",
                maxmin: true,
                area: ['100%', '100%'],
                fixed: false, //不固定
                content: '../fwychs/info?fwDcbIndex=' + fwDcbIndex
                , end: function (index, layero) {
                    refreshMainPage();
                    return false;
                }
            });
        }
    })
}

/**
 * 合并操作  event: hshb
 */
function hshbFunction() {
    layui.use(['jquery', 'laytpl', 'element', 'table'], function () {
        if (hsCheckList && hsCheckList.length > 1) {
            var data = [];
            //把带-的字符串转为数组
            hsCheckList.forEach(function (v) {
                data.push({fw_hs_index: v});
            });
            var checkFlag = hbCheckFun(data);
            if (checkFlag) {
                fwhsHb(data);
            } else {
                layer.alert("请选择连续，同一单元数据进行合并操作");
            }
        } else {
            layer.alert("请选择多条数据进行合并操作");
        }
    })
}

/**
 * 拆分操作  event: hscf
 */
function hscfFunction() {
    layui.use(['jquery', 'laytpl', 'element', 'table'], function () {
        if (hsCheckList.length == 1) {
            fwhsCf({fw_hs_index: hsCheckList[0]});
        } else {
            layer.alert("请选择一条数据进行拆分操作");
        }
    })
}

/**
 * 删除操作  event: delete
 */
function deleteFunction() {
    layui.use(['jquery', 'laytpl', 'element', 'table'], function () {
        var hsTab = ishsTab();
        var checkList = hsTab?hsCheckList:ychsCheckList;
        if (checkList && checkList.length > 0) {
            var data = [];
            //把带-的字符串转为数组
            checkList.forEach(function (v) {
                data.push({fw_hs_index: v});
            });
            layer.confirm('确定删除？', function (index) {
                if(hsTab){
                    deletefwhs(data);
                }else{
                    deletefwychs(data);
                }
                return false;
            });
        } else {
            layer.alert("请选择至少一条数据进行删除操作");
        }
    })
}

/**
 * 更新操作  event: update
 */
function updateFunction() {
    layui.use(['jquery', 'laytpl', 'element', 'table'], function () {
        var hsTab = ishsTab();
        var checkList = hsTab ? hsCheckList:ychsCheckList;
        if (checkList.length == 1) {
            var fwDcbIndex = $("#fwDcbIndex").val();
            var updateData = {
                fw_hs_index: checkList[0],
                fw_dcb_index: fwDcbIndex
            }
            if(hsTab){
                fwhsUpdate(updateData);
            }else{
                fwychsUpdate(updateData);
            }
        } else {
            layer.alert("请选择至少一条数据进行更新操作");
        }
    })
}

/**
 * 户室灭失 event：hsms
 */
function hsmsFunction() {
    layui.use(['jquery', 'laytpl', 'element', 'table'], function () {
        var data = [];
        $.each(hsCheckList, function (index, v) {
            data.push({fw_hs_index: v});
        })
        if (data.length == 1) {
            fwhsMs(data[0]);
        } else {
            layer.alert("请选择一条数据进行灭失操作");
        }
    })
}

/**
 * 户室变更 event：hsbg
 */
function hsbgFunction() {
    layui.use(['jquery', 'laytpl', 'element', 'table'], function () {
        var data = [];
        $.each(hsCheckList, function (index, v) {
            data.push({fw_hs_index: v});
        })
        if (data.length == 1) {
            var bgData = {
                fw_hs_index: data[0].fw_hs_index,
                fw_dcb_index: fwDcbIndex
            }
            fwhsBg(bgData);
        } else {
            layer.alert("请选择一条数据进行变更操作");
        }
    })
}

/**
 * 批量更新属性 event：plgxsx
 */
function plgxsxFunction() {
    layui.use(['jquery', 'laytpl', 'element', 'table'], function () {
        if (hsCheckList && hsCheckList.length > 0) {
            var data = [];
            $.each(hsCheckList, function (index, v) {
                data.push({fw_hs_index: v});
            });
            plgxsxFun(data);
        } else {
            layer.alert("请选择至少一条数据进行更新操作");
        }
    })
}

/**
 * 批量更新面积 event：plgxmj
 */
function plgxmjFunction() {
    layui.use(['jquery', 'laytpl', 'element', 'table'], function () {
        if (hsCheckList && hsCheckList.length > 0) {
            var data = [];
            $.each(hsCheckList, function (index, v) {
                data.push({fw_hs_index: v});
            });
            plgxmjFun(data);
        } else {
            layer.alert("请选择至少一条数据进行更新操作");
        }
    })
}