/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.building.ui.web.main;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.realestate.common.core.service.feign.building.BuildingZdConvertFeignService;
import cn.gtmap.realestate.common.core.support.spring.EnvironmentConfig;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;

@Validated
public class BaseController {
    @Autowired
    BuildingZdConvertFeignService buildingZdConvertFeignService;
    @Autowired
    protected UserManagerClient userManagerClient;

    @ModelAttribute
    public void setReqAndRes(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("X-Frame-Options", "SAMEORIGIN");
        request.setAttribute("buildingUrl", (Object)EnvironmentConfig.getEnvironment().getProperty("app.building"));
        request.setAttribute("storageUrl", (Object)EnvironmentConfig.getEnvironment().getProperty("app.storage"));
    }

    public Map getZdList(Class[] zdList) {
        if (ArrayUtils.isNotEmpty((Object[])zdList)) {
            HashMap<String, Class> requestMap = new HashMap<String, Class>(zdList.length);
            for (Class zdClass : zdList) {
                requestMap.put(zdClass.getSimpleName(), zdClass);
            }
            if (MapUtils.isNotEmpty(requestMap)) {
                return this.buildingZdConvertFeignService.listZdTable(requestMap);
            }
        }
        return new HashMap(0);
    }

    public static Map returnHtmlResult(Boolean success, String msg) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(1);
        resultMap.put("success", success);
        resultMap.put("msg", msg);
        return resultMap;
    }

    public String getCurrentUserId(Authentication authentication) {
        UserDto userDto;
        String currentUserName = "";
        if (null != authentication && (userDto = this.userManagerClient.getUserByUsername(authentication.getName())) != null) {
            currentUserName = userDto.getId();
        }
        return currentUserName;
    }
}

