/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.building.ui.web;

import cn.gtmap.realestate.building.ui.core.vo.LpbChVO;
import cn.gtmap.realestate.building.ui.core.vo.LpbCkVo;
import cn.gtmap.realestate.building.ui.core.vo.LpbDyVO;
import cn.gtmap.realestate.building.ui.core.vo.LpbViewVO;
import cn.gtmap.realestate.building.ui.util.FwhsResComparator;
import cn.gtmap.realestate.building.ui.web.main.BaseController;
import cn.gtmap.realestate.common.core.domain.building.FwLjzDO;
import cn.gtmap.realestate.common.core.dto.building.ResourceDTO;
import cn.gtmap.realestate.common.core.dto.building.ZdTreeResponseDTO;
import cn.gtmap.realestate.common.core.service.feign.building.FwLjzFeginService;
import cn.gtmap.realestate.common.core.service.feign.building.LpbFeignService;
import cn.gtmap.realestate.common.core.service.feign.building.ZdFeignService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/lpb"})
public class LpbViewController
extends BaseController {
    @Autowired
    private LpbFeignService lpbFeignService;
    @Autowired
    private ZdFeignService zdFeignService;
    @Autowired
    private FwLjzFeginService fwLjzFeginService;
    private static final int CK_MAX_NUM = 10;
    private static final String FWLX_CK = "\u8f66\u5e93";

    @RequestMapping(value={"/view"})
    public String init(Model model, String code, String fwDcbIndex, String paramJson) {
        if (StringUtils.isBlank((CharSequence)code)) {
            code = "default";
        }
        model.addAttribute("param", (Object)paramJson);
        model.addAttribute("code", (Object)code);
        model.addAttribute("fwDcbIndex", (Object)fwDcbIndex);
        return "lpb/lpbView";
    }

    @RequestMapping(value={"/initzdtree"})
    @ResponseBody
    public ZdTreeResponseDTO initZdTreeByFwDcbIndex(@NotBlank(message="\u903b\u8f91\u5e62\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") String fwDcbIndex) {
        return this.zdFeignService.initZdTreeByFwDcbIndex(fwDcbIndex);
    }

    @RequestMapping(value={"/initzdtree/allzrz"})
    @ResponseBody
    public ZdTreeResponseDTO initZdTreeByFwDcbIndexAndAllZrzh(@NotBlank(message="\u903b\u8f91\u5e62\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") String fwDcbIndex) {
        return this.zdFeignService.initZdTreeByFwDcbIndexAndAllZrzh(fwDcbIndex);
    }

    @RequestMapping(value={"/listljz"})
    @ResponseBody
    public List<FwLjzDO> listLjzByDjhAndZrzh(@NotBlank(message="\u5730\u7c4d\u53f7\u4e0d\u80fd\u4e3a\u7a7a") String djh, @NotBlank(message="\u81ea\u7136\u5e62\u53f7\u4e0d\u80fd\u4e3a\u7a7a") String zrzh) {
        return this.fwLjzFeginService.listLjzByDjhAndZrzh(djh, zrzh);
    }

    @RequestMapping(value={"/initzdtab"})
    public String zdTab() {
        return "lpb/lpbZdTab";
    }

    @RequestMapping(value={"/initzrztab"})
    public String zrzTab() {
        return "lpb/lpbZrzTab";
    }

    @RequestMapping(value={"/initljztab"})
    public String ljzTab() {
        return "lpb/lpbLjzTab";
    }

    @ResponseBody
    @RequestMapping(value={"/initdata"})
    public LpbViewVO initFwData(String code, String fwDcbIndex) {
        ResourceDTO lpbResourceDTO = this.lpbFeignService.queryFwHsListByFwDcbIndex(fwDcbIndex, code);
        if (lpbResourceDTO != null) {
            List fwhsList = lpbResourceDTO.getResourceDTOList();
            LpbViewVO lpbViewVO = new LpbViewVO();
            LpbViewController.convertFwhsData((LpbViewVO)lpbViewVO, (List)fwhsList);
            this.sortData(lpbViewVO);
            ResourceDTO resource = new ResourceDTO();
            BeanUtils.copyProperties((Object)lpbResourceDTO, (Object)resource);
            lpbViewVO.setResource(lpbResourceDTO);
            return lpbViewVO;
        }
        return null;
    }

    @ResponseBody
    @RequestMapping(value={"/initycdata"})
    public LpbViewVO initFwYchsData(String code, String fwDcbIndex) {
        ResourceDTO lpbResourceDTO = this.lpbFeignService.queryFwYchsListByFwDcbIndex(fwDcbIndex, code);
        if (lpbResourceDTO != null) {
            List fwhsList = lpbResourceDTO.getResourceDTOList();
            LpbViewVO lpbViewVO = new LpbViewVO();
            LpbViewController.convertFwhsData((LpbViewVO)lpbViewVO, (List)fwhsList);
            this.sortData(lpbViewVO);
            ResourceDTO resource = new ResourceDTO();
            BeanUtils.copyProperties((Object)lpbResourceDTO, (Object)resource);
            lpbViewVO.setResource(lpbResourceDTO);
            return lpbViewVO;
        }
        return null;
    }

    private LpbViewVO sortData(LpbViewVO lpbViewVO) {
        if (CollectionUtils.isNotEmpty((Collection)lpbViewVO.getcFwList())) {
            for (LpbChVO lpbChVO : lpbViewVO.getcFwList()) {
                if (!CollectionUtils.isNotEmpty((Collection)lpbChVO.getDyFwList())) continue;
                Collections.sort(lpbChVO.getDyFwList());
                for (LpbDyVO dyVO : lpbChVO.getDyFwList()) {
                    if (!CollectionUtils.isNotEmpty((Collection)dyVO.getFwhsResourceDTOList())) continue;
                    Collections.sort(dyVO.getFwhsResourceDTOList(), new FwhsResComparator());
                }
            }
            LpbViewController.sortDyh((LpbViewVO)lpbViewVO);
            Collections.sort(lpbViewVO.getcFwList());
        }
        return lpbViewVO;
    }

    private static void sortDyh(LpbViewVO lpbViewVO) {
        Collections.sort(lpbViewVO.getDyList(), new /* Unavailable Anonymous Inner Class!! */);
    }

    private static void convertFwhsData(LpbViewVO lpbViewVO, List<ResourceDTO> fwhsList) {
        if (CollectionUtils.isNotEmpty(fwhsList)) {
            LinkedHashMap listByCsMap = new LinkedHashMap();
            ArrayList<ResourceDTO> ckList = new ArrayList<ResourceDTO>();
            for (ResourceDTO resourceDTO : fwhsList) {
                LinkedHashMap infoMap = resourceDTO.getInfo();
                Map fwlxMap = MapUtils.getMap((Map)infoMap, (Object)"fwlx");
                Map wlcsMap = MapUtils.getMap((Map)infoMap, (Object)"wlcs");
                String fwlx = MapUtils.getString((Map)fwlxMap, (Object)"value");
                String wlcs = MapUtils.getString((Map)wlcsMap, (Object)"value");
                if (StringUtils.equals((CharSequence)fwlx, (CharSequence)"\u8f66\u5e93")) {
                    ckList.add(resourceDTO);
                    continue;
                }
                if (MapUtils.getObject(listByCsMap, (Object)wlcs) == null) {
                    ArrayList<ResourceDTO> list = new ArrayList<ResourceDTO>();
                    list.add(resourceDTO);
                    listByCsMap.put(wlcs, list);
                    continue;
                }
                ((List)listByCsMap.get(wlcs)).add(resourceDTO);
            }
            if (MapUtils.isNotEmpty(listByCsMap)) {
                Iterator iterator = listByCsMap.entrySet().iterator();
                LinkedHashMap dyMaxhsMap = new LinkedHashMap();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    LpbChVO lpbChVO = new LpbChVO();
                    lpbChVO.setWlcs((String)entry.getKey());
                    List cHsList = (List)entry.getValue();
                    LpbViewController.setCDyList((LpbChVO)lpbChVO, (List)cHsList, dyMaxhsMap);
                    LpbViewController.setCvo((LpbViewVO)lpbViewVO, (LpbChVO)lpbChVO);
                }
                if (MapUtils.isNotEmpty(dyMaxhsMap)) {
                    ArrayList dyhList = new ArrayList();
                    for (String key : dyMaxhsMap.keySet()) {
                        HashMap<String, String> dyhMap = new HashMap<String, String>();
                        dyhMap.put("dyh", key);
                        dyhMap.put("colspan", (String)dyMaxhsMap.get(key));
                        dyhList.add(dyhMap);
                    }
                    lpbViewVO.setDyList(dyhList);
                    for (LpbChVO lpbChVO : lpbViewVO.getcFwList()) {
                        for (LpbDyVO lpbDyVO : lpbChVO.getDyFwList()) {
                            lpbDyVO.setMaxHs(((Integer)dyMaxhsMap.get(lpbDyVO.getDyh())).intValue());
                        }
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(ckList)) {
                LpbViewController.dealCk((LpbViewVO)lpbViewVO, ckList);
            }
        }
    }

    private static void setCvo(LpbViewVO lpbViewVO, LpbChVO lpbChVO) {
        int cHs = 0;
        for (LpbDyVO lpbDyVO : lpbChVO.getDyFwList()) {
            cHs += lpbDyVO.getFwhsResourceDTOList().size();
        }
        if (lpbViewVO.getMaxHs() < cHs) {
            lpbViewVO.setMaxHs(Integer.valueOf(cHs));
        }
        lpbViewVO.getcFwList().add(lpbChVO);
    }

    private static void setCDyList(LpbChVO lpbChVO, List<ResourceDTO> cHsList, Map<String, Integer> dyMaxhsMap) {
        LinkedHashMap<String, LpbDyVO> dyMap = new LinkedHashMap<String, LpbDyVO>();
        for (ResourceDTO fwhs : cHsList) {
            LpbDyVO lpbDyVO;
            String dyh;
            LinkedHashMap infoMap = fwhs.getInfo();
            Map dycsMap = MapUtils.getMap((Map)infoMap, (Object)"dycs");
            Map dyhMap = MapUtils.getMap((Map)infoMap, (Object)"dyh");
            if (StringUtils.isBlank((CharSequence)lpbChVO.getDycs()) && StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)dycsMap, (Object)"value"))) {
                lpbChVO.setDycs(MapUtils.getString((Map)dycsMap, (Object)"value"));
            }
            String string = dyh = StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)dyhMap, (Object)"value")) ? MapUtils.getString((Map)dyhMap, (Object)"value") : "";
            if (MapUtils.getObject(dyMap, (Object)dyh) == null) {
                lpbDyVO = new LpbDyVO();
                lpbDyVO.setDyh(dyh);
                ArrayList<ResourceDTO> dyHsList = new ArrayList<ResourceDTO>();
                dyHsList.add(fwhs);
                lpbDyVO.setFwhsResourceDTOList(dyHsList);
                dyMap.put(dyh, lpbDyVO);
                continue;
            }
            lpbDyVO = (LpbDyVO)dyMap.get(dyh);
            lpbDyVO.getFwhsResourceDTOList().add(fwhs);
        }
        if (MapUtils.isNotEmpty(dyMap)) {
            LinkedList<LpbDyVO> dyVOList = new LinkedList<LpbDyVO>();
            for (String key : dyMap.keySet()) {
                LpbDyVO lpbDyVO = (LpbDyVO)dyMap.get(key);
                dyVOList.add(lpbDyVO);
                if (dyMaxhsMap.get(key) == null) {
                    dyMaxhsMap.put(key, LpbViewController.getDyMaxHs((LpbDyVO)lpbDyVO));
                    continue;
                }
                Integer maxHs = dyMaxhsMap.get(key);
                int thisMaxHs = LpbViewController.getDyMaxHs((LpbDyVO)lpbDyVO);
                if (maxHs >= thisMaxHs) continue;
                dyMaxhsMap.put(key, thisMaxHs);
            }
            lpbChVO.setDyFwList(dyVOList);
        }
    }

    private static int getDyMaxHs(LpbDyVO lpbDyVO) {
        int maxHs = 0;
        if (lpbDyVO != null && CollectionUtils.isNotEmpty((Collection)lpbDyVO.getFwhsResourceDTOList())) {
            for (ResourceDTO fwhs : lpbDyVO.getFwhsResourceDTOList()) {
                LinkedHashMap infoMap = fwhs.getInfo();
                Map hbfxMap = MapUtils.getMap((Map)infoMap, (Object)"hbfx");
                Map hbhsMap = MapUtils.getMap((Map)infoMap, (Object)"hbhs");
                if (infoMap != null && StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)hbfxMap, (Object)"value")) && NumberUtils.isNumber((String)MapUtils.getString((Map)hbhsMap, (Object)"value"))) {
                    String hbfx = MapUtils.getString((Map)hbfxMap, (Object)"value");
                    int hbhs = MapUtils.getIntValue((Map)hbhsMap, (Object)"value");
                    if (StringUtils.equals((CharSequence)"1", (CharSequence)hbfx) || StringUtils.equals((CharSequence)"2", (CharSequence)hbfx)) {
                        maxHs += hbhs;
                    }
                }
                ++maxHs;
            }
        }
        return maxHs;
    }

    private static void dealCk(LpbViewVO lpbViewVO, List<ResourceDTO> ckList) {
        Collections.sort(ckList, new FwhsResComparator());
        int maxNum = LpbViewController.getCkMaxNum((LpbViewVO)lpbViewVO);
        int rowspan = LpbViewController.getRowSpan(ckList, (int)maxNum);
        LinkedHashMap infoMap = ckList.get(0).getInfo();
        Map wlcsMap = MapUtils.getMap((Map)infoMap, (Object)"wlcs");
        Map dycsMap = MapUtils.getMap((Map)infoMap, (Object)"dycs");
        LpbCkVo lpbCkVo = new LpbCkVo();
        lpbCkVo.setWlcs(MapUtils.getString((Map)wlcsMap, (Object)"value"));
        lpbCkVo.setDycs(MapUtils.getString((Map)dycsMap, (Object)"value"));
        lpbCkVo.setCkList(ckList);
        lpbCkVo.setRowspan(rowspan);
        lpbCkVo.setMaxnum(maxNum);
        lpbViewVO.setLpbCkVo(lpbCkVo);
    }

    private static int getCkMaxNum(LpbViewVO lpbViewVO) {
        int max = 0;
        if (CollectionUtils.isNotEmpty((Collection)lpbViewVO.getDyList())) {
            for (Map dyMap : lpbViewVO.getDyList()) {
                max += MapUtils.getInteger((Map)dyMap, (Object)"colspan").intValue();
            }
        }
        if (max == 0) {
            max = 10;
        }
        return max;
    }

    private static int getRowSpan(List<ResourceDTO> ckList, int max) {
        int count = ckList.size();
        int mol = count % max;
        int rowspan = count / max;
        if (mol > 0) {
            ++rowspan;
        }
        return rowspan;
    }
}

