/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.building.ui.web;

import cn.gtmap.realestate.building.ui.web.main.BaseController;
import cn.gtmap.realestate.common.core.dto.building.ImportLpbRequestDTO;
import cn.gtmap.realestate.common.core.service.feign.building.LpbFeignService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"import"})
public class ImportController
extends BaseController {
    @Autowired
    private LpbFeignService lpbFeignService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportController.class);
    private static final String TEMP_PATH = "excel/lpbImportTemp.xls";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/downtemp"})
    public void downTemp(HttpServletResponse response) {
        ClassPathResource res = new ClassPathResource("excel/lpbImportTemp.xls");
        if (res != null) {
            BufferedInputStream bis = null;
            FilterOutputStream bos = null;
            response.setHeader("Content-disposition", "attachment; filename=lpbImportTemp.xls");
            response.setContentType("application/msexcel");
            try {
                int bytesRead;
                bis = new BufferedInputStream(res.getInputStream());
                bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
                byte[] buff = new byte[2048];
                while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                    ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.error("\u4e0b\u8f7d\u6a21\u677f\u5f02\u5e38", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("\u4e0b\u8f7d\u6a21\u677f\u5f02\u5e38", (Throwable)e);
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("\u4e0b\u8f7d\u6a21\u677f\u5f02\u5e38", (Throwable)e);
                    }
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("\u4e0b\u8f7d\u6a21\u677f\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
        }
    }

    @RequestMapping(value={"/lpb"})
    public String lpb(Model model, @NotBlank(message="\u903b\u8f91\u5e62\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") String fwDcbIndex) {
        model.addAttribute("fwDcbIndex", (Object)fwDcbIndex);
        return "fwhs/importLpb";
    }

    @RequestMapping(value={"/scmj"})
    public String scmj(Model model, @NotBlank(message="\u903b\u8f91\u5e62\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") String fwDcbIndex) {
        model.addAttribute("fwDcbIndex", (Object)fwDcbIndex);
        return "fwhs/importScmj";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"/importlpb"})
    public void importlpb(@NotNull(message="\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(value="file") MultipartFile file, ImportLpbRequestDTO importLpbRequestDTO) {
        InputStream fileIn = null;
        try {
            fileIn = file.getInputStream();
            Workbook workbook = Workbook.getWorkbook((InputStream)fileIn);
            if (workbook != null) {
                importLpbRequestDTO.setLpbList(ImportController.getEntityListByExcel((Workbook)workbook));
                this.lpbFeignService.importLpbInfo(importLpbRequestDTO);
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        finally {
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"/importScmj"})
    public void importScmj(@NotNull(message="\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(value="file") MultipartFile file, ImportLpbRequestDTO importLpbRequestDTO) {
        InputStream fileIn = null;
        try {
            fileIn = file.getInputStream();
            Workbook workbook = Workbook.getWorkbook((InputStream)fileIn);
            if (workbook != null) {
                importLpbRequestDTO.setLpbList(ImportController.getScListByExcel((Workbook)workbook));
                this.lpbFeignService.importScmj(importLpbRequestDTO);
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        finally {
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }
    }

    private static List<String> getTitlesByExcel(Workbook excelWorkbook) {
        Sheet dataSheet = excelWorkbook.getSheet(0);
        Cell[] titles = dataSheet.getRow(0);
        ArrayList<String> titleList = new ArrayList<String>();
        if (titles != null && titles.length > 0) {
            for (Cell cell : titles) {
                if (cell == null) {
                    titleList.add("");
                    continue;
                }
                titleList.add(cell.getContents());
            }
        }
        return titleList;
    }

    private static List<Map<String, Object>> getEntityListByExcel(Workbook excelWorkbook) {
        Sheet dataSheet = excelWorkbook.getSheet(0);
        List titleList = ImportController.getTitlesByExcel((Workbook)excelWorkbook);
        ArrayList<Map<String, Object>> hsList = new ArrayList<Map<String, Object>>();
        for (int i = 1; i < dataSheet.getRows(); ++i) {
            HashMap map = new HashMap();
            for (int j = 0; j < titleList.size(); ++j) {
                map.put(titleList.get(j), dataSheet.getCell(j, i).getContents());
            }
            if (!MapUtils.isNotEmpty(map) || ImportController.checkIsEmptyRow(map)) continue;
            hsList.add(map);
        }
        return hsList;
    }

    private static boolean checkIsEmptyRow(Map<String, Object> map) {
        boolean empty = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null || !StringUtils.isNotBlank((CharSequence)entry.getValue().toString())) continue;
            empty = false;
            break;
        }
        return empty;
    }

    private static List<Map<String, Object>> getScListByExcel(Workbook excelWorkbook) {
        Sheet dataSheet = excelWorkbook.getSheet(0);
        List titleList = ImportController.getTitlesByExcel((Workbook)excelWorkbook);
        ArrayList<Map<String, Object>> hsList = new ArrayList<Map<String, Object>>();
        for (int i = 1; i < dataSheet.getRows(); ++i) {
            HashMap map = new HashMap();
            for (int j = 0; j < titleList.size(); ++j) {
                if (!StringUtils.contains((CharSequence)((CharSequence)titleList.get(j)), (CharSequence)"\u5b9e\u6d4b") && !StringUtils.equals((CharSequence)"\u7269\u7406\u5c42\u6570", (CharSequence)((CharSequence)titleList.get(j))) && !StringUtils.equals((CharSequence)"\u623f\u95f4\u53f7", (CharSequence)((CharSequence)titleList.get(j))) && !StringUtils.equals((CharSequence)"\u5355\u5143\u53f7", (CharSequence)((CharSequence)titleList.get(j)))) continue;
                map.put(titleList.get(j), dataSheet.getCell(j, i).getContents());
            }
            if (!MapUtils.isNotEmpty(map)) continue;
            hsList.add(map);
        }
        return hsList;
    }
}

