/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.building.ui.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.VerticalAlignment;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.apache.commons.lang3.StringUtils;

public class ExportLpb {
    private static final Map<String, String> EXPORT_COLUMN = new LinkedHashMap();

    public static void exportExcel(String fileName, List<Map<String, Object>> exportLpb, HttpServletResponse response) throws WriteException, IOException {
        ServletOutputStream os = response.getOutputStream();
        response.reset();
        response.setHeader("Content-disposition", "attachment; filename=" + new String(fileName.getBytes("GB2312"), "ISO8859-1"));
        response.setContentType("application/msexcel");
        WritableWorkbook workbook = Workbook.createWorkbook((OutputStream)os);
        WritableSheet sheet = workbook.createSheet("Sheet1", 0);
        WritableFont boldFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        WritableCellFormat wcfCenter = new WritableCellFormat(boldFont);
        wcfCenter.setBorder(Border.ALL, BorderLineStyle.THIN);
        wcfCenter.setVerticalAlignment(VerticalAlignment.CENTRE);
        wcfCenter.setAlignment(Alignment.CENTRE);
        wcfCenter.setWrap(false);
        WritableFont normalFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        WritableCellFormat wcfLeft = new WritableCellFormat(normalFont);
        wcfLeft.setBorder(Border.NONE, BorderLineStyle.THIN);
        wcfLeft.setVerticalAlignment(VerticalAlignment.CENTRE);
        wcfLeft.setAlignment(Alignment.CENTRE);
        wcfLeft.setWrap(false);
        int a = 0;
        for (String name : EXPORT_COLUMN.keySet()) {
            sheet.addCell((WritableCell)new Label(a, 0, name, (CellFormat)wcfCenter));
            sheet.setColumnView(a, 20);
            ++a;
        }
        int rownum = 1;
        for (Map<String, Object> fwhsMap : exportLpb) {
            int colnum = 0;
            for (Map.Entry entry : EXPORT_COLUMN.entrySet()) {
                Object value = entry.getValue();
                String cellValue = String.valueOf(fwhsMap.get(value));
                if (!StringUtils.equals((CharSequence)cellValue, (CharSequence)"null")) {
                    sheet.addCell((WritableCell)new Label(colnum, rownum, cellValue, (CellFormat)wcfLeft));
                }
                ++colnum;
            }
            ++rownum;
        }
        workbook.write();
        workbook.close();
    }

    static {
        EXPORT_COLUMN.put("\u7269\u7406\u5c42\u6570", "wlcs");
        EXPORT_COLUMN.put("\u5b9a\u4e49\u5c42\u6570", "dycs");
        EXPORT_COLUMN.put("\u623f\u95f4\u53f7", "fjh");
        EXPORT_COLUMN.put("\u5355\u5143\u53f7", "dyh");
        EXPORT_COLUMN.put("\u623f\u5c4b\u7f16\u7801", "fwbm");
        EXPORT_COLUMN.put("\u5e62\u53f7", "zh");
        EXPORT_COLUMN.put("\u6743\u5229id", "qlid");
        EXPORT_COLUMN.put("\u5c42\u53f7", "ch");
        EXPORT_COLUMN.put("\u4e0d\u52a8\u4ea7\u5355\u5143\u623f\u5c4b\u7c7b\u578b", "bdcdyfwlx");
        EXPORT_COLUMN.put("\u53c2\u4e0e\u5206\u644a\u571f\u5730\u9762\u79ef\u8ba1\u7b97", "syfttdmjjs");
        EXPORT_COLUMN.put("\u5171\u6709\u571f\u5730\u9762\u79ef(\u33a1)", "gytdmj");
        EXPORT_COLUMN.put("\u5206\u644a\u571f\u5730\u9762\u79ef(\u33a1)", "fttdmj");
        EXPORT_COLUMN.put("\u72ec\u7528\u571f\u5730\u9762\u79ef(\u33a1)", "dytdmj");
        EXPORT_COLUMN.put("\u9884\u6d4b\u5efa\u7b51\u9762\u79ef(\u33a1)", "ycjzmj");
        EXPORT_COLUMN.put("\u9884\u6d4b\u5957\u5185\u5efa\u7b51\u9762\u79ef(\u33a1)", "yctnjzmj");
        EXPORT_COLUMN.put("\u9884\u6d4b\u5206\u644a\u5efa\u7b51\u9762\u79ef(\u33a1)", "ycftjzmj");
        EXPORT_COLUMN.put("\u9884\u6d4b\u5730\u4e0b\u90e8\u5206\u5efa\u7b51\u9762\u79ef(\u33a1)", "ycdxbfjzmj");
        EXPORT_COLUMN.put("\u9884\u6d4b\u5176\u4ed6\u5efa\u7b51\u9762\u79ef(\u33a1)", "ycqtjzmj");
        EXPORT_COLUMN.put("\u9884\u6d4b\u5206\u644a\u7cfb\u6570", "ycftxs");
        EXPORT_COLUMN.put("\u5b9e\u6d4b\u5efa\u7b51\u9762\u79ef(\u33a1)", "scjzmj");
        EXPORT_COLUMN.put("\u5b9e\u6d4b\u5957\u5185\u5efa\u7b51\u9762\u79ef(\u33a1)", "sctnjzmj");
        EXPORT_COLUMN.put("\u5b9e\u6d4b\u5206\u644a\u5efa\u7b51\u9762\u79ef(\u33a1)", "scftjzmj");
        EXPORT_COLUMN.put("\u5b9e\u6d4b\u5730\u4e0b\u90e8\u5206\u5efa\u7b51\u9762\u79ef(\u33a1)", "scdxbfjzmj");
        EXPORT_COLUMN.put("\u5b9e\u6d4b\u5176\u4ed6\u5efa\u7b51\u9762\u79ef(\u33a1)", "scqtjzmj");
        EXPORT_COLUMN.put("\u5b9e\u6d4b\u5206\u644a\u7cfb\u6570", "scftxs");
        EXPORT_COLUMN.put("\u5750\u843d", "zl");
        EXPORT_COLUMN.put("\u4ea4\u6613\u4ef7\u683c(\u4e07\u5143)", "jyjg");
        EXPORT_COLUMN.put("\u89c4\u5212\u7528\u9014", "ghyt");
        EXPORT_COLUMN.put("\u623f\u5c4b\u7c7b\u578b", "fwlx");
        EXPORT_COLUMN.put("\u623f\u5c4b\u7ed3\u6784", "fwjg");
        EXPORT_COLUMN.put("\u623f\u5c4b\u6237\u578b", "fwhx");
        EXPORT_COLUMN.put("\u6237\u578b\u7ed3\u6784", "hxjg");
        EXPORT_COLUMN.put("\u7ae3\u5de5\u65f6\u95f4", "jgrq");
        EXPORT_COLUMN.put("\u623f\u5c4b\u6027\u8d28", "fwxz");
        EXPORT_COLUMN.put("\u5efa\u6210\u65f6\u88c5\u4fee\u7a0b\u5ea6", "jczxcd");
        EXPORT_COLUMN.put("\u4e1c", "d");
        EXPORT_COLUMN.put("\u5357", "n");
        EXPORT_COLUMN.put("\u897f", "x");
        EXPORT_COLUMN.put("\u5317", "b");
        EXPORT_COLUMN.put("\u4ea7\u6743\u6765\u6e90", "cqly");
        EXPORT_COLUMN.put("\u5171\u6709\u60c5\u51b5", "gyqk");
        EXPORT_COLUMN.put("\u9644\u52a0\u8bf4\u660e", "fjsm");
        EXPORT_COLUMN.put("\u8c03\u67e5\u610f\u89c1", "dcyj");
        EXPORT_COLUMN.put("\u8c03\u67e5\u8005", "dcz");
        EXPORT_COLUMN.put("\u8c03\u67e5\u65f6\u95f4", "dcsj");
        EXPORT_COLUMN.put("\u90ae\u653f\u7f16\u7801", "yzbm");
        EXPORT_COLUMN.put("\u5408\u5e76\u65b9\u5411", "hbfx");
        EXPORT_COLUMN.put("\u5408\u5e76\u6237\u5ba4\u6570", "hbhss");
        EXPORT_COLUMN.put("\u529e\u7406\u72b6\u6001", "blzt");
        EXPORT_COLUMN.put("\u6743\u5229\u72b6\u6001", "qlzt");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba1", "qlr1");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u7f16\u78011", "qlrbm1");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u8bc1\u4ef6\u7c7b\u578b1", "qlrzjlx1");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u8bc1\u4ef6\u53f71", "qlrzjh1");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u6027\u8d281", "qlrxz1");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba2", "qlr2");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u7f16\u78012", "qlrbm2");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u8bc1\u4ef6\u7c7b\u578b2", "qlrzlx2");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u8bc1\u4ef6\u53f72", "qlrzjh2");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u6027\u8d282", "qlrxz2");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba3", "qlr3");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u7f16\u78013", "qlrbm3");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u8bc1\u4ef6\u7c7b\u578b3", "qlrzlx3");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u8bc1\u4ef6\u53f73", "qlrzjh3");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u6027\u8d283", "qlrxz3");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba4", "qlr4");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u7f16\u78014", "qlrbm4");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u8bc1\u4ef6\u7c7b\u578b4", "qlrzjlx4");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u8bc1\u4ef6\u53f74", "qlrzjh4");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u6027\u8d284", "qlrxz4");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba5", "qlr5");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u7f16\u78015", "qlrbm5");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u8bc1\u4ef6\u7c7b\u578b5", "qlrzjlx5");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u8bc1\u4ef6\u53f75", "qlrzjh5");
        EXPORT_COLUMN.put("\u6743\u5229\u4eba\u6027\u8d285", "qlrxz5");
    }
}

