package cn.gtmap.onething.util;

import cn.gtmap.onething.entity.bo.OnethingConfig;
import cn.gtmap.onething.entity.dto.result.OnethingResultDTO;
import cn.gtmap.onething.entity.dto.token.TokenDTO;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.MapUtils;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月10日
 * @description
 */
public class TokenUtil {

    public static String getToken() {
        String token = null;
        OnethingConfig config = PropertiesLoadUtil.loadOnethingConfigFromJson();
        String tokenUrl = config.getServiceAddress() + "/api/v1/token";
        TokenDTO tokenDTO = new TokenDTO(config.getTokenXzqdm(), config.getTokenUsername(), config.getTokenPassword());
        String result = HttpUtil.sendPost(tokenUrl, null, "一件事-获取token", JSON.toJSONString(tokenDTO), null, null);
        OnethingResultDTO onethingResultDTO = JSON.parseObject(result, OnethingResultDTO.class);
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(onethingResultDTO.getData()));
        token = MapUtils.getString(jsonObject, "token");
        return token;
    }
}
