package cn.gtmap.onething.util;

import cn.gtmap.onething.exception.OnethingException;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月08日
 * @description
 */
public class HttpUtil {
    public static final Logger log = Logger.getLogger(HttpUtil.class);

    public static String sendPost(String url, HashMap<String, String> headers, String jkms, String params, Integer connectionTimeout, Integer readTimeout) {
        log.info("一件事推送-调用" + jkms + ",url:" + url + ",headers:" + JSON.toJSONString(headers) + ",params:" + params);
        String result = null;
        CloseableHttpClient httpClient = null;
        try {
            // 创建HttpClient
            httpClient = HttpClients.createDefault();
            // 创建HttpPost请求
            HttpPost httpPost = new HttpPost(url);
            // 设置超时时间
            if (connectionTimeout != null) {
                RequestConfig connectTimeoutConfig = RequestConfig.custom().setConnectTimeout(connectionTimeout).build();
                httpPost.setConfig(connectTimeoutConfig);
            }
            if (readTimeout != null) {
                RequestConfig readTimeoutConfig = RequestConfig.custom().setSocketTimeout(readTimeout).build();
                httpPost.setConfig(readTimeoutConfig);
            }
            // 设置请求头
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
            httpPost.setHeader("Accept", "application/json");
            // 设置请求参数
            StringEntity paramEntity = new StringEntity(params, StandardCharsets.UTF_8);
            httpPost.setEntity(paramEntity);
            // 执行请求
            CloseableHttpResponse response = httpClient.execute(httpPost);
            // 解析响应
            result = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
        } catch (Exception e) {
            log.error("一件事推送-" + jkms + "调用失败,url:" + url + ",headers:" + JSON.toJSONString(headers) + "params:" + params, e);
            throw new OnethingException(9999, jkms + "调用失败");
        } finally {
            if (httpClient != null) {
                // 关闭连接
                try {
                    httpClient.close();
                } catch (IOException e) {
                    log.error("一件事推送-" + jkms + "关闭httpClient失败,url:" + url + ",headers:" + JSON.toJSONString(headers) + "params:" + params, e);
                    throw new OnethingException(9999, jkms + "关闭httpClient失败");
                }
            }
        }

        log.info("调用" + jkms + "完成,url:" + url + ",params:" + params + ",出参:" + result);
        if (StringUtils.isBlank(result)) {
            log.error("一件事推送-" + jkms + "调用失败,url:" + url + ",headers:" + JSON.toJSONString(headers) + "接口返回内容为空" + "params:" + params);
            throw new OnethingException(9999, jkms + "接口返回内容为空");
        }
        return result;

    }

}
