package cn.gtmap.onething.entity.dto.onething.sl;

import cn.gtmap.onething.entity.bo.OnethingExtinfo;
import cn.gtmap.onething.entity.bo.oneting.sl.YjsSl;
import cn.gtmap.onething.util.StringUtil;
import lombok.Data;

import java.time.LocalDate;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月10日
 * @description
 */
@Data
public class SlAcceptinfo {
    private String no;
    private String areaNo;
    private String areaName;
    private String yearFlag;
    private String jointCode;
    private String onethingCode;
    private String acceptDate;
    private String acceptDeptCode;
    private String acceptUserName;
    private OnethingExtinfo extInfo;

    public SlAcceptinfo(YjsSl yjsSl) {
        this.areaNo = StringUtil.padZero(yjsSl.getXzqdm(), 12);
        LocalDate currentDate = LocalDate.now();
        int currentYear = currentDate.getYear();
        this.yearFlag = String.valueOf(currentYear);
        this.acceptDate = yjsSl.getAcceptinfo().getAcceptDate();
        this.acceptDeptCode = yjsSl.getAcceptinfo().getAcceptDeptCode();
        this.acceptUserName = yjsSl.getAcceptinfo().getAcceptUserName();
        this.extInfo = yjsSl.getExtInfo();
    }
}
