package cn.gtmap.onething.entity.dto.onething.sb;

import cn.gtmap.onething.entity.bo.OnethingConfig;
import cn.gtmap.onething.entity.bo.oneting.sb.YjsSb;
import cn.gtmap.onething.entity.bo.oneting.sb.YjsSbProject;
import cn.gtmap.onething.util.LshUtil;
import cn.gtmap.onething.util.StringUtil;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月10日
 * @description
 */
@Data
public class SbProject {
    private String areaNo;
    private String areaName;
    private String dept_yw_name;
    private String dept_yw_reg_no;
    private String local_itemcode;
    private String internal_no;
    private String dept_ql_reg_no;
    private String dept_ql_name;
    private String org_id;
    private String org_name;
    private String department;
    private String anticipate;
    private String anticipate_day_type;
    private String promise;
    private String promise_type;
    private String catalog_code;
    private String task_version;
    private String formUrl;
    private SbForms forms;
    private SbFormsBrief formsBrief;
    private List<SbProjectMaterial> projectMaterialList;

    public SbProject(YjsSb yjsSb, YjsSbProject yjsSbProject) {
        OnethingConfig config = yjsSb.getOnethingConfig();
        String orgId = yjsSbProject.getOrg_id();
        String onethingCode = yjsSb.getApplyInfo().getOnethingCode();

        this.areaNo = StringUtil.padZero(yjsSb.getAreaNo(), 12);
        this.areaName = yjsSb.getAreaName();
        //全省办件唯一编号
        this.internal_no = LshUtil.getOnetingInternalNo(orgId, onethingCode, config);
        this.org_id = config.getRealOrgId(orgId);
        this.dept_ql_reg_no = config.getDeptQlRegNo(orgId);
        this.dept_ql_name = config.getDeptQlName(orgId);
        this.dept_yw_name = config.getDeptYwName(orgId);
        this.dept_yw_reg_no = config.getDeptYwRegNo(orgId);
        this.org_name = config.getOrgName(orgId);
        this.catalog_code = config.getCatalogCode(orgId);
        this.task_version = config.getTaskVersion(orgId);
        this.anticipate = config.getAnticipate(orgId, onethingCode);
        this.anticipate_day_type = config.getAnticipateDayType(orgId, onethingCode);
        this.promise = config.getPromise(orgId, onethingCode);
        this.promise_type = config.getPromiseType(orgId, onethingCode);
        this.formsBrief = new SbFormsBrief();
        this.forms = new SbForms();
        this.projectMaterialList = new ArrayList<>();
    }
}
