package cn.gtmap.onething.entity.dto.onething.sb;

import cn.gtmap.onething.entity.bo.oneting.sb.YjsSb;
import cn.gtmap.onething.entity.bo.oneting.sb.YjsSbProject;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月10日
 * @description
 */
@Data
public class SbParams {

    private SbApplyInfo applyInfo;

    private List<SbProject> projectList;

    private List<SbMaterial> materialList;

    public SbParams(YjsSb yjsSb) {
        initApplyInfo(yjsSb);
        initProjectList(yjsSb);
        this.materialList = new ArrayList<>();
    }

    public void initApplyInfo(YjsSb yjsSb) {
        this.applyInfo = new SbApplyInfo(yjsSb);
    }

    public void initProjectList(YjsSb yjsSb) {
        List<SbProject> projectList = new ArrayList<>();
        List<YjsSbProject> yjsSbProjectList = yjsSb.getYjsSbProjectList();
        if (CollectionUtils.isNotEmpty(yjsSbProjectList)) {
            for (YjsSbProject yjsSbProject : yjsSbProjectList) {
                SbProject sbProject = new SbProject(yjsSb, yjsSbProject);
                projectList.add(sbProject);
            }
        }
        this.projectList = projectList;
    }

}
