package cn.gtmap.onething.entity.dto.onematter.sp;

import cn.gtmap.onething.entity.bo.OnethingConfig;
import cn.gtmap.onething.entity.bo.onematter.sp.DsxSp;
import cn.gtmap.onething.entity.bo.onematter.sp.DsxSpProject;
import lombok.Data;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月11日
 * @description
 */
@Data
public class OmSpProject {
    private String no;
    private String jointCode;
    private String internal_no;
    private String taskHandleItem;
    private String local_itemcode;
    private String opinion;
    private String org_id;
    private OmSpProjectInfo projectinfo;
    public OmSpProject(DsxSp dsxSp, DsxSpProject dsxSpProject) {
        String orgId = dsxSp.getProjectlist().get(0).getOrg_id();
        OnethingConfig config = dsxSp.getOnethingConfig();
        this.taskHandleItem = config.getTaskHandleItem(orgId);
        this.org_id = config.getRealOrgId(orgId);
        this.projectinfo = new OmSpProjectInfo(config,dsxSpProject);
    }
}
