package cn.gtmap.onething.entity.dto.onematter.sl;

import cn.gtmap.onething.entity.bo.OnethingConfig;
import cn.gtmap.onething.entity.bo.onematter.sjsl.DsxSjSl;
import cn.gtmap.onething.entity.bo.onematter.sjsl.DsxSjSlProject;
import cn.gtmap.onething.entity.dto.onematter.sj.OmSjProjectinfo;
import cn.gtmap.onething.util.StringUtil;
import com.gtis.common.util.UUIDGenerator;
import lombok.Data;

import java.time.LocalDate;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月10日
 * @description
 */
@Data
public class OmSlProject {
    private String no;
    private String jointCode;
    private String internal_no;
    private String area_no;
    private String area_name;
    private String pro_year;
    private String taskHandleItem;
    private String local_itemcode;
    private OmSlProjectinfo projectinfo;

    public OmSlProject(DsxSjSl dsxSjSl, DsxSjSlProject dsxSjSlProject) {
        this.area_no = StringUtil.padZero(dsxSjSl.getAreaNo(), 12);
        this.area_name = dsxSjSl.getAreaName();
        LocalDate currentDate = LocalDate.now();
        int currentYear = currentDate.getYear();
        this.pro_year = String.valueOf(currentYear);
        String orgId = dsxSjSl.getProjectlist().get(0).getBasicinfo().getOrg_id();
        OnethingConfig config = dsxSjSl.getOnethingConfig();
        this.taskHandleItem = config.getTaskHandleItem(orgId);
        this.projectinfo = new OmSlProjectinfo(dsxSjSl,dsxSjSlProject);
    }
}
