package cn.gtmap.onething.entity.dto.onematter.sjsl;

import cn.gtmap.onething.entity.bo.onematter.sjsl.DsxSjSl;
import cn.gtmap.onething.entity.dto.OnethingRequestDTO;
import cn.gtmap.onething.entity.dto.OnethingRequestHeadDTO;
import cn.gtmap.onething.entity.dto.onematter.sj.OneMatterSjDTO;
import cn.gtmap.onething.entity.dto.onematter.sl.OneMatterSlDTO;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月09日
 * @description
 */
@Data
public class OneMatterSjSlDTO extends OnethingRequestDTO {

    private OneMatterSjDTO sjDTO;

    private OneMatterSlDTO slDTO;

    public OneMatterSjSlDTO(DsxSjSl dsxSjSl) {
        this.sjDTO = new OneMatterSjDTO(dsxSjSl);
        this.slDTO = new OneMatterSlDTO(dsxSjSl);
    }

    public OneMatterSjSlDTO(DsxSjSl dsxSjSl, String type) {
        if (StringUtils.equals(type, "sj")) {
            this.sjDTO = new OneMatterSjDTO(dsxSjSl);
        } else {
            this.slDTO = new OneMatterSlDTO(dsxSjSl);
        }
    }
}
