package cn.gtmap.onething.entity.bo.onematter.sp;

import cn.gtmap.estateplat.noemptyannotion.noempty.NoEmptyExecutor;
import cn.gtmap.estateplat.noemptyannotion.noempty.annotion.NoEmpty;
import cn.gtmap.onething.entity.bo.OnethingRequest;
import cn.gtmap.onething.entity.dto.onematter.sp.OmSpProcess;
import cn.gtmap.onething.entity.dto.onematter.sp.OneMatterSpDTO;
import cn.gtmap.onething.entity.dto.result.OnethingResultDTO;
import cn.gtmap.onething.util.HttpUtil;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月09日
 * @description 单事项审批接口
 */
@Data
public class DsxSp extends OnethingRequest<DsxSpResult> {
    public static final Logger log = Logger.getLogger(DsxSp.class);
    /**
     * 行政区划编码
     */
    @NoEmpty(fieldExplain = "行政区划编码")
    private String xzqdm;

    @Valid
    @NoEmpty(fieldExplain = "projectlist")
    private List<DsxSpProject> projectlist;

    @Override
    public DsxSpResult execute() {
        //验证必填字段
//        NoEmptyExecutor.validate(this).execute();
        this.setJkms("单事项审批接口");
        String url = this.getOnethingConfig().getServiceAddress() + "/api/v1/pushApproveProjectInfo";
        //初始化DTO 作为入参
        OneMatterSpDTO oneMatterSpDTO = new OneMatterSpDTO(this);
        String result = HttpUtil.sendPost(url, this.getHeaders(), this.getJkms(), JSON.toJSONString(oneMatterSpDTO), this.getConnectionTimeout(), this.getReadTimeout());
        OnethingResultDTO onethingResultDTO = JSON.parseObject(result, OnethingResultDTO.class);
        DsxSpResult dsxSpResult = new DsxSpResult();
        //入参中获取
        List<OmSpProcess> processlist = oneMatterSpDTO.getData().getParams().getProjectlist().get(0).getProjectinfo().getProcesslist();
        List<DsxSpProcessResult> processlistReturn = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(processlist)) {
            for (OmSpProcess omSpProcess : processlist) {
                DsxSpProcessResult dsxSpProcessResult = new DsxSpProcessResult(omSpProcess);
                processlistReturn.add(dsxSpProcessResult);
            }
        }
        dsxSpResult.setProcesslist(processlistReturn);
        dsxSpResult.setCode(onethingResultDTO.getHead().getCode());
        dsxSpResult.setMsg(onethingResultDTO.getHead().getMsg());
        dsxSpResult.setOnethingRequestParam(oneMatterSpDTO);
        dsxSpResult.setOnethingResultDTO(onethingResultDTO);
        log.info("单事项审批接口-最终结果:" + JSON.toJSONString(dsxSpResult));
        return dsxSpResult;
    }
}
