package cn.gtmap.onething.entity.bo;

import cn.gtmap.onething.exception.OnethingException;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月09日
 * @description
 */
@Data
public class OnethingConfig {

    private String serviceAddress;

    private String tokenUsername;

    private String tokenPassword;

    private String tokenXzqdm;

    private String xscjdm;

    private List<OnethingConfigOrgInfo> orgInfo;

    private List<OnethingConfigInfo> onethingInfo;

    public OnethingConfig() {

    }

    public String getOnethingName(String onethingCode) {
        String onethingName = null;
        if (CollectionUtils.isNotEmpty(this.onethingInfo)) {
            for (OnethingConfigInfo onethingConfigInfo : this.onethingInfo) {
                if (StringUtils.equals(onethingCode, onethingConfigInfo.getCode())) {
                    onethingName = onethingConfigInfo.getName();
                    break;
                }
            }
        }
        if (StringUtils.isBlank(onethingName)) {
            throw new OnethingException(9999, "onethingCode:" + onethingCode + ",json配置中没有对应onethingName");
        }
        return onethingName;
    }

    public String getAnticipate(String orgId, String onethingCode) {
        String anticipate = null;
        if (CollectionUtils.isNotEmpty(this.orgInfo)) {
            for (OnethingConfigOrgInfo onethingConfigOrgInfo : this.orgInfo) {
                if (StringUtils.equals(orgId, onethingConfigOrgInfo.getOrgId())) {
                    List<OnethingConfigDetailInfo> onethingDetailInfoList = onethingConfigOrgInfo.getOnethingDetailInfo();
                    if (CollectionUtils.isNotEmpty(onethingDetailInfoList)) {
                        for (OnethingConfigDetailInfo onethingConfigDetailInfo : onethingDetailInfoList) {
                            if (StringUtils.equals(onethingCode, onethingConfigDetailInfo.getOnethingCode())) {
                                anticipate = onethingConfigDetailInfo.getAnticipate();
                            }
                        }
                    }
                    if (StringUtils.isNotBlank(anticipate)) {
                        break;
                    }
                }
            }
        }
        if (StringUtils.isBlank(anticipate)) {
            throw new OnethingException(9999, "orgId:" + orgId + ",onethingCode:" + onethingCode + ",json配置中没有对应anticipate");
        }
        return anticipate;
    }

    public String getAnticipateDayType(String orgId, String onethingCode) {
        String anticipateDayType = null;
        if (CollectionUtils.isNotEmpty(this.orgInfo)) {
            for (OnethingConfigOrgInfo onethingConfigOrgInfo : this.orgInfo) {
                if (StringUtils.equals(orgId, onethingConfigOrgInfo.getOrgId())) {
                    List<OnethingConfigDetailInfo> onethingDetailInfoList = onethingConfigOrgInfo.getOnethingDetailInfo();
                    if (CollectionUtils.isNotEmpty(onethingDetailInfoList)) {
                        for (OnethingConfigDetailInfo onethingConfigDetailInfo : onethingDetailInfoList) {
                            if (StringUtils.equals(onethingCode, onethingConfigDetailInfo.getOnethingCode())) {
                                anticipateDayType = onethingConfigDetailInfo.getAnticipate_day_type();
                            }
                        }
                    }
                    if (StringUtils.isNotBlank(anticipateDayType)) {
                        break;
                    }
                }
            }
        }
        if (StringUtils.isBlank(anticipateDayType)) {
            throw new OnethingException(9999, "orgId:" + orgId + ",onethingCode:" + onethingCode + ",json配置中没有对应anticipateDayType");
        }
        return anticipateDayType;
    }


    public String getPromise(String orgId, String onethingCode) {
        String promise = null;
        if (CollectionUtils.isNotEmpty(this.orgInfo)) {
            for (OnethingConfigOrgInfo onethingConfigOrgInfo : this.orgInfo) {
                if (StringUtils.equals(orgId, onethingConfigOrgInfo.getOrgId())) {
                    List<OnethingConfigDetailInfo> onethingDetailInfoList = onethingConfigOrgInfo.getOnethingDetailInfo();
                    if (CollectionUtils.isNotEmpty(onethingDetailInfoList)) {
                        for (OnethingConfigDetailInfo onethingConfigDetailInfo : onethingDetailInfoList) {
                            if (StringUtils.equals(onethingCode, onethingConfigDetailInfo.getOnethingCode())) {
                                promise = onethingConfigDetailInfo.getPromise();
                            }
                        }
                    }
                    if (StringUtils.isNotBlank(promise)) {
                        break;
                    }
                }
            }
        }
        if (StringUtils.isBlank(promise)) {
            throw new OnethingException(9999, "orgId:" + orgId + ",onethingCode:" + onethingCode + ",json配置中没有对应promise");
        }
        return promise;
    }

    public String getPromiseType(String orgId, String onethingCode) {
        String promiseType = null;
        if (CollectionUtils.isNotEmpty(this.orgInfo)) {
            for (OnethingConfigOrgInfo onethingConfigOrgInfo : this.orgInfo) {
                if (StringUtils.equals(orgId, onethingConfigOrgInfo.getOrgId())) {
                    List<OnethingConfigDetailInfo> onethingDetailInfoList = onethingConfigOrgInfo.getOnethingDetailInfo();
                    if (CollectionUtils.isNotEmpty(onethingDetailInfoList)) {
                        for (OnethingConfigDetailInfo onethingConfigDetailInfo : onethingDetailInfoList) {
                            if (StringUtils.equals(onethingCode, onethingConfigDetailInfo.getOnethingCode())) {
                                promiseType = onethingConfigDetailInfo.getPromise_type();
                            }
                        }
                    }
                    if (StringUtils.isNotBlank(promiseType)) {
                        break;
                    }
                }
            }
        }
        if (StringUtils.isBlank(promiseType)) {
            throw new OnethingException(9999, "orgId:" + orgId + ",onethingCode:" + onethingCode + ",json配置中没有对应promiseType");
        }
        return promiseType;
    }


    public String getDeptQlRegNo(String orgId) {
        String deptQlRegNo = null;
        if (CollectionUtils.isNotEmpty(this.orgInfo)) {
            for (OnethingConfigOrgInfo onethingConfigOrgInfo : this.orgInfo) {
                if (StringUtils.equals(orgId, onethingConfigOrgInfo.getOrgId())) {
                    deptQlRegNo = onethingConfigOrgInfo.getDept_ql_reg_no();
                    break;
                }
            }
        }
        if (StringUtils.isBlank(deptQlRegNo)) {
            throw new OnethingException(9999, "orgId:" + orgId + ",json配置中没有对应deptQlRegNo");
        }
        return deptQlRegNo;
    }

    public String getDeptQlName(String orgId) {
        String deptQlName = null;
        if (CollectionUtils.isNotEmpty(this.orgInfo)) {
            for (OnethingConfigOrgInfo onethingConfigOrgInfo : this.orgInfo) {
                if (StringUtils.equals(orgId, onethingConfigOrgInfo.getOrgId())) {
                    deptQlName = onethingConfigOrgInfo.getDept_ql_name();
                    break;
                }
            }
        }
        if (StringUtils.isBlank(deptQlName)) {
            throw new OnethingException(9999, "orgId:" + orgId + ",json配置中没有对应deptQlName");
        }
        return deptQlName;
    }

    public String getDeptYwName(String orgId) {
        String deptYwName = null;
        if (CollectionUtils.isNotEmpty(this.orgInfo)) {
            for (OnethingConfigOrgInfo onethingConfigOrgInfo : this.orgInfo) {
                if (StringUtils.equals(orgId, onethingConfigOrgInfo.getOrgId())) {
                    deptYwName = onethingConfigOrgInfo.getDept_yw_name();
                    break;
                }
            }
        }
        if (StringUtils.isBlank(deptYwName)) {
            throw new OnethingException(9999, "orgId:" + orgId + ",json配置中没有对应deptYwName");
        }
        return deptYwName;
    }

    public String getDeptYwRegNo(String orgId) {
        String deptYwRegNo = null;
        if (CollectionUtils.isNotEmpty(this.orgInfo)) {
            for (OnethingConfigOrgInfo onethingConfigOrgInfo : this.orgInfo) {
                if (StringUtils.equals(orgId, onethingConfigOrgInfo.getOrgId())) {
                    deptYwRegNo = onethingConfigOrgInfo.getDept_yw_reg_no();
                    break;
                }
            }
        }
        if (StringUtils.isBlank(deptYwRegNo)) {
            throw new OnethingException(9999, "orgId:" + orgId + ",json配置中没有对应deptYwRegNo");
        }
        return deptYwRegNo;
    }

    public String getOrgName(String orgId) {
        String orgName = null;
        if (CollectionUtils.isNotEmpty(this.orgInfo)) {
            for (OnethingConfigOrgInfo onethingConfigOrgInfo : this.orgInfo) {
                if (StringUtils.equals(orgId, onethingConfigOrgInfo.getOrgId())) {
                    orgName = onethingConfigOrgInfo.getOrgName();
                    break;
                }
            }
        }
        if (StringUtils.isBlank(orgName)) {
            throw new OnethingException(9999, "orgId:" + orgId + ",json配置中没有对应orgName");
        }
        return orgName;
    }

    public String getTaskHandleItem(String orgId) {
        String taskHandleItem = null;
        if (CollectionUtils.isNotEmpty(this.orgInfo)) {
            for (OnethingConfigOrgInfo onethingConfigOrgInfo : this.orgInfo) {
                if (StringUtils.equals(orgId, onethingConfigOrgInfo.getOrgId())) {
                    taskHandleItem = onethingConfigOrgInfo.getTaskHandleItem();
                    break;
                }
            }
        }
        if (StringUtils.isBlank(taskHandleItem)) {
            throw new OnethingException(9999, "orgId:" + orgId + ",json配置中没有对应taskHandleItem");
        }
        return taskHandleItem;
    }

    public String getIdNumber(String orgId) {
        String idNumber = null;
        if (CollectionUtils.isNotEmpty(this.orgInfo)) {
            for (OnethingConfigOrgInfo onethingConfigOrgInfo : this.orgInfo) {
                if (StringUtils.equals(orgId, onethingConfigOrgInfo.getOrgId())) {
                    idNumber = onethingConfigOrgInfo.getIdNumber();
                    break;
                }
            }
        }
        if (StringUtils.isBlank(idNumber)) {
            throw new OnethingException(9999, "orgId:" + orgId + ",json配置中没有对应idNumber");
        }
        return idNumber;
    }

    public String getCatalogCode(String orgId) {
        String catalogCode = null;
        if (CollectionUtils.isNotEmpty(this.orgInfo)) {
            for (OnethingConfigOrgInfo onethingConfigOrgInfo : this.orgInfo) {
                if (StringUtils.equals(orgId, onethingConfigOrgInfo.getOrgId())) {
                    catalogCode = onethingConfigOrgInfo.getCatalog_code();
                    break;
                }
            }
        }
        if (StringUtils.isBlank(catalogCode)) {
            throw new OnethingException(9999, "orgId:" + orgId + ",json配置中没有对应catalogCode");
        }
        return catalogCode;
    }

    public String getTaskVersion(String orgId) {
        String taskVersion = null;
        if (CollectionUtils.isNotEmpty(this.orgInfo)) {
            for (OnethingConfigOrgInfo onethingConfigOrgInfo : this.orgInfo) {
                if (StringUtils.equals(orgId, onethingConfigOrgInfo.getOrgId())) {
                    taskVersion = onethingConfigOrgInfo.getTask_version();
                    break;
                }
            }
        }
        if (StringUtils.isBlank(taskVersion)) {
            throw new OnethingException(9999, "orgId:" + orgId + ",json配置中没有对应taskVersion");
        }
        return taskVersion;
    }

    public String getTransactAffairName(String orgId) {
        String transactAffairName = null;
        if (CollectionUtils.isNotEmpty(this.orgInfo)) {
            for (OnethingConfigOrgInfo onethingConfigOrgInfo : this.orgInfo) {
                if (StringUtils.equals(orgId, onethingConfigOrgInfo.getOrgId())) {
                    transactAffairName = onethingConfigOrgInfo.getTransact_affair_name();
                    break;
                }
            }
        }
        if (StringUtils.isBlank(transactAffairName)) {
            throw new OnethingException(9999, "orgId:" + orgId + ",json配置中没有对应transactAffairName");
        }
        return transactAffairName;
    }

    public String getDsxSpEndUsername(String orgId) {
        String dsxSpEndUsername = null;
        if (CollectionUtils.isNotEmpty(this.orgInfo)) {
            for (OnethingConfigOrgInfo onethingConfigOrgInfo : this.orgInfo) {
                if (StringUtils.equals(orgId, onethingConfigOrgInfo.getOrgId())) {
                    dsxSpEndUsername = onethingConfigOrgInfo.getDsxSpEndUsername();
                    break;
                }
            }
        }
        if (StringUtils.isBlank(dsxSpEndUsername)) {
            throw new OnethingException(9999, "orgId:" + orgId + ",json配置中没有对应dsxSpEndUsername");
        }
        return dsxSpEndUsername;
    }

    public String getRealOrgId(String orgId) {
        String realOrgId = orgId;
        if (CollectionUtils.isNotEmpty(this.orgInfo)) {
            for (OnethingConfigOrgInfo onethingConfigOrgInfo : this.orgInfo) {
                if (StringUtils.equals(orgId, onethingConfigOrgInfo.getOrgId())) {
                    if (StringUtils.isNotBlank(onethingConfigOrgInfo.getRealOrgId())) {
                        realOrgId = onethingConfigOrgInfo.getRealOrgId();
                    }
                    break;
                }
            }
        }
        return realOrgId;
    }
}
