$.infopane.show('地图初始化...');

var map
    , identifyTask
    , identifyParams
    , identifyRunner
    , symbol

flushWorkbench();		// workbench height
$(window).resize( flushWorkbench );

require(['gtmap/ctrl', 'esri/map'], function(ctrl, Map) {
	map = new Map('mainMap', {
		logo : false,
		sliderStyle : 'large'
	});

	ctrl.bindHandler();		// 保存导航操作事件绑定
	ctrl.loadLayers();		// 加载图层
	ctrl.loadGroupTree();	// 渲染左侧的树
	
	dojo.connect(map, 'onLoad', function() {
		symbol = new esri.symbol.SimpleMarkerSymbol();
		symbol.setStyle(esri.symbol.SimpleMarkerSymbol.STYLE_SQUARE);
		symbol.setSize(10);
		symbol.setColor(new dojo.Color([255, 255, 0, 0.5]));
	});

});
function flushWorkbench(){
  var workbenchId = 'mapCtn',
	  toolbars = '#toolbar,#hearder',
      selectors = toolbars.split(','),
      height = 0;
  _.each(selectors, function(item){
	height += $(item).height();
  });
  $('#'+workbenchId).height( $(window).height() - height );
  $('#leftCtn').height( $(window).height() - $('#hearder').height() );
}

function clearOverlay(){
  map.graphics.clear();
  map.infoWindow.hide();
  dojo.disconnect(identifyRunner);
}

function setNavSelect( obj ){
  var self = $(obj);
  self.parents('ul').children().removeClass('active');
  self.parent('li').addClass('active');
  
  $('.widget').fadeOut('fast');
  $('.widget').find('.esriButtonChecked').find('.dijitButtonNode').click();
  clearOverlay();
}

function setNavWithChildrenSelect( obj ){
  var self = $(obj);
  $( self.parents('li.open')[0] ).children('a').children('span').html( self.html() );
  setNavSelect( $( self.parents('li.open')[0] ).children('a') );
  clearOverlay();
}